/**
 * 
 */
package gov.va.med.imaging.musedatasource.v1;

import gov.va.med.GlobalArtifactIdentifier;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.WellKnownOID;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.MuseImageURN;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.conversion.ImageConversionFilePath;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.ImageNotFoundException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.Image;
import gov.va.med.imaging.exchange.business.ImageFormatQuality;
import gov.va.med.imaging.exchange.business.ImageFormatQualityList;
import gov.va.med.imaging.exchange.business.ImageStreamResponse;
import gov.va.med.imaging.exchange.enums.ImageFormat;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import gov.va.med.imaging.musedatasource.AbstractMuseImageDataSourceService;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.url.muse.MuseConnection;

import java.util.ArrayList;
import java.util.List;

/**
 * @author William Peterson
 *
 */
public class MuseImageDataSourceServiceV1 
extends AbstractMuseImageDataSourceService {

	
	public final static String MUSE_REQUIRED_VERSION = "8.0";
	private final static String DATASOURCE_VERSION = "1";
	//WFP-This is not correct.
	public final static String SUPPORTED_PROTOCOL = "vftp";

	private final MuseConnection museConnection;

	/**
	 * @param resolvedArtifactSource
	 * @param protocol
	 */
	public MuseImageDataSourceServiceV1(
			ResolvedArtifactSource resolvedArtifactSource, String protocol) {
		super(resolvedArtifactSource, protocol);
		
		museConnection = new MuseConnection(getMetadataUrl());

	}

	@Override
	public String getDataSourceVersion() {
		return DATASOURCE_VERSION;
	}

	@Override
	protected String getRequiredMuseVersion() {
		return MUSE_REQUIRED_VERSION;
	}

	//WFP-Implement this correctly.
	@Override
	public boolean isVersionCompatible() {
		// TODO Auto-generated method stub
		return super.isVersionCompatible();
	}

	@Override
	protected boolean canGetTextFile() {
		//Muse don't have text files.  Always false.
		return false;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.musedatasource.AbstractMuseImageDataSourceService#getImage(gov.va.med.GlobalArtifactIdentifier, gov.va.med.imaging.exchange.business.ImageFormatQualityList)
	 */
	@Override
	public ImageStreamResponse getImage(GlobalArtifactIdentifier gai,
			ImageFormatQualityList requestFormatQualityList)
			throws MethodException, ConnectionException {
		
		if(!(gai instanceof MuseImageURN)){
			throw new MethodException("URN is not for Muse.");
		}
		String imageId = gai.toString(SERIALIZATION_FORMAT.RAW);
		getLogger().info("getImage(" + imageId + ") from GlobalArtifactIdentifier TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");		
		
		ImageFormatQualityList queryFormatQualityList = new ImageFormatQualityList();
		queryFormatQualityList.addAll(requestFormatQualityList);
		//FederationConfiguration configuration = FederationDataSourceProvider.getFederationConfiguration();			
		//if(requestListNeedsCompression(queryFormatQualityList) && configuration.isAddCompressionForImageRequests() && isAllowAddFederationCompression())
		//{
		//	getLogger().info("requested image does not include compressed formats but can include them, adding to request to improve performance.");
			// yes this will work for conversion because the conversion type is not in the list
			// so it will force the image to be converted (i think...)		
			
		//	ImageQuality quality = queryFormatQualityList.getFirstImageQuality();
			
		//	ImageFormatQuality dicomJ2kQuality = 
		//		new ImageFormatQuality(ImageFormat.DICOMJPEG2000, quality);
		//	ImageFormatQuality j2kQuality = 
		//		new ImageFormatQuality(ImageFormat.J2K, quality);
			
			// add the values to the front of the list
		//	queryFormatQualityList.add(0, j2kQuality);
		//	queryFormatQualityList.add(0, dicomJ2kQuality);			
		//}

		// problem:  need to get the image and then determine if a conversion (frmo j2k to dicom)
		// is needed, but that needs to happen in image conversion
		// must send to storage facade with j2k, but can't send that to image conversion (crap)
		
		//getLogger().info("Query Format List [" + queryFormatQualityList.getAcceptString(false, true) + "]");
		//getLogger().info("Request Format List [" + requestFormatQualityList.getAcceptString(false, true) + "]");
		
		//boolean downloadTxtFile = false; // only get the text file if it is a VA image
		
		// if this data source implementation supports getting a text file, then determine if the image
		// requested might have a text file (only VA images)
		//if(canGetTextFile())
		//{		
			// JMW 12/3/2010 P104 - since the VIX now gets DoD images from the CVIX using the Federation
			// data source, it can't rely on the actual data source (Exchange or XCA) to not get the text file
			// so Federation has to be smart and realize there is no text file to get from the DoD
			// so set this downloadTxtFile parameter to true only if the image retrieving is a VA image
		//	if((WellKnownOID.VA_RADIOLOGY_IMAGE.isApplicable(gai.getHomeCommunityId())) ||
		//			(WellKnownOID.VA_DOCUMENT.isApplicable(gai.getHomeCommunityId())))
		//	{
		//		TransactionContextFactory.get().addDebugInformation("Including request for text file in response (if applicable)");
		//		downloadTxtFile = true;
		//	}
		//}
		
		List<ImageConversionFilePath> files = new ArrayList<ImageConversionFilePath>(1);
		files.add(new ImageConversionFilePath(imageId, null, null));

		ImageStreamResponse response = getImageConversion().getImage(files, 
			queryFormatQualityList, requestFormatQualityList, downloadTxtFile);
		return response;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.musedatasource.AbstractMuseImageDataSourceService#getImage(gov.va.med.imaging.exchange.business.Image, gov.va.med.imaging.exchange.business.ImageFormatQualityList)
	 */
	@Override
	public ImageStreamResponse getImage(Image image,
			ImageFormatQualityList requestFormatQualityList)
			throws MethodException, ConnectionException {
		ImageURN imageUrn = image.getImageUrn();// ImageURN.create(image.getSiteNumber(), image.getIen(), image.getStudyIen(), image.getPatientICN());
		return getImage(imageUrn, requestFormatQualityList);
	}

	/* (non-Javadoc) 
	 * 
	 * 
	 * 
	 * @see gov.va.med.imaging.musedatasource.AbstractMuseImageDataSourceService#getImageInformation(gov.va.med.imaging.AbstractImagingURN, boolean)
	 */
	@Override
	public String getImageInformation(AbstractImagingURN imagingUrn,
			boolean includeDeletedImages) throws MethodException,
			ConnectionException, ImageNotFoundException {
		getLogger().info("getImageInformation(" + imagingUrn.toString() + "), TransactionContext (" + 
				TransactionContextFactory.get().getDisplayIdentity() + ").");		
		String result = getProxy().getImageInformation(imagingUrn);
		TransactionContextFactory.get().setDataSourceBytesReceived(result == null ? 0L : result.length());
		getLogger().info("getImageInformation complete.");
		return result;	
	}
	

}
