/**
 * 
 */
package gov.va.med.imaging.musedatasource;

import gov.va.med.imaging.datasource.ImageDataSourceSpi;
import gov.va.med.imaging.datasource.PatientArtifactDataSourceSpi;
import gov.va.med.imaging.datasource.Provider;
import gov.va.med.imaging.datasource.ProviderService;
import gov.va.med.imaging.musedatasource.configuration.MuseConfiguration;
import gov.va.med.imaging.musedatasource.v1.MuseImageDataSourceServiceV1;
import gov.va.med.imaging.musedatasource.v1.MusePatientArtifactDataSourceServiceV1;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

import org.apache.log4j.Logger;

/**
 * @author William Peterson
 *
 */
public class MuseDataSourceProvider 
extends Provider {

	private static final String PROVIDER_NAME = "MuseDataSource";
	private static final double PROVIDER_VERSION = 1.0d;
	private static final String PROVIDER_INFO = "Implements: \nPatientArtifactDataSource, ImageDataSource SPI \n backed by a Muse data store.";

	private static final long serialVersionUID = 1L;
	private final static Logger logger = Logger.getLogger(MuseDataSourceProvider.class);
	private static MuseConfiguration museConfiguration = null;
	private final SortedSet<ProviderService> services;

	/**
	 * The public "nullary" constructor that is used by the ServiceLoader class
	 * to create instances.
	 */
	public MuseDataSourceProvider()
	{
		this(PROVIDER_NAME, PROVIDER_VERSION, PROVIDER_INFO);
	}
	
	/**
	 * A special constructor that is only used for creating a configuration
	 * file.
	 * 
	 * @param exchangeConfiguration
	 */
	private MuseDataSourceProvider(MuseConfiguration museConfiguration) 
	{
		this();
		MuseDataSourceProvider.museConfiguration = museConfiguration;
	}


	/**
	 * @param name
	 * @param version
	 * @param info
	 */
	public MuseDataSourceProvider(String name, double version, String info) {
		super(name, version, info);

		services = new TreeSet<ProviderService>();
		services.add(
			new ProviderService(
				this, 
				PatientArtifactDataSourceSpi.class, 
				MusePatientArtifactDataSourceServiceV1.SUPPORTED_PROTOCOL, 
				1.0F, 
				MusePatientArtifactDataSourceServiceV1.class)
		);
		services.add(
				new ProviderService(
					this, 
					ImageDataSourceSpi.class, 
					MuseImageDataSourceServiceV1.SUPPORTED_PROTOCOL, 
					1.0F, 
					MuseImageDataSourceServiceV1.class)
			);
					
		// load the ExchangeConfiguration if it exists
		synchronized(MuseDataSourceProvider.class)
	    {
			try
			{
				if(museConfiguration == null)
					museConfiguration = (MuseConfiguration)loadConfiguration();
			}
			catch(ClassCastException ccX)
			{
				logger.error("Unable to load configuration because the configuration file is invalid.", ccX);
			}
	    }
	}
	
	/**
	 * 
	 */
	@Override
	public void storeConfiguration()
    {
	    storeConfiguration(getMuseConfiguration());
    }
	
	/**
	 * A package level method for SPI implementation to get the
	 * Configuration.
	 * 
	 * @return
	 */
	static MuseConfiguration getMuseConfiguration()
	{
		if(museConfiguration == null)
			logger.error("VistaConfiguration is null, possibly called before VistaDataSourceProvider was instantiated.");
		
		return museConfiguration;
	}

	@Override
	public SortedSet<ProviderService> getServices()
	{
		return Collections.unmodifiableSortedSet(services);
	}
	
	public static void main(String [] args)
	{
		System.out.println("Creating vista datasource configuration file");		
		MuseConfiguration museConfiguration = MuseConfiguration.createDefaultConfiguration();		
		MuseDataSourceProvider provider = new MuseDataSourceProvider(museConfiguration);
		provider.storeConfiguration();
		System.out.println("Configuration file saved to '" + provider.getConfigurationFileName() + "'.");
	}


}
