/**
 * 
 */
package gov.va.med.imaging.muse.rest.proxy.v1;

import gov.va.med.RoutingToken;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.InsufficientPatientSensitivityException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.ArtifactResults;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.enums.StudyLoadLevel;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.muse.rest.proxy.AbstractMuseRestService;
import gov.va.med.imaging.musedatasource.configuration.MuseConfiguration;
import gov.va.med.imaging.proxy.services.ProxyServiceType;
import gov.va.med.imaging.proxy.services.ProxyServices;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.util.HashMap;
import java.util.Map;

import javax.ws.rs.core.MediaType;

/**
 * @author William Peterson
 *
 */
public class MuseRestPatientArtifactServiceV1 
extends AbstractMuseRestService {

	/**
	 * 
	 */
	public MuseRestPatientArtifactServiceV1() {

	}
	
	public MuseRestPatientArtifactServiceV1(ProxyServices proxyServices, 
			MuseConfiguration museConfiguration)
	{
		super(proxyServices, museConfiguration);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.rest.proxy.AbstractFederationRestProxy#getProxyServiceType()
	 */
	@Override
	protected ProxyServiceType getProxyServiceType() 
	{
		return ProxyServiceType.metadata;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.rest.proxy.AbstractFederationRestProxy#getRestServicePath()
	 */
	@Override
	protected String getRestServicePath() 
	{
		return FederationPatientArtifactRestUri.patientArtifactServicePath;
	}
	
	public ArtifactResults getPatientArtifacts(String patientIcn, StudyFilter filter, 
			RoutingToken routingToken, StudyLoadLevel studyLoadLevel, boolean includeRadiology, 
			boolean includeDocuments)
	throws InsufficientPatientSensitivityException, MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		getLogger().info("getPatientArtifacts, Transaction [" + transactionContext.getTransactionId() + "] initiated, patient '" + patientIcn + "' to '" + routingToken.toRoutingTokenString() + "'.");
		setDataSourceMethodAndVersion("getPatientArtifacts");
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", routingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{patientIcn}", patientIcn);
		urlParameterKeyValues.put("{authorizedSensitiveLevel}", filter.getMaximumAllowedLevel().getCode() + "");
		urlParameterKeyValues.put("{studyLoadLevel}", FederationRestTranslator.translate(studyLoadLevel).name());
		urlParameterKeyValues.put("{includeRadiology}", includeRadiology + "");
		urlParameterKeyValues.put("{includeDocuments}", includeDocuments + "");
		
		String url = getWebResourceUrl(FederationPatientArtifactRestUri.patientArtifactsPath, urlParameterKeyValues ); 

		FederationFilterType federationFilter = FederationRestTranslator.translate(filter);
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		FederationArtifactResultsType artifactResults = postClient.executeRequest(FederationArtifactResultsType.class, federationFilter);
		if(artifactResults == null)
		{
			getLogger().error("Got null FederationArtifactResultsType from Federation data source");			
			return null;
		}
		getLogger().info("getPatientArtifacts, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (artifactResults == null ? "null" : "not null") + "] FederationArtifactResultsType.");
		ArtifactResults result = null;
		try
		{
			result = FederationRestTranslator.translate(artifactResults, filter);
			transactionContext.addDebugInformation(result == null ? "null PatientArtifacts" : result.toString(true));
		}
		catch(TranslationException tX)
		{
			getLogger().error("Error translating artifact results into business objects, " + tX.getMessage(), tX);
			throw new MethodException(tX);			
		}
		getLogger().info("getPatientArtifacts, Transaction [" + transactionContext.getTransactionId() + "] returned response of [" + (result == null ? "null" :  "not null") + "] ArtifactResults business object.");
		return result;		
	}
	
	@Override
	protected String getDataSourceVersion()
	{
		return "1";
	}


}
