/**
 * 
 */
package gov.va.med.imaging.muse.rest.proxy;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.proxy.rest.AbstractRestPostClient;

import javax.ws.rs.core.MediaType;

import com.sun.jersey.api.client.ClientResponse;

/**
 * @author William Peterson
 *
 */
public class MuseRestPostClient extends AbstractRestPostClient {

	/**
	 * @param url
	 * @param mediaType
	 * @param metadataTimeoutMs
	 */
	public MuseRestPostClient(String url, MediaType mediaType,
			int metadataTimeoutMs) {
		super(url, mediaType, metadataTimeoutMs);
	}

	/**
	 * @param url
	 * @param mediaType
	 * @param metadataTimeoutMs
	 */
	public MuseRestPostClient(String url, String mediaType,
			int metadataTimeoutMs) {
		super(url, mediaType, metadataTimeoutMs);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.proxy.rest.AbstractRestClient#addTransactionHeaders()
	 */
	@Override
	protected void addTransactionHeaders() {
		// TODO Auto-generated method stub

	}

	@Override
	public <T> T executeRequest(Class<T> c, Object... postParameter)
			throws MethodException, ConnectionException {
		if(postParameter != null)
		{
			for(Object pp : postParameter)
			{
				getRequest().entity(pp, MediaType.APPLICATION_XML_TYPE);
			}
		}
		return super.executeRequest(c);
	}

	@Override
	protected <T> ClientResponse executeMethodInternal(Class<T> c) {
		return getRequest().post(ClientResponse.class);
	}
	
	

}
