/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 30, 2010
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vacotittoc
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.mixdatasource;

import gov.va.med.GlobalArtifactIdentifier;
import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.interfaces.exceptions.SecurityException;
import gov.va.med.imaging.datasource.AbstractVersionableDataSource;
import gov.va.med.imaging.datasource.StudyGraphDataSourceSpi;
import gov.va.med.imaging.datasource.exceptions.UnsupportedProtocolException;
import gov.va.med.imaging.datasource.exceptions.UnsupportedServiceMethodException;
import gov.va.med.imaging.exchange.business.*;
import gov.va.med.imaging.exchange.enums.StudyLoadLevel;
import gov.va.med.imaging.mix.proxy.MixDataSourceProxy;
import gov.va.med.imaging.mix.proxy.v1.MixProxyUtilities;
import gov.va.med.imaging.mix.proxy.v1.ImageMixStudyProxyV1;
import gov.va.med.imaging.proxy.exceptions.ProxyServiceNotFoundException;
import gov.va.med.imaging.proxy.services.ProxyServiceType;
import gov.va.med.imaging.proxy.services.ProxyServices;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.url.mixs.MIXsConnection;
import gov.va.med.imaging.url.mix.configuration.MIXSiteConfiguration;
import gov.va.med.imaging.url.mix.exceptions.MIXConfigurationException;
import gov.va.med.imaging.url.mix.exceptions.MIXConnectionException;
import gov.va.med.imaging.url.mix.exceptions.MIXMethodException;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.SortedSet;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author vacotittoc
 *
 */
public class MixStudyGraphDataSourceServiceV1
extends AbstractVersionableDataSource
implements StudyGraphDataSourceSpi
{
	private final static Logger logger = LogManager.getLogger(MixStudyGraphDataSourceServiceV1.class);
	
	private final MIXsConnection mixConnection;
	private ImageMixStudyProxyV1 proxy = null;
	
	private final static String MIX_PROXY_SERVICE_NAME = "MIX";
	private final static String DATASOURCE_VERSION = "1";
	private MIXSiteConfiguration mixConfiguration = null;
	public final static String SUPPORTED_PROTOCOL = "mix";
	private ProxyServices mixProxyServices = null;
//	private StudySetResult studySetResult = null;
	
	/**
     * The Provider will use the create() factory method preferentially
     * over a constructor.  This allows for caching of VistaStudyGraphDataSourceService
     * instances according to the criteria set here.
     * 
     * @param url
     * @param site
     * @return
     * @throws ConnectionException
     * @throws UnsupportedProtocolException 
     */
    public static MixStudyGraphDataSourceServiceV1 create(ResolvedArtifactSource resolvedArtifactSource, String protocol)
    throws ConnectionException, UnsupportedProtocolException
    {
    	return new MixStudyGraphDataSourceServiceV1(resolvedArtifactSource, protocol);
    }
	
	public MixStudyGraphDataSourceServiceV1(ResolvedArtifactSource resolvedArtifactSource, String protocol)
	throws UnsupportedProtocolException
	{
		super(resolvedArtifactSource, protocol);
		if(! (resolvedArtifactSource instanceof ResolvedSite) )
			throw new UnsupportedOperationException("MIXClient: The artifact source must be an instance of ResolvedSite and it is a '" + resolvedArtifactSource.getClass().getSimpleName() + "'.");
		
		mixConnection = new MIXsConnection(getMetadataUrl());
	}
	
	/**
	 * The artifact source must be checked in the constructor to assure that it is an instance
	 * of ResolvedSite.
	 * 
	 * @return
	 * @throws MalformedURLException 
	 */
//	private ResolvedSite getResolvedSite()
//	{
//		return (ResolvedSite)getResolvedArtifactSource();
//	}
//	
	private  Site getMixSite()
	{
		Site site = null;
		try {
			site = new SiteImpl("200", "DOD", "DOD", null, 0, "", 8080, "200");
		} 
		catch (MalformedURLException mue)
		{
			logger.info("getMixSite exception: " + mue.getMessage());
		}
		return site;
	}
	
	private Site getSite()
	{
		return getMixSite(); // getResolvedSite().getSite();
	}
	
	@SuppressWarnings("boxing")
	@Override
	public StudySetResult getPatientStudies(RoutingToken globalRoutingToken, PatientIdentifier patientIdentifier,
			StudyFilter filter, StudyLoadLevel studyLoadLevel)
	throws MethodException, ConnectionException
	{
		// if the study load level is full, then also need to get the study reports for each study returned!
		MixDataSourceCommon.setDataSourceMethodAndVersion("getPatientStudies", DATASOURCE_VERSION);
		logger.info("MIXClient getPatientStudies for patient (" + patientIdentifier + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		if(patientIdentifier.getPatientIdentifierType().isLocal())
			throw new MethodException("Cannot use local patient identifier to retrieve remote patient information");
		String patientIcn = patientIdentifier.getValue();

		// validate protocol registration!
		try {
			new MixDataSourceProxy(MixDataSourceProvider.getMixConfiguration());
		} 
		catch (ConnectionException e)
		{
			logger.debug(e.getMessage());
			throw new MIXMethodException("Mix protocol registration failed: ", e);
		}

//		try 
//		{
//			mixConnection.connect();	// *** might be a premature failure based on basic protocol and DOD site settings!		
//		}
//		catch(IOException ioX) 
//		{
//			logger.error("MIXClient connection error getting patient studies", ioX);
//			throw new MIXConnectionException(ioX);
//		}

		// now get metadata for ICN and date range ((MIX Pass 1, level 1&2)

		// for MIX studyloadlevel must be FULL (MIX FHIR level 1 & 2)!!! -- that's taken care of direectly on lower level (not using studyLoadLevel)
		logger.info("MIXClient getPatientStudies called from site [" + getSite().getSiteNumber() + "] for patient [" + patientIcn + "] with studyloadlevel [" 
		+ studyLoadLevel.toString() + "]; FULL is forced for MIX!");

		StudySetResult studySetResult = getProxy().getPatientStudies(patientIcn, filter, StudyLoadLevel.FULL);
		logger.info("MIXClient getPatientStudies got [" + (studySetResult == null ? "null" : (studySetResult.getArtifacts() == null ? "null studies" : studySetResult.getArtifacts().size())) + "] studies from site [" + getSite().getSiteNumber() + "]");
		
		// if the requestor wanted reports in exchange along with the studies, they were not already included so they needed to be added 
		if(studyLoadLevel.isIncludeReport()) // studyloadlevel is FULL (MIX FHIR level 1 & 2), so reports are already included
		{ // this should be dead code!!!!!
			TransactionContext transactionContext = TransactionContextFactory.get();
			
			if(studySetResult != null)
			{
				SortedSet<Study> studies = studySetResult.getArtifacts();
				if(studies != null)
				{
					for(Study study : studies)
					{
						// if the study does not have the report, then need to get it
						if(!study.getStudyLoadLevel().isIncludeReport())
						{
							try
							{
								transactionContext.addDebugInformation("Getting report for study '" + study.getGlobalArtifactIdentifier().toString() + "'.");
								String report = getStudyReportInternal(patientIcn, 
										study.getGlobalArtifactIdentifier());
								// this will update the study load level
								study.setRadiologyReport(report);
							}
							catch(MethodException mX)
							{
								logger.warn("MIXClient MethodException getting report for study '" + study.getStudyUrn().toString() + ", " + mX.getMessage());
							}
							catch(ConnectionException cX)
							{
								logger.warn("MIXClient ConnectionException getting report for study '" + study.getStudyUrn().toString() + ", " + cX.getMessage());
							}
						}
					}
				}
			}
		}
		
		return studySetResult;
	}
	// TODO MIX should not get here !!! but VistaRad calls it, so internally buffer data tree if needed and pick from there!!!
	@Override
	public String getStudyReport(PatientIdentifier patientIdentifier,
			GlobalArtifactIdentifier studyId) 
	throws MethodException, ConnectionException
	{
		MixDataSourceCommon.setDataSourceMethodAndVersion("getStudyReport", DATASOURCE_VERSION);
		if(patientIdentifier.getPatientIdentifierType().isLocal())
			throw new MethodException("Cannot use local patient identifier to retrieve remote patient information");
		String patientIcn = patientIdentifier.getValue();
		return getStudyReportInternal(patientIcn, studyId);
	}
	
	private String getStudyReportInternal(String patientIcn,
			GlobalArtifactIdentifier studyId) 
	throws MethodException, ConnectionException
	{
		logger.info("MIXClient getStudyReport for patient (" + patientIcn + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
//		try 
//		{
//			mixConnection.connect();	// *** might be a premature failure based on basic protocol and DOD site settings!			
//		}
//		catch(IOException ioX) 
//		{
//			logger.error("MIXClient connection error getting patient studies (internally)", ioX);
//			throw new MIXConnectionException(ioX);
//		}

		// validate protocol registration!
		try {
			new MixDataSourceProxy(MixDataSourceProvider.getMixConfiguration());
		} 
		catch (ConnectionException e)
		{
			logger.debug(e.getMessage());
			throw new MIXMethodException("Mix protocol registration failed: ", e);
		}
		
		return getProxy().getStudyReport(patientIcn, studyId);	// MIX should not get here but !!!
	}

	@Override
	public boolean isVersionCompatible() 
	throws SecurityException
	{
		ProxyServiceType serviceType = ProxyServiceType.metadata;
		try
		{
			ProxyServices proxyServices = getMixProxyServices();	
			if(proxyServices == null)
			{
				logger.warn("MIXClient got null proxy services back, indicates site '" + getSite().getSiteNumber() + "' for version '" + DATASOURCE_VERSION + "' is not version compatible.");
				return false;
			}
			proxyServices.getProxyService(serviceType);
		}
		catch(IOException ioX)
		{
			logger.error("MIXClient error finding proxy services from site '" + getSite().getSiteNumber() + "'.");
			return false;
		}
		catch(ProxyServiceNotFoundException psnfX)
		{
			logger.error("MIXClient could not find proxy service type '" + serviceType + "' from site '" + getSite().getSiteNumber() + "'.");
		}
		
		return true;
	}
	
	protected ProxyServices getMixProxyServices()
	throws IOException
	{
		if(mixProxyServices == null)
		{
			mixProxyServices = 
				MixProxyUtilities.getMixProxyServices(getMixSiteConfiguration(), getSite().getSiteNumber(), 
						MIX_PROXY_SERVICE_NAME, DATASOURCE_VERSION, mixConnection.getURL().getHost(), 
						mixConnection.getURL().getPort(), null);
		}
		return mixProxyServices;
	}
	
	private MIXSiteConfiguration getMixSiteConfiguration()
	throws IOException
	{
		if(mixConfiguration == null)
		{
			try 
			{
				mixConfiguration = 
					MixDataSourceProvider.getMixConfiguration().getSiteConfiguration(getSite().getSiteNumber(), null);
			}
			catch(MIXConfigurationException ecX)
			{
				throw new IOException(ecX);
			}
		}
		return mixConfiguration;
	}
	
	private ImageMixStudyProxyV1 getProxy()
	throws ConnectionException
	{
		if(proxy == null)
		{
			try
			{
				proxy = new ImageMixStudyProxyV1(getMixProxyServices(), getSite(), 
						MixDataSourceProvider.getMixConfiguration());
			}
			catch(IOException ioX)
			{
				throw new ConnectionException(ioX);
			}						
		}
		return proxy;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.StudyGraphDataSourceSpi#getStudy(java.lang.String, gov.va.med.GlobalArtifactIdentifier)
	 */
	@Override
	public Study getStudy(PatientIdentifier patientIdentifier, GlobalArtifactIdentifier studyId) throws MethodException,
		ConnectionException
	{
		throw new UnsupportedServiceMethodException(StudyGraphDataSourceSpi.class, "getStudy");
	}
	
}
