/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Nov 11, 2016
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vacotittoc
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.mixdatasource;

import gov.va.med.GlobalArtifactIdentifier;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.artifactsource.ArtifactSource;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
// import gov.va.med.imaging.conversion.ImageConversionFilePath;
// import gov.va.med.imaging.conversion.ImageConversionUtility;
// import gov.va.med.imaging.conversion.enums.ImageConversionSatisfaction;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.ImageNearLineException;
import gov.va.med.imaging.core.interfaces.exceptions.ImageNotFoundException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodRemoteException;
// import gov.va.med.imaging.core.interfaces.exceptions.*;
import gov.va.med.imaging.datasource.AbstractVersionableDataSource;
import gov.va.med.imaging.datasource.ImageDataSourceSpi;
import gov.va.med.imaging.datasource.exceptions.UnsupportedProtocolException;
import gov.va.med.imaging.exchange.business.Image;
import gov.va.med.imaging.exchange.business.ImageFormatQuality;
import gov.va.med.imaging.exchange.business.ImageFormatQualityList;
import gov.va.med.imaging.exchange.business.ImageStreamResponse;
// import gov.va.med.imaging.exchange.business.*;
import gov.va.med.imaging.exchange.enums.ImageFormat;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import gov.va.med.imaging.exchange.storage.ByteBufferBackedImageInputStream;
import gov.va.med.imaging.exchange.storage.DataSourceImageInputStream;
import gov.va.med.imaging.exchange.storage.DataSourceInputStream;
import gov.va.med.imaging.mix.DODImageURN;
// import gov.va.med.imaging.exchange.storage.DataSourceInputStream;
import gov.va.med.imaging.mix.proxy.MixProxy;
import gov.va.med.imaging.mix.proxy.v1.ImageMixProxy;
import gov.va.med.imaging.mix.proxy.v1.MixProxyServices;
import gov.va.med.imaging.mix.proxy.v1.MixProxyUtilities;
// import gov.va.med.imaging.mix.rest.proxy.AbstractMixRestImageProxy;
import gov.va.med.imaging.mix.rest.proxy.MixRestGetClient;
import gov.va.med.imaging.mix.webservices.rest.endpoints.MixImageWADORestUri;
import gov.va.med.imaging.mix.webservices.rest.endpoints.MixRestUri;
import gov.va.med.imaging.proxy.rest.RestProxyCommon;
import gov.va.med.imaging.proxy.services.ProxyServiceType;
import gov.va.med.imaging.transactioncontext.TransactionContext;
// import gov.va.med.imaging.proxy.services.ProxyServiceType;
// import gov.va.med.imaging.mix.storage.MixStorageUtility;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
// import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.url.mixs.MIXsConnection;
import gov.va.med.imaging.url.mix.configuration.MIXConfiguration;
import gov.va.med.imaging.url.mix.configuration.MIXSiteConfiguration;
import gov.va.med.imaging.url.mix.exceptions.MIXConfigurationException;
import gov.va.med.imaging.url.mix.exceptions.MIXConnectionException;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.ClientResponse.Status;

//import com.sun.jersey.api.client.ClientResponse;

/**
 * @author vacotittoc
 *
 */
public abstract class AbstractMixImageDataSourceService
extends AbstractVersionableDataSource
implements ImageDataSourceSpi
{
	protected final MIXsConnection mixConnection;
	private MIXConfiguration mixConfiguration = null;
	private MIXSiteConfiguration mixSiteConfiguration = null;
//	private AbstractMixRestImageProxy amrip;
	
	public static final List<ImageFormat> acceptableThumbnailResponseTypes;
	public static final List<ImageFormat> acceptableReferenceResponseTypes;
	public static final List<ImageFormat> acceptableDiagnosticResponseTypes;
	
	static
	{
		acceptableThumbnailResponseTypes = new ArrayList<ImageFormat>();
		acceptableThumbnailResponseTypes.add(ImageFormat.JPEG);
		
		acceptableReferenceResponseTypes = new ArrayList<ImageFormat>();
		acceptableReferenceResponseTypes.add(ImageFormat.DICOMJPEG2000);
		
		acceptableDiagnosticResponseTypes = new ArrayList<ImageFormat>();
		acceptableDiagnosticResponseTypes.add(ImageFormat.DICOMJPEG2000);
//		acceptableDiagnosticResponseTypes.add(ImageFormat.DICOM); // DICOM must be here because the request type will be application/dicom which literally converts to this one
	}	
	
	// Hashmap to hold proxies based on the alien site number (if empty string, will return proxy to BIA), otherwise will use wormhole.
	private HashMap<String, ImageMixProxy> xchangeProxies = new HashMap<String, ImageMixProxy>();

	private final static Logger logger = LogManager.getLogger(AbstractMixImageDataSourceService.class);
	private final static String MIX_PROXY_SERVICE_NAME = "MIX";
	private final static String DATASOURCE_VERSION = "1";
	public final static String SUPPORTED_PROTOCOL = "mix";
	private MixProxyServices mixProxyServices = null;
	private TransactionContext transactionContext = TransactionContextFactory.get();

	@SuppressWarnings("unused")
	
	/**
     * The Provider will use the create() factory method preferentially
     * over a constructor.  This allows for caching of VistaStudyGraphDataSourceService
     * instances according to the criteria set here.
     * 
     * @param url
     * @param protocol
     * @return
     * @throws ConnectionException
     * @throws UnsupportedProtocolException 
     */
	public AbstractMixImageDataSourceService(ResolvedArtifactSource resolvedArtifactSource, String protocol) 
	throws UnsupportedProtocolException
	{
		super(resolvedArtifactSource, protocol);
		mixConnection = new MIXsConnection(getArtifactUrl());
		mixConfiguration = MixDataSourceProvider.getMixConfiguration();
	}			
	
	protected Logger getLogger()
	{
		return logger;
	}
	
	protected abstract MixProxy getProxy(Image image)
	throws IOException;
	
//	protected abstract String getDataSourceVersion();	
	
//	/* (non-Javadoc)
//	 * @see gov.va.med.imaging.datasource.ImageDataSourceSpi#getUrl()
//	 */
//	public URL getUrl() // unused!
//	{
//		return mixConnection.getURL();
//	}

//	@Override
	protected String getDataSourceVersion() {
		return DATASOURCE_VERSION;
	}

	@Override
	public DataSourceInputStream getImageTXTFile(Image image)
	throws MethodException, ConnectionException
	{
		return null;
	}

	@Override
	public DataSourceInputStream getImageTXTFile(ImageURN imageURN)
	throws UnsupportedOperationException, MethodException,
		ConnectionException, ImageNotFoundException, ImageNearLineException 
	{
		return null;
	}

	@Override
	public String getImageInformation(AbstractImagingURN imagingUrn, boolean includeDeletedImages)
	throws UnsupportedOperationException, MethodException,
		ConnectionException, ImageNotFoundException 
	{
		throw new UnsupportedOperationException("The MIX ImageDataSource does not support the getImageInformation method.");
	}

	@Override
	public String getImageSystemGlobalNode(AbstractImagingURN imagingUrn)
			throws UnsupportedOperationException, MethodException,
			ConnectionException, ImageNotFoundException {
		throw new UnsupportedOperationException("The MIX ImageDataSource does not support the getImageSystemGlobalNode method.");
	}
	
	@Override
	public String getImageDevFields(AbstractImagingURN imagingUrn, String flags)
	throws UnsupportedOperationException, MethodException,
		ConnectionException, ImageNotFoundException 
	{
		throw new UnsupportedOperationException("The MIX ImageDataSource does not support the getImageDevFields method.");
	}
	
	@Override
	public ImageStreamResponse getImage(Image image, ImageFormatQualityList requestFormatQualityList) 
	throws MethodException, ConnectionException
	{
		logger.info("MIXClient getImage(" + image.getIen() + ") from Image object TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		try 
		{			
			MixProxy proxy = getProxy(image);
			ImageURN imageUrn = image.getImageUrn();
			//ImageURN imageUrn = ImageURN.create(image.getSiteNumber(), image.getIen(), image.getStudyIen(), image.getPatientICN());
			return getImage(imageUrn, requestFormatQualityList, proxy);
		}
		catch(IOException ioX)
		{
			logger.error("MIXClient error getting image", ioX);
			throw new MethodRemoteException(ioX);
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.ImageDataSourceSpi#getImage(gov.va.med.imaging.ImageURN, int, java.lang.String)
	 * This is the main getImage call in MIX !!!
	 */
	@Override
	public ImageStreamResponse getImage(GlobalArtifactIdentifier gai, ImageFormatQualityList requestFormatQualityList) 
	throws MethodException, MIXConnectionException, ConnectionException
	{		
		// substitute if(!(gai instanceof ImageURN)) check
		DODImageURN dIU = new DODImageURN();
		if (!gai.toString().startsWith(dIU.getDODPrefix()))
		{
			throw new MethodException("GlobalArtifactIdentifier '" + gai.toString() + "' is not instanceof DODImageURN, cannot retrieve image from MIX.");
		}
		ImageURN imageUrn = (ImageURN)gai;
		logger.info("MIXClient getImage(" + imageUrn.toString() + ") from Image URN TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		try
		{
			MixProxy proxy = getProxy(null);
			return getImage(imageUrn, requestFormatQualityList, proxy);
		}
		catch(IOException ioX)
		{
			logger.error("MIXClient error getting image", ioX);
			throw new MethodRemoteException(ioX);
		}		
	}
	
	// this is the common MIX getImage client call
	private ImageStreamResponse getImage(
		ImageURN imageUrn, 
		ImageFormatQualityList requestFormatQualityList, 
		MixProxy proxy) 
	throws MethodException, MIXConnectionException, ConnectionException
	{
		MixDataSourceCommon.setDataSourceMethodAndVersion("getImage", getDataSourceVersion());
		String imageURN = imageUrn.toString(SERIALIZATION_FORMAT.NATIVE);
		String aliSite = MIXConfiguration.DEFAULT_DAS_SITE;
		if(proxy.getAlienSiteNumber() != null)
			aliSite = proxy.getAlienSiteNumber();
		
		transactionContext.addDebugInformation("Retrieving image from alien site number [" + aliSite + "]");
		logger.info("MIXClient getImage: Retrieving image [" + imageURN + "] from site [" + aliSite + "]");
		// get desired imageQuality
		ImageFormatQualityList prunedList = pruneRequestList(requestFormatQualityList);
		if (prunedList.size()==0)
		{
			String msg = "MIXClient getImage Error: No/Bad FormaQuality list received for  [" + imageURN + "] from site [" + aliSite + "]";
			logger.info(msg);
			throw new MethodException(msg);
		}
		ImageQuality iQ = prunedList.getFirstImageQuality();
		
		// compose URL to client
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		// urlParameterKeyValues.put("{routingToken}", routingToken.toRoutingTokenString());
		DODImageURN dodUrn = new DODImageURN(imageUrn);
		urlParameterKeyValues.put("{studyUid}", dodUrn.getStudyUID());
		urlParameterKeyValues.put("{seriesUid}", dodUrn.getSeriesUID());
		urlParameterKeyValues.put("{instanceUid}", dodUrn.getInstanceUID());

		MediaType mT = 	MediaType.APPLICATION_OCTET_STREAM_TYPE; // ????? APPLICATION_OCTET_STREAM
		
		String urlPath = MixImageWADORestUri.thumbnailPath;
		if (iQ == ImageQuality.REFERENCE) 
		{
			urlPath = MixImageWADORestUri.dicomJ2KReferencePath;
		}
		else if (iQ == ImageQuality.DIAGNOSTIC)
		{
			urlPath = MixImageWADORestUri.dicomJ2KDiagnosticPath;
		}
		String url="";
		try {
			url = getWebResourceUrl(urlPath, urlParameterKeyValues); 
		}
		catch (ConnectionException ce) {
			throw new MIXConnectionException("MIXClient getImage: Failed to compose URL source!" + ce.getMessage());
		}
		ImageStreamResponse imageStreamResponse= null;
//		try{
			ClientResponse clientResponse=null;
			MixRestGetClient getClient = new MixRestGetClient(url, mT, mixConfiguration);
			clientResponse = getClient.getInputStreamResponse();
			InputStream inputStream =null;
			if(clientResponse.getStatus() == Status.OK.getStatusCode())
			{
				logger.debug("getInputStreamResponse returned successfully");
				inputStream = clientResponse.getEntityInputStream();
				if (inputStream != null)
				{
					imageStreamResponse = new ImageStreamResponse(new ByteBufferBackedImageInputStream(inputStream, 0));
					imageStreamResponse.setImageQuality(iQ);
					imageStreamResponse.setMediaType(MediaType.APPLICATION_OCTET_STREAM);
					transactionContext.setDataSourceImageFormatReceived(imageStreamResponse.getImageFormat() == null ? "" : imageStreamResponse.getImageFormat().toString());
					transactionContext.setDataSourceImageQualityReceived(imageStreamResponse.getImageQuality().toString());
				}
			}				
		// send request to Client and check response
//		MixRestGetClient getClient = new MixRestGetClient(url, mT, mixConfiguration);
//		ClientResponse clientResponse=null;
//		ImageStreamResponse imageStreamResponse= null;
//		try{ // *** unsure how to get the stream!!!!
//			clientResponse = getClient.executeRequest(ClientResponse.class); // ConnectionException & MethodException
//			if (clientResponse.getClientResponseStatus() == ClientResponse.Status.OK) {
//				imageStreamResponse = new ImageStreamResponse((DataSourceImageInputStream)clientResponse.getEntityInputStream(), iQ);
//				imageStreamResponse.setMediaType(mT.toString());
//			}
//		}
//		catch (ConnectionException ce) {
//			throw new MIXConnectionException("MIXClient getImage: Failed to connect to Resource!");
//		}
//		catch (MethodException me) {
//			throw new MIXConnectionException("MIXClient getImage: Error getting Resource response!" + me.getMessage());
//		}
        return imageStreamResponse;
	}

	protected MIXSiteConfiguration getMixSiteConfiguration(String alienSiteNumber)
	throws IOException
	{
//		MIXSiteConfiguration mixSiteConfiguration = null;
		String repositoryId = alienSiteNumber; // *** hardcoded! *** getResolvedArtifactSource().getArtifactSource().getRepositoryId();
		String primarySiteNumber = repositoryId;
		String secondarySiteNumber = null;
		if((alienSiteNumber != null) && (alienSiteNumber.length() > 0))
		{
			secondarySiteNumber = repositoryId;
			primarySiteNumber = alienSiteNumber;
		}
		try 
		{
			
			mixSiteConfiguration = 
				MixDataSourceProvider.getMixConfiguration().getSiteConfiguration(primarySiteNumber, secondarySiteNumber);
		}
		catch(MIXConfigurationException ecX)
		{
			throw new IOException(ecX);
		}		
		return mixSiteConfiguration;
	}
	
	/**
	 * This function reduces the requested format list to a list acceptable by the DOD.
	 * If the request includes formats that the DOD does not expect, they will not work properly
	 * so if the request came from the Clinical Display client, it must be reduced to eliminate
	 * types like TGA, J2K, PDF, DOC, etc.
	 */
	private ImageFormatQualityList pruneRequestList(ImageFormatQualityList requestList)
	{
		ImageFormatQualityList prunedList = new ImageFormatQualityList();
		for(ImageFormatQuality quality : requestList)
		{
			List<ImageFormat> allowableFormats = getAcceptableImageFormatsForQuality(quality.getImageQuality());
			if(isQualityFormatAllowed(quality.getImageFormat(), allowableFormats))
			{
				prunedList.addUniqueMime(quality);
			}
		}
		return prunedList;
	}
	
	private List<ImageFormat> getAcceptableImageFormatsForQuality(ImageQuality quality)
	{		
		if(quality == ImageQuality.REFERENCE) 
			return acceptableReferenceResponseTypes;
		else if(quality == ImageQuality.DIAGNOSTIC)
			return acceptableDiagnosticResponseTypes;
//		else if(quality == ImageQuality.DIAGNOSTICUNCOMPRESSED) -- retired for MIX!
//			return acceptableDiagnosticResponseTypes;
		else // thumbnail or other
			return acceptableThumbnailResponseTypes;
	}
	
	private boolean isQualityFormatAllowed(ImageFormat format, List<ImageFormat> acceptableFormats)
	{
		for(ImageFormat acceptableFormat : acceptableFormats)
		{
			if((acceptableFormat == ImageFormat.ANYTHING) ||
				(acceptableFormat.getMime().equalsIgnoreCase(format.getMime())))
			{
				return true;
			}
		}		
		return false;
	}	
	
	protected MixProxyServices getMixProxyServices(String alienSiteNumber)
	throws IOException
	{
		if(mixProxyServices == null)
		{
			boolean isAlienSiteNumber = false;
			String host = mixConnection.getURL().getHost();
			int port = mixConnection.getURL().getPort();
			MIXSiteConfiguration mixSiteConfiguration = getMixSiteConfiguration(alienSiteNumber);
			if(mixSiteConfiguration.containsHostAndPort())
			{
				host = mixSiteConfiguration.getHost();
				port = mixSiteConfiguration.getPort();
				isAlienSiteNumber = true;
			}
			mixProxyServices = 
				MixProxyUtilities.getMixProxyServices(mixSiteConfiguration, 
						createUniqueSiteNumber(mixSiteConfiguration),
						MIX_PROXY_SERVICE_NAME, getDataSourceVersion(), 
						host, 
						port, 
						isAlienSiteNumber ? alienSiteNumber : null);
		}
		return mixProxyServices;
	}
	
	/**
	 * This method returns a unique site number so IDS can properly cache the site results uniquely
	 * the concern is if the VIX is querying an alien site (PACSi) for IDS, it shouldn't store that
	 * in the IDS cache under site 200 (200 should be the DAS).
	 * 
	 * if the mixSiteConfiguration is for site 200 (DAS), then 200 is not prepended
	 * 
	 * 
	 * @param mixSiteConfiguration
	 * @return
	 */
	private String createUniqueSiteNumber(MIXSiteConfiguration mixSiteConfiguration)
	{
		if(MIXConfiguration.DEFAULT_DAS_SITE.equals(mixSiteConfiguration.getSiteNumber()))
			return mixSiteConfiguration.getSiteNumber();
		return MIXConfiguration.DEFAULT_DAS_SITE + "_" + mixSiteConfiguration.getSiteNumber();
	}
	
//	protected String getResolvedArtifactSourceString()
//	{
//		ArtifactSource artifactSource = getResolvedArtifactSource().getArtifactSource();
//		return artifactSource.getHomeCommunityId() + ", " + artifactSource.getRepositoryId();	
//	}
	
	protected String getRestServicePath()
	{
		return MixRestUri.mixRestUriV1;
	}
	protected ProxyServiceType getProxyServiceType()
	{
		return ProxyServiceType.image;
	}
	
	protected String getWebResourceUrl(String methodUri, Map<String, String> urlParameterKeyValues) // was protected...
	throws ConnectionException
	{
		StringBuilder url = new StringBuilder();
		//url.append("https://das-xxx.DNS   :PORT/haims/");
//		url.append(proxyServices.getProxyService(getProxyServiceType()).getConnectionURL()); // protocol://FQDN:port
		url.append(MIXConfiguration.defaultMIXProtocol + "://");
		boolean gotConfig = false;
		try
		{
			if ((this.mixConfiguration != null) &&
				(this.mixConfiguration.getSiteConfiguration(MIXConfiguration.DEFAULT_DAS_SITE, MIXConfiguration.DEFAULT_DAS_SITE) != null)) {
				MIXSiteConfiguration mixSiteConfig = this.mixConfiguration.getSiteConfiguration(MIXConfiguration.DEFAULT_DAS_SITE, MIXConfiguration.DEFAULT_DAS_SITE);
				url.append(mixSiteConfig.getHost() + ":" + mixSiteConfig.getPort() + "/" + mixSiteConfig.getMixApplication() + "/");
				gotConfig=true;
			}
		} catch(MIXConfigurationException mce) {
		}
		if (!gotConfig) {
			getLogger().debug("MIXClient WARNING: Using hardcoded DOD Configuration!!!");
			url.append(MIXConfiguration.defaultDODImageHost + ":"+ MIXConfiguration.defaultDODImagePort + "/" + MIXConfiguration.defaultDODXChangeApplication);
		}
		url.append(getRestServicePath());
		url.append("/");
		url.append(RestProxyCommon.replaceMethodUriWithValues(methodUri, urlParameterKeyValues));		
		
		getLogger().debug("MIXClient WebResourceUrl: " + url.toString());
		return url.toString();
	}

}
