package gov.va.med.imaging.url.mix.configuration;

import gov.va.med.imaging.url.mix.exceptions.MIXConfigurationException;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * 
 * @author DNS TITTOC
 *
 */
public class MIXConfiguration
implements Serializable
{
	private final static long serialVersionUID = 1L;

	private static final String DEFAULT_DAS_USERNAME = "vixuser";
	private static final String DEFAULT_DAS_PASSWORD = "vixvix1.";
	public static final String DEFAULT_DAS_SITE = "200";
	public static final String DEFAULT_DAS_PROTOCOL = "mixs";

	public final static String defaultMIXProtocol = "https";
	public final static String defaultDODXChangeApplication = "haims"; // DAS is proxy only...
	public final static String defaultDODMetadataXChangePath1 = "/mix/v1/DiagnosticReport/subject"; // "/mix/DiagnosticReport/subject" (FHIR) -- pass 1 level 1
	public final static String defaultDODMetadataXChangePath2 = "/mix/v1/ImagingStudy"; // "/mix/ImagingStudy" (FHIR) -- pass 1 level 2
	public final static String defaultDODImageXChangePath1 = "/mix/v1/RetrieveThumbnail"; // "/mix/RetrieveThumbnail" (WADO-URI) -- pass 2 (TN)
	public final static String defaultDODImageXChangePath2 = "/mix/v1/RetrieveInstance"; // "/mix/RetrieveInstance" (WADO-RS) -- pass 2 (Ref/Diag)
	public final static String defaultDODImageHost = "SERVER";
	public final static int defaultDODImagePort = PORT;
	
	public final static String defaultImageXChangeApplication = "MIXWebApp";// was "ImagingExchangeWebApp";
	public final static String defaultImageMetadataXChangePath1 = "/restservices/mix/DiagnosticReport/subject"; // (FHIR) -- pass 1 level 1
	public final static String defaultImageMetadataXChangePath2 = "/restservices/mix/ImagingStudy"; // (FHIR) -- pass 1 level 2
	public final static String defaultImageXChangePath1 = "/mix/retrieveThumbnail";	// (WADO-URI) -- pass 2 (TN)
	public final static String defaultImageXChangePath2 = "/mix/retrieveInstance";	// (WADO-URI) -- pass 2 (Ref/Diag); later WADO-RS
	public final static String defaultImageHost = "localhost";
	public final static int defaultImagePort = PORT;
	public final static String defaultKeystoreUrl = "file:///c:/VixCertStore/cvix.jks";
	public final static String defaultTruststoreUrl = "file:///c:/VixCertStore/das.truststore";
		
	private final static Logger logger = LogManager.getLogger(MIXConfiguration.class);
	
	private List<MIXSiteConfiguration> configurations;
	private List<String> emptyStudyModalities;
	private int metadataTimeout;

	private String keystoreUrl;
	private String keystorePassword;
	private String truststoreUrl;
	private String truststorePassword;
	
	public final static int defaultMetadataTimeout = 45000;

	
	/**
	 * 
	 */
	public MIXConfiguration() 
	{
		super();
		configurations = new ArrayList<MIXSiteConfiguration>();
		emptyStudyModalities = new ArrayList<String>();
		metadataTimeout = defaultMetadataTimeout; // 45 sec
	}

	public static MIXConfiguration createDefaultMixConfiguration(
			List<String> emptyStudyModalities, 
			int metadataTimeout, 
			String imageHost, int imagePort,
			String cvixCertPwd,
			String dasCertPwd
			)
	throws MIXConfigurationException
	{
		MIXConfiguration mixConfiguration = new MIXConfiguration();
		mixConfiguration.createDODSite(null,  null, imageHost, imagePort);
		mixConfiguration.emptyStudyModalities.addAll(emptyStudyModalities);
		mixConfiguration.metadataTimeout = metadataTimeout;
		mixConfiguration.keystoreUrl = defaultKeystoreUrl;
		mixConfiguration.truststoreUrl = defaultTruststoreUrl;
		mixConfiguration.keystorePassword = cvixCertPwd;
		mixConfiguration.truststorePassword = dasCertPwd;
	
		return mixConfiguration;
	}

	/**
	 * Create an MIXConfiguration instance with a DOD and multiple VA site
	 * entries.
	 * 
	 * @param vaSites
	 * @return
	 * @throws MIXConfigurationException
	 */
	public static MIXConfiguration createDefaultMixConfiguration(String[] vaSites)
	throws MIXConfigurationException
	{
		MIXConfiguration mixConfiguration = new MIXConfiguration();
		/*
		xchangeConfiguration.setDasPassword(DEFAULT_DAS_PASSWORD);
		xchangeConfiguration.setDasUsername(DEFAULT_DAS_USERNAME);
		*/
		
		if(vaSites != null)
		{
			for(String vaSite : vaSites)
			{
				System.out.println("Adding VA template for site [" + vaSite + "]");
				if(vaSite != null)
				{
					MIXSiteConfiguration site = 
						new MIXSiteConfiguration(
							vaSite, "", "", 
							defaultImageXChangeApplication, 
							defaultImageMetadataXChangePath1, 
							defaultImageMetadataXChangePath2, 
							defaultImageXChangePath1,
							defaultImageXChangePath2,
							true,
							defaultImageHost,
							defaultImagePort);
					
					mixConfiguration.addSiteConfiguration(site);
				}
			}
		}
		
		mixConfiguration.createDODSite();		
		return mixConfiguration;
	}	
	
	private void createDODSite()
	{
		MIXSiteConfiguration site = new MIXSiteConfiguration(DEFAULT_DAS_SITE, 
				DEFAULT_DAS_USERNAME, DEFAULT_DAS_PASSWORD, defaultDODXChangeApplication,
				defaultDODMetadataXChangePath1, defaultDODMetadataXChangePath2,
				defaultDODImageXChangePath1, defaultDODImageXChangePath1, false,
				defaultDODImageHost, defaultDODImagePort);
		addSiteConfiguration(site);
	}
	
	private void createDODSite(String dasUsername, String dasPassword, String imageHost, int imagePort)
	{
		MIXSiteConfiguration site = new MIXSiteConfiguration(DEFAULT_DAS_SITE, 
				DEFAULT_DAS_USERNAME, DEFAULT_DAS_PASSWORD, defaultDODXChangeApplication,
				defaultDODMetadataXChangePath1, defaultDODMetadataXChangePath2,
				defaultDODImageXChangePath1, defaultDODImageXChangePath1, false,
				imageHost, imagePort);
		addSiteConfiguration(site);
	}

	private void createDODSite(String dasUsername, String dasPassword)
	{
		String username = DEFAULT_DAS_USERNAME;
		String password = DEFAULT_DAS_PASSWORD;
		if(dasUsername != null)
			username = dasUsername;
		if(dasPassword != null)
			password = dasPassword;		
		System.out.println("Adding DOD Site with username [" + username + "] and password [" + password + "]");
		MIXSiteConfiguration site = new MIXSiteConfiguration(DEFAULT_DAS_SITE, 
				username, password, defaultDODXChangeApplication,
				defaultDODMetadataXChangePath1, defaultDODMetadataXChangePath2,
				defaultDODImageXChangePath1, defaultDODImageXChangePath1, false,
				defaultDODImageHost, defaultDODImagePort);
		addSiteConfiguration(site);
	}
	
	private void addSiteConfiguration(MIXSiteConfiguration site)
	{
		this.configurations.add(site);
	}

	public MIXSiteConfiguration getSiteConfiguration(String preferredSiteNumber, String alternateSiteNumber)
	throws MIXConfigurationException
	{		
		logger.debug("Searching for MIX data source site configuration [" + preferredSiteNumber + "]");
		for(int i = 0; i < configurations.size(); i++)
		{
			MIXSiteConfiguration site = configurations.get(i);
			if((site != null) && (site.equals(preferredSiteNumber)))
			{
				logger.debug("Found MIX data source site configuration [" + preferredSiteNumber + "]");
				return site;
			}
		}
		logger.warn("Unable to find preferred site [" + preferredSiteNumber + "] in MIX configuration");
		if((alternateSiteNumber != null) && (alternateSiteNumber.length() > 0))
		{
			logger.debug("Searching for MIX data source site configuration with alternative site [" + alternateSiteNumber + "]");
			for(int i = 0; i < configurations.size(); i++)
			{
				MIXSiteConfiguration site = configurations.get(i);
				if((site != null) && (site.equals(alternateSiteNumber)))
				{
					logger.debug("Found MIX data source site configuration for alternate site [" + alternateSiteNumber + "]");
					return site;
				}
			}
		}
		String msg = "Unable to find preferred site [" + preferredSiteNumber + "]";
		if((alternateSiteNumber != null) && (alternateSiteNumber.length() > 0))
			msg += " or alternate site number [" + alternateSiteNumber + "]";
		msg += " in MIX configuration";
		throw new MIXConfigurationException(msg);
	}

	/**
	 * return an unmodifiable List of configurations
	 * @return
	 */
	public List<MIXSiteConfiguration> getConfigurations() 
	{
		return configurations;
	}

	public void setConfigurations(List<MIXSiteConfiguration> configurations) 
	{
		this.configurations = configurations;
	}

	public List<String> getEmptyStudyModalities()
	{
		return emptyStudyModalities;
	}

	public void setEmptyStudyModalities(List<String> emptyStudyModalities)
	{
		this.emptyStudyModalities = emptyStudyModalities;
	}

	public int getMetadataTimeout()
	{
		return metadataTimeout;
	}

	public void setMetadataTimeout(int metadataTimeout)
	{
		this.metadataTimeout = metadataTimeout;
	}
	
	/**
	 * @return the truststoreUrl
	 */
	public String getTruststoreUrl() 
	{
		//return getTlsConfiguration().getTruststoreUrl().toString();
		return truststoreUrl;
	}

	/**
	 * @param truststoreUrl the truststoreUrl to set
	 * @throws MalformedURLException 
	 */
	public void setTruststoreUrl(String truststoreUrl) 
	//throws MalformedURLException 
	{
		//getTlsConfiguration().setTruststoreUrl(new URL(truststoreUrl));
		this.truststoreUrl = truststoreUrl;
	}

	/**
	 * @return the truststorePassword
	 */
	public String getTruststorePassword() 
	{
		//return getTlsConfiguration().getTruststorePassword();
		return truststorePassword;
	}

	/**
	 * @param truststorePassword the truststorePassword to set
	 */
	public void setTruststorePassword(String truststorePassword) 
	{
		//getTlsConfiguration().setTruststorePassword(truststorePassword);
		this.truststorePassword = truststorePassword;
	}

	/**
	 * @return the keystoreUrl
	 */
	public String getKeystoreUrl() 
	{
		//return getTlsConfiguration().getKeystoreUrl().toString();
		return keystoreUrl;
	}

	/**
	 * @param keystoreUrl the keystoreUrl to set
	 * @throws MalformedURLException 
	 */
	public void setKeystoreUrl(String keystoreUrl) 
	//throws MalformedURLException 
	{
		//getTlsConfiguration().setKeystoreUrl(new URL(keystoreUrl));
		this.keystoreUrl = keystoreUrl;
	}

	/**
	 * @return the keystorePassword
	 */
	public String getKeystorePassword() 
	{
		//return getTlsConfiguration().getKeystorePassword();
		return keystorePassword;
	}

	/**
	 * @param keystorePassword the keystorePassword to set
	 */
	public void setKeystorePassword(String keystorePassword) 
	{
		//getTlsConfiguration().setKeystorePassword(keystorePassword);
		this.keystorePassword = keystorePassword;
	}

	
}
