/*
 * Created on Aug 1, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
 */
package gov.va.med.imaging.dicom.scp.qrfactory.concreteproducts;

import gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet;
import gov.va.med.imaging.dicom.scp.exceptions.UnsupportedLevelException;
import gov.va.med.imaging.dicom.scp.exceptions.QRFactoryTranslationException;
import gov.va.med.imaging.dicom.scp.qrfactory.products.QueryRoot;
import gov.va.med.imaging.exchange.business.dicom.DicomMap;
import gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters;
import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.exchange.business.dicom.exceptions.DicomException;
import gov.va.med.imaging.exchange.business.dicom.exceptions.IllegalQueryDataException;
import gov.va.med.imaging.exchange.business.dicom.exceptions.IllegalQueryMoveModeException;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 *
 * This class extends the QueryRoot abstract class.  This class is part of the 
 * QueryFactory MethodFactory pattern.  This class instantiates when the C-Find-Rq
 * uses the Study Root SOP Class Presentation Context.
 *
 * @author William Peterson
 *
 */
public class QueryRootStudy extends QueryRoot {

    private static final Logger logger = LogManager.getLogger (QueryRootStudy.class);

    /**
     * Constructor
     */
    public QueryRootStudy() {
        super();
        //
    }

    /*
     *  (non-Javadoc)
     * @see gov.va.med.imaging.dicom.scp.factory.product.QueryRoot#createQueryParameters(gov.va.med.imaging.dicom.gov.va.med.imaging.dicom.common.interfaces.IBusinessDataSet, java.lang.String, java.util.HashSet)
     */
    public DicomRequestParameters createQueryParameters(IDicomDataSet dds)
                    throws QRFactoryTranslationException, UnsupportedLevelException{
    	
    	DicomRequestParameters request=null;
    	try
		{
            if(dds.getQueryRetrieveLevel().equalsIgnoreCase("STUDY")){
            	if(DicomServerConfiguration.getConfiguration().getAddedQueryElements() != null){
            		ArrayList<String> queryArray = DicomServerConfiguration.getConfiguration().getAddedQueryElements();
            		Iterator<String> iter = queryArray.iterator();
            		while(iter.hasNext()){
            			String tag = iter.next();
            			try{
            				if(!dds.containsDicomElement(tag, null)){
            					dds.insertDicomElement(tag, null, "");
            				}
            			}
            			catch(DicomException dX){
            				//do nothing
            			}
            		}
            	}
                request = dds.createStudyQueryRequestParameters();
            	request.setRequestMappingSet(dds.getQueryMappingSet());                
            }
            else{
                logger.error("Currently, only supports Study Level.");
                logger.error(this.getClass().getName()+": "+
                        "\nException thrown while creating C-Find Parameters.");
                throw new UnsupportedLevelException("Received Query Level not supported.");
            }
		}
    	catch (IllegalQueryDataException iqde) {
            logger.error(iqde.getMessage());
            logger.error(this.getClass().getName()+": " +
                    "\nException thrown while creating C-Find Parameters.",iqde);
    		throw new QRFactoryTranslationException("Failure to create C-Find Parameters.", iqde);
    	}
        return request;
    }
    
    /*
     *  (non-Javadoc)
     * @see gov.va.med.imaging.dicom.scp.factory.product.QueryRoot#createMoveParameters(gov.va.med.imaging.dicom.gov.va.med.imaging.dicom.common.interfaces.IBusinessDataSet, java.lang.String)
     */
    public DicomRequestParameters createMoveParameters(IDicomDataSet dds)
    throws QRFactoryTranslationException, UnsupportedLevelException{
    	
    	DicomRequestParameters hMap=null;
    	try
		{
            if(dds.getQueryRetrieveLevel().equalsIgnoreCase("STUDY")){
                hMap = dds.createMoveRequestParameters();
            }
            else{
                logger.error("Currently, only supports Study Level.");
                logger.error(this.getClass().getName()+": "+
                        "\nException thrown while creating C-Move Parameters.");
                throw new UnsupportedLevelException();
            }
		}
    	catch (IllegalQueryDataException iqde) {
            logger.error(iqde.getMessage());
            logger.error(this.getClass().getName()+": " +
                    "\nException thrown while creating C-Move Parameters.",iqde);
    		throw new QRFactoryTranslationException("Failure to create C-Move Parameters.", iqde);
    	}
        return hMap;
    }
}
