/*
 * Created on Aug 15, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
 */
package gov.va.med.imaging.dicom.scp.movescp.impl;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.InvalidUserCredentialsException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.dicom.DicomContext;
import gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet;
import gov.va.med.imaging.dicom.scp.exceptions.GenericDicomSCPException;
import gov.va.med.imaging.dicom.scp.exceptions.QRFactoryTranslationException;
import gov.va.med.imaging.dicom.scp.exceptions.UnsupportedLevelException;
import gov.va.med.imaging.dicom.scp.movescp.interfaces.IMoveSCPControl;
import gov.va.med.imaging.dicom.scp.qrfactory.factory.QueryRootFactory;
import gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters;
import gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver;

import java.util.Observer;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 *
 * This is the implmentation of the MoveSCPControl Interface.  It also extends
 * ServiceSCPControl.  This class is basically the Control class that generally interacts
 * between the DICOM Toolkit Layer and the Business Layer. 
 * 
 * 
 * @author William Peterson
 *
 */
public class MoveSCPControlImpl implements IMoveSCPControl {
    
    private static Logger logger = LogManager.getLogger (MoveSCPControlImpl.class);

    
   /* (non-Javadoc)
     * @see gov.va.med.imaging.dicom.scp.movescp.interfaces.IMoveSCPControl#moveItems(java.lang.String, gov.va.med.imaging.dicom.common.interfaces.IBusinessDataSet, java.lang.String, java.lang.String, java.util.Observer)
     */
    public MoveCommandObserver moveItems(String storeAETitle, IDicomDataSet dds,
            Observer subOperationsSubscriber) throws GenericDicomSCPException, InvalidUserCredentialsException
    {

    	MoveCommandObserver cancelMoveHandle = null;
        try{
            //call QueryFactory to pass a HashMap object to the business layer.
            QueryRootFactory queryFactory = new QueryRootFactory();
            DicomRequestParameters queryParams = queryFactory.createMoveRequestParameters(dds);
            if(queryParams != null){
            	logger.debug("Move HashMap: " + queryParams.toString());
            }

            //Call copyInstances method in the business layer.
            logger.info(this.getClass().getName()+": Generic Dicom Layer: " +
                    "...calling Business layer to Move DICOM Objects.");
            cancelMoveHandle = DicomContext.getRouter().processCMoveResults(storeAETitle, queryParams, subOperationsSubscriber);
        }
        catch (InvalidUserCredentialsException e)
        {
        	// Rethrow this specific exception, so that we can shut down the listeners
        	// at the top level (DicomMoveSCPImpl)
        	throw(e);
        }
        catch(ConnectionException ce){
            logger.error(ce.getMessage());
            logger.error(this.getClass().getName()+": " +
                    "Exception thrown while processing C-Move Request.");
            throw new GenericDicomSCPException("Failure to handle C-Move Request.", ce);
        }
        catch(MethodException me){
            logger.error(me.getMessage());
            logger.error(this.getClass().getName()+": " +
                    "Exception thrown while processing C-Move Request.");
            throw new GenericDicomSCPException("Failure to handle C-Move Request.", me);
        }
        catch(QRFactoryTranslationException pte){
            logger.error(pte.getMessage());
            logger.error(this.getClass().getName()+": " +
                    "Exception thrown while processing C-Move Request.");
            throw new GenericDicomSCPException("Failure to handle C-Move Request.", pte);
        }
        catch(UnsupportedLevelException idde){
            logger.error(idde.getMessage());
            logger.error(this.getClass().getName()+": " +
                    "Exception thrown while processing C-Move Request.");
            throw new GenericDicomSCPException("Failure to handle C-Move Request.", idde);
        }
        //return the Thread ID.
        return cancelMoveHandle;
    }    
}
