/*
 * Created on Aug 1, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
  */
package gov.va.med.imaging.dicom.scp.findscp.impl;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.InvalidUserCredentialsException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.dicom.DicomContext;
import gov.va.med.imaging.dicom.DicomRouter;
import gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet;
import gov.va.med.imaging.dicom.common.interfaces.IFindSCPResponseCallback;
import gov.va.med.imaging.dicom.scp.exceptions.GenericDicomSCPException;
import gov.va.med.imaging.dicom.scp.exceptions.QRFactoryTranslationException;
import gov.va.med.imaging.dicom.scp.exceptions.UnsupportedLevelException;
import gov.va.med.imaging.dicom.scp.findscp.interfaces.IFindSCPControl;
import gov.va.med.imaging.dicom.scp.qrfactory.factory.QueryRootFactory;
import gov.va.med.imaging.exchange.business.dicom.CFindResults;
import gov.va.med.imaging.exchange.business.dicom.DicomAE;
import gov.va.med.imaging.exchange.business.dicom.DicomRequestParameters;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 *
 * This is the implmentation of the FindSCPControl Interface.  It also extends
 * ServiceSCPControl.  This is basically the Control class that generally interacts
 * between the DICOM Toolkit Layer and the Business Layer. 
 * 
 * @see gov.va.med.imaging.dicom.gov.va.med.imaging.dicom.scp.findscp.interfaces.IFindSCPControl
 *
 * @author William Peterson
 *
 */
public class FindSCPControlImpl implements IFindSCPControl {

    
    private static final Logger logger = LogManager.getLogger (FindSCPControlImpl.class);
        
    /**
     * Constructor
     */
    public FindSCPControlImpl() {
        super();
        
    }

     
    /* (non-Javadoc)
     * @see gov.va.med.imaging.dicom.scp.findscp.interfaces.IFindSCPControl#requestMatchingItems(gov.va.med.imaging.dicom.common.interfaces.IBusinessDataSet, java.lang.String, java.lang.String)
     */
    public CFindResults requestMatchingItems(IDicomDataSet dicomDataSet) 
    throws GenericDicomSCPException, InvalidUserCredentialsException
    {

        try{
            //query the QueryFactory.  The result will be in a HashMap.
            QueryRootFactory queryFactory = new QueryRootFactory();
            logger.info(this.getClass().getName()+": Generic Dicom Layer: " +
                    "...processing C-Find message.");
            
            //DicomRequestParameters inherits HashMap<String,String>.  Thus, a HashMap is still used to build a list if DICOM 
            //	elements and corresponding values to prep for the RPC call.
            DicomRequestParameters queryParams = queryFactory.createQueryRequestParameters(dicomDataSet);
           
            logger.debug("HashMap of Query Parameters: ");
            logger.debug(queryParams.toString());
            
            
            //call method to business facade and pass the Hashmap.
            //It will return a RowSet object.
            logger.info(this.getClass().getName()+": Generic Dicom Layer: " +
                    "...calling Business Layer.");
            
    		DicomRouter rtr = DicomContext.getRouter();
    		CFindResults queryResultSet = rtr.getCFindResults(queryParams);
    		queryResultSet.setRequestMappingSet(queryParams.getRequestMappingSet());
            
            //return the response list.
            logger.info(this.getClass().getName()+": Generic Dicom Layer: " +
                    "...received RowSet object from Business Layer.");
            return queryResultSet;
        }
        catch (InvalidUserCredentialsException e)
        {
        	// Rethrow this specific exception, so that we can shut down the listeners
        	// at the top level (DicomMoveSCPImpl)
        	throw(e);
        }
        catch(MethodException mX){
            throw new GenericDicomSCPException(mX);
        }
        catch(ConnectionException cX){
            throw new GenericDicomSCPException(cX);
        }
        catch (QRFactoryTranslationException ptX){
            throw new GenericDicomSCPException(ptX);
        }
        catch (UnsupportedLevelException iddsX){
            throw new GenericDicomSCPException(iddsX);
        }
    }
    
    
    public void sendCFindResults(CFindResults resultSet, DicomAE dicomAE, IFindSCPResponseCallback callback)
    				throws GenericDicomSCPException{
    	
        logger.info(this.getClass().getName()+": Generic Dicom Layer: " +
        "...creating and sending C-Find response messages.");

		DicomRouter rtr = DicomContext.getRouter();
		try {
			boolean performed = rtr.processCFindResults(resultSet, dicomAE, callback);
			if(!performed){
				throw new GenericDicomSCPException("Router Command returned False.");
			}
		} 
		catch (MethodException mX) {
            throw new GenericDicomSCPException(mX);
			
		} 
		catch (ConnectionException cX) {
            throw new GenericDicomSCPException(cX);
		}
    }
}
