/*
 * Created on Nov 18, 2005
 *
 */
package gov.va.med.imaging.core.router.commands;

import java.io.IOException;
import java.nio.charset.Charset;

import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.notifications.email.NotificationEmailConfiguration;
import junit.framework.TestCase;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

/**
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * @author William Peterson
 *
 */
public class ImagingDicomRouterTestBase extends TestCase {
  
    public static Logger logger =null; //LogManager.getRootLogger();
    public static ConsoleAppender appender;


    /*
     * @see TestCase#setUp()
     */
    @SuppressWarnings("deprecation")
	protected void setUp() throws Exception {
        super.setUp();
//        appender = new ConsoleAppender(new PatternLayout());
//        logger.addAppender(appender);
//        logger.setLevel(Level.DEBUG);
    	
		LoggerContext context= (LoggerContext) LogManager.getContext();
        Configuration config= context.getConfiguration();
		
		PatternLayout layout = PatternLayout.createLayout(
				"%d{DATE} %5p [%t] (%F:%L) - %m%n", 
				null, 
				null, 
				null, 
				Charset.defaultCharset(), 
				false,
				false,
				null,
				null);

		appender=ConsoleAppender.createAppender(layout, null, null, "CONSOLE_APPENDER", null, null);
	    appender.start();
	    AppenderRef ref= AppenderRef.createAppenderRef("CONSOLE_APPENDER",null,null);
        AppenderRef[] refs = new AppenderRef[] {ref};
        LoggerConfig loggerConfig= LoggerConfig.createLogger(
        		"false", Level.INFO,"CONSOLE_LOGGER","true",refs,null,config,null);
        loggerConfig.addAppender(appender,null,null);
		
		config.addAppender(appender);
        config.addLogger("ImagingDicomRouterTestBase", loggerConfig);
        context.updateLoggers(config);

        logger=LogManager.getContext().getLogger("ImagingDicomRouterTestBase");

        Configurator.setLevel("ImagingDicomRouterTestBase", Level.DEBUG);

		DicomServerConfiguration.getConfiguration().setSiteId("660");
		DicomServerConfiguration.getConfiguration().setHostName("test");
		NotificationEmailConfiguration.getConfiguration().setMaximumMessageCountPerEmail(20);
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
        //logger.removeAllAppenders();
        LogManager.shutdown();
    }

    /**
     * Constructor for DicomDCFSCUTestBase.
     * @param arg0
     */
    public ImagingDicomRouterTestBase(String arg0) {
        super(arg0);
    }
}
