/*
 * Created on Aug 3, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
 */
package gov.va.med.imaging.dicom.dcftoolkit.scp;

import gov.va.med.imaging.dicom.dcftoolkit.common.exceptions.ParseIODException;
import gov.va.med.imaging.dicom.dcftoolkit.common.validation.DoIODValidationImpl;
import gov.va.med.imaging.exchange.business.dicom.DicomAE;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.lbs.DCS.DCSException;
import com.lbs.DCS.DicomDataSet;
import com.lbs.DCS.DicomSessionSettings;
import com.lbs.DCS.DimseMessage;
import com.lbs.DCS.ValidationErrorList;

/**
 *
 * Common Service SCP class.  Some of the DICOM Services use common functionality.
 * Those common functionalities are located in this class.  The specific Service
 * classes in this layer shall extend this class.
 *
 * @author William Peterson
 *
 */
public class ServiceSCP extends DoIODValidationImpl
{

    
    /*
     * Session Settings.  This is DCF toolkit specific.  This is related to the 
     * specific association in the Assocation Manager.
     */
    protected DicomSessionSettings session_settings = null;
    
    protected static final Logger logger = LogManager.getLogger (ServiceSCP.class);
    protected static final Logger summaryLogger = LogManager.getLogger("Summary");

   
   /**
    * Set SessionSettings for configuring DataByteReader streaming.  This is
    * specific to the DCF Toolkit.
    * 
    * @param represents the SessionSettings.
    */
   public void setSessionSettings(DicomSessionSettings settings){
       this.session_settings = settings;
   }
   

    /**
     * Constructor
     */
    public ServiceSCP() {
        super();
    }
    
    /**
     * Parse the DicomDataSet from the Dimse Message.
     * 
     * @param c_find_rq represents the Dimse Message.
     * @return DicomDataSet
     */
    public DicomDataSet parseIOD(DimseMessage requestMessage)
             throws ParseIODException{
        return requestMessage.data();
    }
    
    /**
     * Common utility method to log any VR Violations that exist in a Dimse Message.
     * 
     * @param ae represents the DICOM AE device that sent the Dimse Message.
     * @param dm represents the actual Dimse Message.
     * @param violations represents the list of VR violations resulting from the Dimse Message.
     */
    protected void logVRViolationsForDimseMessage(DicomAE ae, DimseMessage dm, ValidationErrorList violations){
		int commandField;
		try {
			commandField = dm.commandField();
		} catch (DCSException dcsX){
			commandField = 0;
		}
		String str = this.logViolations(violations);
		logger.error(this.getClass().getName()+": VR Violation Error(s) in "
				+DimseMessage.translateCommand(commandField)+" message from "+ae.getRemoteAETitle()+".\n"
				+"VR Violations= "+ str);

    }
 
}
