/*
 * Created on Aug 15, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
 * 
 */
package gov.va.med.imaging.dicom.dcftoolkit.movescp.impl;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.InvalidUserCredentialsException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.router.facade.InternalContext;
import gov.va.med.imaging.dicom.common.SpringContext;
import gov.va.med.imaging.dicom.common.interfaces.IDicomDataSet;
import gov.va.med.imaging.dicom.dcftoolkit.common.exceptions.DicomMoveSCPException;
import gov.va.med.imaging.dicom.dcftoolkit.common.exceptions.ParseIODException;
import gov.va.med.imaging.dicom.dcftoolkit.listen.Listen;
import gov.va.med.imaging.dicom.dcftoolkit.movescp.interfaces.IDicomMoveSCP;
import gov.va.med.imaging.dicom.dcftoolkit.scp.ServiceSCP;
import gov.va.med.imaging.dicom.scp.exceptions.GenericDicomSCPException;
import gov.va.med.imaging.dicom.scp.movescp.interfaces.IMoveSCPControl;
import gov.va.med.imaging.exchange.business.AuditEvent;
import gov.va.med.imaging.exchange.business.dicom.DicomAE;
import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.exchange.business.dicom.MoveCommandObserver;

import java.util.HashMap;
import java.util.Observer;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.lbs.DCS.AssociationAcceptor;
import com.lbs.DCS.DCM;
import com.lbs.DCS.DCSException;
import com.lbs.DCS.DicomDataSet;
import com.lbs.DCS.DimseMessage;
import com.lbs.DCS.ValidationErrorList;

/**
 *
 * Implementation of the IDicomMoveSCP and Observer Interfaces.  This class also extends
 * the ServiceSCP class.  This implementation receives the toolkit specific 
 * DicomDataset.  The DICOM Dataset is converted to a generic DicomDataSetThe and 
 * then passed to the Generic DICOM Layer.
 *
 * @author William Peterson.
 *
 */


public class DicomMoveSCPImpl extends ServiceSCP implements IDicomMoveSCP{
    
    

   /*
    * VA class. StoreControl works at the Generic DICOM layer.
    */
   private IMoveSCPControl moveControl = null;
      
   /*
    * Toolkit class.  Need it stored here for help creating the cMoveRsp DimseMessage object.
    */
   private DimseMessage cMoveRq = null;
   
   /*
    * Toolkit class. Need it stored here for help returning the cMoveRsp DimseMesssage object.
    */
   private AssociationAcceptor assocAcceptor = null;
   private static Logger logger = LogManager.getLogger (DicomMoveSCPImpl.class);

    /**
     * Constructor
     */
    public DicomMoveSCPImpl() {
        super();

    }

    
    /* (non-Javadoc)
     * @see gov.va.med.imaging.dicom.dcftoolkit.movescp.interfaces.IDicomMoveSCP#receiveMove(com.lbs.DCS.AssociationAcceptor, com.lbs.DCS.DimseMessage, gov.va.med.imaging.dicom.dcftoolkit.common.SubOperationsListener, boolean)
     */
    public MoveCommandObserver receiveMove(AssociationAcceptor assocAcceptor, DimseMessage cMoveRq, 
            Observer subOperationsSubscriber) throws DicomMoveSCPException, InvalidUserCredentialsException
    {
        
        //Save info about the Association and the Dimse message.  This is needed later 
        // to build individual Dimse messages for the SubOperationsStatus responses.
        //FUTURE Might have to take one or all of these statements out. I might not want them to
        // last past the method scope.  Review this later.
        this.moveControl = (IMoveSCPControl)SpringContext.getContext().getBean("MoveSCPControl");
        this.assocAcceptor = assocAcceptor;
        this.cMoveRq = cMoveRq;
        MoveCommandObserver cancelMoveHandle = null;
        
        String AETitle = assocAcceptor.getAssociationInfo().callingTitle();
        logger.debug(Thread.currentThread().getName()+": Calling AETitle for C-Move message: "+AETitle);
        
        try {
        	HashMap<String, String> eventElements = new HashMap<String, String>();
        	eventElements.put("AETitle", AETitle);
        	String message = AETitle+", CMove Request.";
			InternalContext.getRouter().postAuditEvent(
						null,
						new AuditEvent(AuditEvent.DICOM_RETRIEVE,
								DicomServerConfiguration.getConfiguration().getHostName(),
								DicomServerConfiguration.getConfiguration().getApplicationName(),
								message,
								eventElements));
		}   
        catch (InvalidUserCredentialsException e)
        {
        	// Rethrow here so it can be handled at the top level.
        	throw(e);
        }
        catch (ConnectionException cX) {
            logger.error(cX.getMessage());
            logger.error(this.getClass().getName()+": Exception thrown posting to Audit Log.");			
		} 
	    catch (MethodException mX) {
            logger.error(mX.getMessage());
            logger.error(this.getClass().getName()+": Exception thrown posting to Audit Log.");			
		}
	    
        try{
            DicomAE dicomAE = Listen.getDicomAEObject(assocAcceptor);
            //VR-Validate the incoming identifier.
            ValidationErrorList violations = this.validateVRs(dicomAE, cMoveRq);
			if(violations.hasErrors()){
				this.logVRViolationsForDimseMessage(dicomAE, cMoveRq, violations);
				throw new DicomMoveSCPException("VR Violation Error(s) in C-Move-RQ message");
			}
        	
        	//parse Dicom Dataset
            logger.info(this.getClass().getName()+": Dicom Toolkit layer: " +
            "...parsing incoming IOD.");            	
            DicomDataSet dds = this.parseIOD(cMoveRq);
            
            logger.info(this.getClass().getName()+": Dicom Toolkit layer: " +
            "Received C-Move DataSet: ");
            logger.info("\n"+dds.toString());
        
            //make sure the UID exist before proceeding.
            String moveRootUID = cMoveRq.affectedSopclassUid();            
            if((moveRootUID == null) || (moveRootUID.equals(""))){
                logger.error(this.getClass().getName()+": Dicom Toolkit layer: " +
                        "...throwing exception because of empty Query Root UID.");
                throw new DicomMoveSCPException("No Move SOP Class UID.");
            }

            //Get the StoreAETitle
            String storeAETitle = cMoveRq.moveDestination();
            if((storeAETitle == null) || (storeAETitle.equals(""))){
            	logger.error(this.getClass().getName()+": No or empty Store AETitle.");
            	throw new DicomMoveSCPException("No or empty Store AETitle.");
            }
            else{
            	storeAETitle = storeAETitle.trim();
            }
            	                
            //get the move Level
            String moveLevel = dds.getElementStringValue( DCM.E_QUERYRETRIEVE_LEVEL, "" );
            if((moveLevel == null) || (moveLevel.equals(""))){
            	logger.error(this.getClass().getName()+": No or empty Move Level.");
                throw new DicomMoveSCPException("No or empty Move Level.");                	
                }
                else{
                	moveLevel = moveLevel.trim();
                }
  
                //Creating a Generic DICOM Dataset to exist at the Generic DICOM layer.
            //  At this point, the DICOM Dataset becomes toolkit independent by way
            //  of the Interface.
            IDicomDataSet dataset = (IDicomDataSet)SpringContext.getContext().getBean("DicomDataSet");
            dataset.setDicomDataSet(dds);
            dataset.setAffectedSOPClass(moveRootUID);
            //call moveItems() method in MoveControl object.
            logger.info(this.getClass().getName()+"...processing C-Move message.");
            cancelMoveHandle = moveControl.moveItems(storeAETitle, dataset, subOperationsSubscriber);       
        }
        catch (DCSException dcse){
            logger.error(dcse.getMessage());
            logger.error(this.getClass().getName()+": Exception thrown processing Move Request.");
            throw new DicomMoveSCPException();
        }
        catch (ParseIODException parseException){
            logger.error(parseException.getMessage());
            logger.error(this.getClass().getName()+": Exception thrown processing Move Request.");
            throw new DicomMoveSCPException();
        }
        catch (GenericDicomSCPException persistenceException){
            logger.error(persistenceException.getMessage());
            logger.error(this.getClass().getName()+": Exception thrown processing Move Request.");
            throw new DicomMoveSCPException();
        }
        return cancelMoveHandle;
    }    
}
