/*
 * Created on Sep 16, 2005
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+
 *
 */
package gov.va.med.imaging.dicom.dcftoolkit.listen;

import java.util.Hashtable;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.lbs.CDS.CDSException;
import com.lbs.DCF.DCFException;
import com.lbs.DCS.AssociationAcceptor;
import com.lbs.DCS.AssociationManager;
import com.lbs.DCS.DCSException;
import com.lbs.DSS.QRServer;

/**
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * @author William Peterson
 *
 */
public class SpecializedQRServer extends QRServer {

    /**
     * The association manager which is listening for incoming associations.
     */
    private AssociationManager amgr_ = null;

    /**
     * The hash map of pointer to QRSCP objects, that is keyed by the socket file descriptor
     */
    private static Hashtable<AssociationAcceptor, SpecializedQRSCP> scp_map_ = null;
    
    Logger logger = LogManager.getLogger(SpecializedQRServer.class);
    

    /**
     * Constructor
     *
     * @param arg0
     * @throws com.lbs.CDS.CDSException
     */
    public SpecializedQRServer(AssociationManager arg0) throws CDSException {
        super(arg0);
    }
    
    /**
     * Called at the start of a new association.
     * @param assoc represents the DICOM association that is being negotiated.
     * The association has not yet been accepted or rejected. That will be determined
     * after each AssociationListener creates SCP objects which will accept various
     * presentation contexts.
     * @throws DCSException if an error occurs.
     */
     public void beginAssociation( AssociationAcceptor assoc )
     {
         LOG.debug( CINFO.df_SHOW_GENERAL_FLOW, "QRServer: beginAssociation" );
         if ( scp_map_ == null )
         {
             scp_map_ = new Hashtable<AssociationAcceptor, SpecializedQRSCP>();
         }
        try
        {
            scp_map_.put( assoc, new SpecializedQRSCP( assoc ) );
        }
        catch( DCFException e )
        {
            LOG.error( -1, "", e );
            
            logger.error(e.getMessage());
            logger.error(this.getClass().getName()+": Failure to add Association to hashtable.");
            logger.error("Trace:", e);
        }
     }

     /**
     * Called at the end of an association.
     * @param assoc the handle corresponding to the connected socket.
     */
     public void endAssociation( AssociationAcceptor assoc )
     {
         LOG.debug( CINFO.df_SHOW_GENERAL_FLOW, "QRServer: endAssociation" );
         scp_map_.remove( assoc );
     }

     public static SpecializedQRSCP getSpecializedQRSCPObject(AssociationAcceptor assoc){
         return scp_map_.get(assoc);
     }

}
