/*
 * Created on Nov 9, 2007
// Per VHA Directive 2004-038, this routine should not be modified.
//+---------------------------------------------------------------+
//| Property of the US Government.                                |
//| No permission to copy or redistribute this software is given. |
//| Use of unreleased versions of this software requires the user |
//| to execute a written test agreement with the VistA Imaging    |
//| Development Office of the Department of Veterans Affairs,     |
//| telephone (301) 734-0100.                                     |
//|                                                               |
//| The Food and Drug Administration classifies this software as  |
//| a medical device.  As such, it may not be changed in any way. |
//| Modifications to this software may result in an adulterated   |
//| medical device under 21CFR820, the use of which is considered |
//| to be a violation of US Federal Statutes.                     |
//+---------------------------------------------------------------+ 
 */
package gov.va.med.imaging.dicom.dcftoolkit.listen;

import java.util.Date;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.lbs.CDS.CFGGroup;
import com.lbs.LOG.LOGClient;
import com.lbs.LOG.LOGOutput;

/**
 *
 *
 *
 * @author William Peterson
 *
 */
public class Log4JOutput implements LOGOutput{

    private static final Logger logger = LogManager.getLogger ("DCF_Lib");

    /* (non-Javadoc)
     * @see com.lbs.LOG.LOGOutput#shutdown()
     */
    @Override
    public void shutdown(){
        //LogManager.shutdown();

    }


    /* (non-Javadoc)
     * @see com.lbs.LOG.LOGOutput#writeMessage(int, java.util.Date, int, java.lang.String, java.lang.String, int, java.lang.String, java.lang.String, com.lbs.CDS.CFGGroup)
     */
    @Override
    public void writeMessage(int messageType, Date date, int errorCode, String applicationName, String componentName, int applicationPid, String threadName,
                String messageText, CFGGroup userDataCFGGroup){
    /*
    0 message_type - one of the MSG_TYPE constants in LOGClient
    1 date - Date the message was given to LOGClient
    2 error_code - for error, and fatal_error types only, ignored otherwise
    3 application_name - the name for this application or process
    4 component_name - the name of the component that generated the message
    5 application_pid - the OS process ID of the application
    6 thread_name - the name of the java thread that generated the message
    7 message_text - the message
    8 user_data - additional message context
    */
    	
    	String message = ": " + messageText;
    	if (userDataCFGGroup != null)
    	{
    		message += " - " + userDataCFGGroup.toString();
    	}
    	
    	String messageLocation = " (" + applicationName+"." + componentName + "." + applicationPid + ") ";
        
        switch(messageType){
            case(LOGClient.MSG_TYPE_FATAL_ERROR):
                logger.fatal("DCF[Err:"+errorCode+"]" + message + messageLocation);
                break;
            case(LOGClient.MSG_TYPE_ERROR):
                logger.error("DCF[Err:"+errorCode+"]" + message + messageLocation);
                break;
            case(LOGClient.MSG_TYPE_INFO):
                logger.info("DCF" + message + messageLocation);
                break;
            case(LOGClient.MSG_TYPE_DEBUG):
                logger.debug("DCF" + message + messageLocation);
            	break;
            case(LOGClient.MSG_TYPE_STDOUT):
                logger.info("DCF" + message + messageLocation);
            	break;
            case(LOGClient.MSG_TYPE_STDERR):
                logger.error("DCF" + message + messageLocation);
            	break;
        }    
    }
    
}
