package gov.va.med.imaging.storage.cache;

import gov.va.med.imaging.storage.cache.impl.CacheManagerImpl;
import gov.va.med.server.ServerLifecycleEvent;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;

import junit.framework.TestCase;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public abstract class AbstractCacheTest 
extends TestCase
{
	private Cache cache = null;
	private CacheManagerImpl cacheManager = null;
	private String localhostName;

	private static Logger logger = null; //LogManager.getLogger(AbstractCacheTest.class);

	// by default, create a cache with the same name as the unit test
	protected String getCacheName()
	{
		return this.getName();
	}
	
	protected abstract URI getCacheUri()
	throws URISyntaxException;
	
	protected abstract String getPrototypeName();
	
	protected void setUp() 
	throws Exception
	{
		super.setUp();
		
		initializeLogging(this.getName(), Level.WARN);
		logger.info("Starting unit test '" + this.getName() + "' =======================================================");
		
		jcifs.Config.setProperty( "jcifs.util.loglevel", "4" );
		jcifs.Config.setProperty( "jcifs.resolveOrder", "DNS" );
		
		InetAddress localhostAddress = InetAddress.getLocalHost();
		localhostName = localhostAddress.getHostName();
		
		cacheManager = CacheManagerImpl.getSingleton();
		cache = cacheManager.createCache(getCacheName(), getCacheUri(), getPrototypeName());
		cache.setInitialized(true);
		cache.setEnabled(true);
		cacheManager.serverLifecycleEvent(new ServerLifecycleEvent(ServerLifecycleEvent.EventType.START));
	}

	public String getLocalhostName()
	{
		return this.localhostName;
	}

	protected void tearDown() throws Exception
	{
		cacheManager.disable(cache);
		cache.cacheLifecycleEvent(CacheLifecycleEvent.STOP);
		cacheManager.delete(cache);

		logger.info("Stopping unit test '" + this.getName() + "' =======================================================");
		super.tearDown();
	}

	/**
	 * 
	 */
	public static void initializeLogging(String name)
	{
		initializeLogging(name, Level.DEBUG);
	}
	
	@SuppressWarnings("deprecation")
	public static void initializeLogging(String name, Level level)
	{
//      Appender appender = null;
//		
//		Logger.getRootLogger().setLevel(level);
//		Layout layout = new org. apache.log4j.PatternLayout("%d{DATE} %5p [%t] (%F:%L) - %m%n");
//		try
//		{
//			appender = new org. apache.log4j.FileAppender(layout, name + ".junit.result", false);
//		} 
//		catch (IOException x)
//		{
//			appender = new org. apache.log4j.ConsoleAppender(layout);
//		}
//		Logger.getRootLogger().addAppender(appender);

//		Appender consoleAppender = new org. apache.log4j.ConsoleAppender(layout);
//		Logger.getRootLogger().addAppender(consoleAppender);
		
		// turn down clustering messages
		//LogManager.getLogger("gov.va.med.imaging.cluster").setLevel(Level.WARN);

		
		Configurator.setRootLevel(level);
		
		LoggerContext context= (LoggerContext) LogManager.getContext();
        Configuration config= context.getConfiguration();
		
		PatternLayout layout = PatternLayout.createLayout(
				"%d{DATE} %5p [%t] (%F:%L) - %m%n", 
				null, 
				null, 
				null, 
				Charset.defaultCharset(), 
				false,
				false,
				null,
				null);

		Appender appender = FileAppender.createAppender(
				name + ".junit.result", 
				"false", "false", "File", "true",
		        "false", "false", "4000", layout, null, "false", null, config);

	    appender.start();
	    AppenderRef ref= AppenderRef.createAppenderRef("File",null,null);
        AppenderRef[] refs = new AppenderRef[] {ref};
        LoggerConfig loggerConfig= LoggerConfig.createLogger(
        		"false", Level.INFO,"FILE_LOGGER","true",refs,null,config,null);

        loggerConfig.addAppender(appender,null,null);
		config.addAppender(appender);

        //Create Console Appender
        Appender cappender=ConsoleAppender.createAppender(layout, null, null, "CONSOLE_APPENDER", null, null);
	    cappender.start();
		config.addAppender(cappender);

		config.addLogger("AbstractCacheTest", loggerConfig);
        context.updateLoggers(config);
        
        logger=LogManager.getContext().getLogger("AbstractCacheTest");
        
	}

	protected Cache getCache()
	{
		return cache;
	}
	
}
