package gov.va.med.imaging.hi5.server;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class SameOriginPolicyFilter
implements Filter
{
    private String allowableServers = null;
    private Logger logger = LogManager.getLogger(this.getClass().getName());
    
    @Override
    public void init(FilterConfig config) 
    throws ServletException
    {
	this.allowableServers = config.getInitParameter("AllowableServers");
	
	if(allowableServers != null)
	    logger.info("SameOriginPolicyFilter will add 'Access-Control-Allow-Origin=" + this.allowableServers + "'.");
	else
	    logger.info("SameOriginPolicyFilter will NOT add 'Access-Control-Allow-Origin', no AllowableServers set in filter configuration.");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) 
    throws IOException, ServletException
    {
	filterChain.doFilter(request, response);
	if(allowableServers != null && allowableServers.length() > 0 && response instanceof HttpServletResponse)
	{
	    logger.info("Adding HTTP header 'Access-Control-Allow-Origin=" + this.allowableServers + "'.");
	    ((HttpServletResponse)response).addHeader("Access-Control-Allow-Origin", allowableServers);
	}
    }

    @Override
    public void destroy()
    {
    }
}
