/**
 * 
 */
package gov.va.med.imaging.hi5.client;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gwt.canvas.dom.client.CanvasPixelArray;

/**
 * @author       BECKEC
 *
 */
public class PixelTransform
{
    Logger logger = LogManager.getLogger("PixelTransformation");
    
    private final ImageStatistics imageStats;
    private boolean invert = false;
    
    public PixelTransform(ImageStatistics imageStats)
    {
        this.imageStats = imageStats;
    }

    public ImageStatistics getImageStats()
    {
        return imageStats;
    }

    public boolean isInvert()
    {
        return invert;
    }

    public void setInvert(boolean invert)
    {
        this.invert = invert;
    }

    /**
     * Set everything back so this becomes an identity transformation
     */
    public void revert()
    {
        setInvert(false);
    }

    /**
     * 
     * @param cpa
     * @param height
     * @param width
     * @param bitDepth
     */
    public void execute(CanvasPixelArray cpa)
    {
        if(invert)
        {
            int grayScales = imageStats.getGrayScaleLevels();
            
            logger.info("Inverting " + cpa.getLength() + " pixels (" + cpa.get(0) + "->" + (grayScales - cpa.get(0)) + ")" );
            for(int pixelIndex = 0; pixelIndex < cpa.getLength(); ++pixelIndex)
            {
                int pixelOffset = (int)pixelIndex * 4;
                RGBPixel sourcePixel = new RGBPixel(cpa, pixelOffset);
                RGBPixel destPixel = transformPixel(sourcePixel);
                
                //logger.fine("\t invert (" + sourceRedValue + "->" + destRedValue + ")");
                
                cpa.set(pixelOffset + RGBPixel.RED_OFFSET, destPixel.getRed() );      // red channel value
                cpa.set(pixelOffset + RGBPixel.GREEN_OFFSET, destPixel.getGreen() );  // green channel value
                cpa.set(pixelOffset + RGBPixel.BLUE_OFFSET, destPixel.getBlue() );    // blue channel value
                cpa.set(pixelOffset + RGBPixel.ALPHA_OFFSET, destPixel.getAlpha() );    // alpha channel value
            }
        }
    }

    /**
     * Return the inverse of the pixel values, that is the maximum pixel depth - the current value.
     * The alpha channel is the same as the original value.
     * 
     * @param originPixel
     * @return
     */
    public RGBPixel transformPixel(RGBPixel originPixel)
    {
        RGBPixel transformedPixel = originPixel;
        
        if(isInvert())
            transformedPixel = new RGBPixel(
                imageStats.getDisplayGrayScaleLevels() - originPixel.getRed(), 
                imageStats.getDisplayGrayScaleLevels() - originPixel.getGreen(),
                imageStats.getDisplayGrayScaleLevels() - originPixel.getBlue(),
                originPixel.getAlpha()
            );
        
        return transformedPixel;
    }
}
