/**
 * 
 */
package gov.va.med.imaging.hi5.client;

import gov.va.med.imaging.dicom.dataset.elements.DataElement;
import gov.va.med.imaging.dicom.dataset.elements.DataElementTag;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.smartgwt.client.widgets.grid.ListGridRecord;

/**
 * @author       BECKEC
 *
 */
public class DicomDataElementRecord 
extends ListGridRecord
{
    private Logger logger = LogManager.getLogger("DicomDataElementRecord");
    
    public static final String ELEMENT_TAG = "elementTag";
    public static final String ELEMENT_VALUE = "elementValue";
    
    private DataElementTag dataElementTag;
    private DataElement<?> dataElement;
    
    /**
     * @param dataElementTag 
     * 
     */
    public DicomDataElementRecord(DataElementTag dataElementTag, DataElement<?> dataElement)
    {
        this.dataElementTag = dataElementTag;
        this.dataElement = dataElement;
    }

    @Override
    public String getAttribute(String field)
    {
        logger.info("getAttribute(" + field + ")");

        if(ELEMENT_TAG.equals(field))
            return this.dataElementTag.toString();
        else if(ELEMENT_VALUE.equals(field))
            try
            {
                return this.dataElement.getValue().toString();
            } 
            catch (ValueRepresentationInterpretationException e)
            {
                return e.getMessage();
            }
        return "<unknown field name>";
    }
}
