/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 25, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.hdigmanagement.web;

import gov.va.med.imaging.core.router.PeriodicCommandList;
import gov.va.med.imaging.core.router.commands.ProcessAsyncStorageQueueSendEmailCommandImpl;
import gov.va.med.imaging.core.router.commands.ProcessEmailQueueCommandImpl;
import gov.va.med.imaging.core.router.commands.ProcessIconImageCreationQueueCommandImpl;
import gov.va.med.imaging.core.router.commands.dicom.ProcessDicomCorrectCommandImpl;
import gov.va.med.imaging.core.router.periodiccommands.PeriodicCommandEngineAdapter;
import gov.va.med.imaging.dicom.dcftoolkit.startup.DicomEngineAdapter;
import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.facade.configuration.EncryptedConfigurationPropertyString;
import gov.va.med.imaging.facade.configuration.FacadeConfigurationFactory;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author       WERFEJ
 *
 */
public class UpdateServiceAccountCredentialsServlet
extends HttpServlet
{
	private static final long serialVersionUID = -1850976585167762873L;
	private final static Logger logger = LogManager.getLogger(UpdateServiceAccountCredentialsServlet.class);

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		String action = request.getParameter("action");
		if (action.equals("Cancel"))
		{
			response.sendRedirect("..\\ViewHDIGStats.jsp");
		}
		else
		{
			try
			{
				String accessCode = request.getParameter("accessCode");
				String verifyCode = request.getParameter("verifyCode");
				
				// Check the credentials to see if they're valid. If so, update config, restart
				// listeners and kill and restart periodic commands
				if (DicomEngineAdapter.isValidCredentials(accessCode, verifyCode))
				{
					// Update the Access/Verify Codes and save the config file
					DicomServerConfiguration dicomServerConfiguration = DicomServerConfiguration.getConfiguration();
					dicomServerConfiguration.setAccessCode(new EncryptedConfigurationPropertyString(accessCode));
					dicomServerConfiguration.setVerifyCode(new EncryptedConfigurationPropertyString(verifyCode));
					logger.info("Updating DICOMServerConfiguration with new access and verify codes");
					dicomServerConfiguration.storeConfiguration();
					FacadeConfigurationFactory.getConfigurationFactory().clearConfiguration(DicomServerConfiguration.class);
					
					// Start the DICOM services
					DicomEngineAdapter.startDicomServices();
					
					// Kill any existing periodic commands
					PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessDicomCorrectCommandImpl.class);
					PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessIconImageCreationQueueCommandImpl.class);
					PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessAsyncStorageQueueSendEmailCommandImpl.class);
					PeriodicCommandList.get().terminateScheduledPeriodicCommand(ProcessEmailQueueCommandImpl.class);
					
					// Start new periodic commands
					PeriodicCommandEngineAdapter.initializeAndStartPeriodicCommands();

					response.sendRedirect("..\\ViewHDIGStats.jsp");
				}
				else
				{
					response.sendRedirect("updateServiceAccountCredentials.jsp?error=Invalid access/verify codes. Please try again.");
				}
			}
			catch(Exception ex)
			{
				logger.error("Error updating DICOM Server Configuration, " + ex.getMessage(), ex);
				response.sendRedirect("updateServiceAccountCredentials.jsp?error=There was an error restarting DICOM services ( " + ex.getMessage() + "). The Tomcat service on the HDIG should be restarted.");
			}
		}
	}

}
