/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 25, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.hdigmanagement.web;

import gov.va.med.imaging.exchange.business.dicom.DicomServerConfiguration;
import gov.va.med.imaging.facade.configuration.FacadeConfigurationFactory;
import gov.va.med.imaging.notifications.NotificationTypes;
import gov.va.med.imaging.notifications.email.NotificationEmailConfiguration;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author       WERFEJ
 *
 */
public class UpdateAdminEmailServlet
extends HttpServlet
{
	private static final long serialVersionUID = -1850976585167762873L;
	private final static Logger logger = LogManager.getLogger(UpdateAdminEmailServlet.class);

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		String action = request.getParameter("action");
		if (action.equals("Cancel"))
		{
			response.sendRedirect("../ViewHDIGStats.jsp");
		}
		else
		{
			try
			{
				String email = request.getParameter("email");
	
				// Update the email address for the InvalidServiceAccountCredentials notification
				// and save the config file
				NotificationEmailConfiguration notificationEmailConfiguration = NotificationEmailConfiguration.getConfiguration();
				notificationEmailConfiguration.setRecipientsForNotificationType(NotificationTypes.InvalidServiceAccountCredentials, email);
				logger.info("Updating DICOMServerConfiguration with new access and verify codes");
				notificationEmailConfiguration.storeConfiguration();
				FacadeConfigurationFactory.getConfigurationFactory().clearConfiguration(NotificationEmailConfiguration.class);
	
				response.sendRedirect("../ViewHDIGStats.jsp");
			}
			catch(Exception ex)
			{
				logger.error("Error updating DICOM Server Configuration, " + ex.getMessage(), ex);
				response.sendRedirect("updateAdminEmail.jsp?error=Error updating Administrator email address(es).");
			}
		}
	}

}
