/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Mar 4, 2008
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.federation.webservices;

import gov.va.med.PatientIdentifier;
import gov.va.med.exceptions.GlobalArtifactIdentifierFormatException;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.business.Patient;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.federation.FederationRouter;
import gov.va.med.imaging.federation.ImagingFederationContext;
import gov.va.med.imaging.federation.webservices.intf.ImageFederationMetadata;
import gov.va.med.imaging.federation.webservices.translator.FederationWebAppTranslator;
import gov.va.med.imaging.federation.webservices.types.FederationFilterType;
import gov.va.med.imaging.federation.webservices.types.FederationImageAccessLogEventType;
import gov.va.med.imaging.federation.webservices.types.FederationStudyType;
import gov.va.med.imaging.federation.webservices.types.PatientType;
import gov.va.med.imaging.federation.webservices.types.RequestorType;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author       WERFEJ
 *
 */
public class FederationWebservices 
extends AbstractFederationWebservices
implements ImageFederationMetadata 
{
	private final static FederationWebAppTranslator federationTranslator = new FederationWebAppTranslator();
	private final static Logger logger = LogManager.getLogger(FederationWebservices.class);

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.ImageFederationMetadata#getPatientStudyList(gov.va.med.imaging.webservices.types.RequestorType, gov.va.med.imaging.webservices.types.VistaFilterType, java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public FederationStudyType[] getPatientStudyList(RequestorType requestor,
			FederationFilterType filter, String patientId, String transactionId,
			String siteId) 
	throws RemoteException 
	{
		setTransactionId(transactionId);
		Long startTime = System.currentTimeMillis();
		logger.info("start Federation getPatientStudyList transaction(" + transactionId + ")" );
		StudyFilter studyFilter = null;
		try
		{
			studyFilter = federationTranslator.transformFilter(filter);
		}
		catch (GlobalArtifactIdentifierFormatException x)
		{
			getLogger().error(x);
			throw new RemoteException(x.getMessage());
		}
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType("Federation WebApp getPatientStudyList");
		transactionContext.setPatientID(patientId);
		transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(studyFilter.getFromDate(), studyFilter.getToDate()));
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		
		FederationRouter router = ImagingFederationContext.getFederationRouter();
		if(router == null)
			throw new RemoteException("Internal error, unable to retrieve patient studies");
		
		//transactionContext.setRequestingSource(transactionContext.getSiteNumber());
		// JMW 4/8/08 - the transaction context contains the current site details, not details from requestor, that is in the requestor object
		transactionContext.setRequestingSource(requestor.getFacilityId());
		// not sure about this next line... 4/8/08 jmw
		transactionContext.setSiteNumber(requestor.getFacilityId());
		gov.va.med.imaging.federation.webservices.types.FederationStudyType[] result = null;		
		try
		{
			List<Study> studies = router.getPatientStudyList(RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId), 
					PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
			transactionContext.setEntriesReturned( studies == null ? 0 : studies.size() );
			logger.info("Received [" + (studies == null ? "0" : studies.size()) + "] studies from router");			
			result = federationTranslator.transformStudies(studies);
		}
		catch(MethodException mX)
		{
			logger.error("FAILED getPatientStudyList method Exception: " + mX.toString() + " ms", mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", mX);
		}
		/*
		catch(ImagingURNFormatException iurnfX)
		{
			logger.error("FAILED getPatientStudyList transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			throw new RemoteException("Internal error, unable to translate study metadata", iurnfX);
		}
		*/
		catch(ParseException pX)
		{
			logger.error("FAILED getPatientStudyList transaction(" + transactionId, pX );
			transactionContext.setErrorMessage(pX.getMessage());
			transactionContext.setExceptionClassName(pX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", pX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getPatientStudyList with Connection Exception: " + cX.toString(), cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			logger.error("FAILED getPatientStudyList with Connection Exception: " + rtfX.toString(), rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", rtfX);
		}
		
		logger.info("complete Federation getPatientStudyList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms)" );
		return result;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.ImageFederationMetadata#postImageAccessEvent(java.lang.String, gov.va.med.imaging.webservices.types.VistaImageAccessLogEventType)
	 */
	@Override
	public boolean postImageAccessEvent(String transactionId, 
			FederationImageAccessLogEventType logEvent) 
	throws RemoteException 
	{
		setTransactionId(transactionId);
    	long startTime = System.currentTimeMillis();
    	TransactionContext transactionContext = TransactionContextFactory.get();

		FederationRouter router = ImagingFederationContext.getFederationRouter();
		if(router == null)
			throw new RemoteException("Internal error, unable to retrieve patient studies");
		
    	logger.info("start Federation postImageAccessEvent transaction(" + transactionId + ")" );
		logger.info("logEvent image [" + logEvent.getImageId() + "].");
		try
		{
			ImageAccessLogEvent event = federationTranslator.transformLogEvent(logEvent);
			// not sure if this should be here, what if ICN is empty?
			
			transactionContext.setPatientID(event.getPatientIcn());
			transactionContext.setRequestType("Federation WebApp postImageAccessEvent [" + logEvent.getEventType() + "]");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			// need to use the Id from the webservice log event since it is the full URN and not just 
			// the individual image identifier
			transactionContext.setUrn(logEvent.getImageId());
			router.logImageAccessEvent(event);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED postImageAccessEvent method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to post image access", mX);
		}
		catch(ConnectionException cX)
		{
			logger.info("FAILED postImageAccessEvent connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to post image access", cX);
		}
		catch(URNFormatException iurnfX) {
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			logger.info("FAIlED postImageAccessEvent transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		
		logger.info("complete Federation postImageAccessEvent transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return true;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.intf.ImageFederationMetadata#prefetchStudyList(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.webservices.types.VistaFilterType)
	 */
	@Override
	public String prefetchStudyList(String transactionId, String siteId,
			String patientId, FederationFilterType filter) 
	throws RemoteException 
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public String getImageDevFields(String imageUrn, String flags,
			String transactionId) 
	throws RemoteException 
	{
		return getImageDevFieldsInternalHandleExceptions(imageUrn, flags, transactionId);
	}

	@Override
	public String getImageInformation(String imageUrn, String transactionId)
	throws RemoteException 
	{
		return getImageInformationInternalHandleExceptions(imageUrn, transactionId);
	}

	@Override
	public String getImageSystemGlobalNode(String imageUrn, String transactionId)
	throws RemoteException 
	{
		return getImageSystemGlobalNodeInternalHandleExceptions(imageUrn, transactionId);
	}

	@Override
	public String[] getPatientSitesVisited(String patientIcn, String transactionId, 
		String siteId) 
	throws RemoteException 
	{
		return getPatientSitesVisitedInternalHandleExceptions(patientIcn, transactionId, siteId);
	}

	@Override
	public PatientType[] searchPatients(String searchCriteria,
			String transactionId, String siteId) 
	throws RemoteException 
	{
		setTransactionId(transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start Federation searchPatients transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		try{
			transactionContext.setPatientID("n/a");
			transactionContext.setRequestType("Federation WebApp searchPatients");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			FederationRouter router = ImagingFederationContext.getFederationRouter();
			if(router == null)
				throw new RemoteException("Internal error, unable to retrieve patient studies");
			
			List<Patient> patients = router.getPatientList(searchCriteria, RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId) );
			gov.va.med.imaging.federation.webservices.types.PatientType[] response = federationTranslator.transformPatients(patients);
			transactionContext.setEntriesReturned( response == null ? 0 : response.length );
			logger.info("complete Federation searchPatients transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}		
		catch(MethodException mX)
		{
			logger.info("FAILED searchPatients method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study image global node", mX);
		}
		catch(ConnectionException cX)
		{
			logger.info("FAILED searchPatients connection exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", cX);
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image dev fields", cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			logger.info("FAILED searchPatients exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", rtfX);
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image dev fields", rtfX);
		}
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.AbstractFederationWebservices#getWepAppName()
	 */
	@Override
	protected String getWepAppName() 
	{
		return "Federation WebApp V1";
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.federation.webservices.AbstractFederationWebservices#transformSitesToSiteNumberArary(java.util.List)
	 */
	@Override
	protected String[] transformSitesToSiteNumberArray(List<ResolvedArtifactSource> sites) 
	{
		return federationTranslator.transformSitesToSiteNumberArary(sites);
	}
	
}
