package src.validator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
// import java.io.FilenameFilter;

// import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.IOException;
import java.util.ArrayList;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.ValidationResult;

import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.hapi.validation.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseResource;

import com.phloc.commons.*;
import com.phloc.schematron.*;

public class ResourceValidator {
	
//	private final static Logger logger = LogManager.getLogger(ResourceValidator.class);
	private final static String JSON_IN_FOLFER = "C:/temp/jsondir";
//	private final static String JSON_FILE_SPEC = "*.txt";
	private final static String JSON_FILE_EXTENSION = ".txt";

	public static void main(String[] args) {
		System.out.println("Starting FHIR DSTU2 JSON resource validator...");			
		// TODO initialize conext
		FhirContext ctx = FhirContext.forDstu2Hl7Org(); // forDstu2();
		 
		// Create a validator and configure it

		FhirValidator validator = ctx.newValidator();
		validator.setValidateAgainstStandardSchema(true);
		validator.setValidateAgainstStandardSchematron(true);		
		FhirInstanceValidator instanceValidator = new FhirInstanceValidator();
		validator.registerValidatorModule(instanceValidator);
		 
		// Get a list of files in a given directory

		// a. String[] fileList = new File(JSON_IN_FOLFER).list(new FilenameFilter(JSON_FILE_SPEC));
		// b.
		//		File dir = new File(JSON_IN_FOLFER);
		//		String[] textFileList = dir.list(new FilenameFilter() {
		//			@Override
		//			public boolean accept(File dir, String name) {
		//				return name.toLowerCase().endsWith(JSON_FILE_SPEC);
		//			}
		//		});
		// c.
		File folder = new File(JSON_IN_FOLFER);
		File[] dirList = folder.listFiles();
		ArrayList<String> fileList = new ArrayList<String>();
		for (File file : dirList) {
			if (file.isFile()) {
				if (file.toString().toLowerCase().endsWith(JSON_FILE_EXTENSION)) {
					fileList.add(file.toString());
				}
			}
		}
			
		// For each file, load the contents into a string

		// for (String nextFile : textFileList) {
		for (String nextFile : fileList) {

		   System.out.println("\n... reading file '" + nextFile + "'");			
			
//			FileReader fr;
//		   // For each file, load the contents into a string
//		   try {
//			   fr = new FileReader(nextFile);
//			   fr.close();
//		   }
//		   catch (FileNotFoundException fnf) {
//			   System.out.println("\nFile '" + nextFile + "' not found!\n");
//			   continue;
//		   }
//		   catch (IOException fnf) {
//			   System.out.println("\nFile '" + nextFile + "' could not be found or closed!\n");
//			   continue;
//		   }
//		   String nextFileContents = fr.toString();

		   String nextFileContents="";
		   try {
				nextFileContents = IOUtils.toString(new FileReader(nextFile));
		   } 
		   catch (FileNotFoundException fnfe) {
				   System.out.println("\nFile '" + nextFile + "' not found!\n");
				   continue;
		   }
		   catch (IOException e) {
				   System.out.println("\nFile '" + nextFile + "' could not be found or closed!\n");
				   continue;
		   }
		   System.out.println("... Parsing content of '" + nextFile + "' -- " + nextFileContents.length() + " bytes :\n" + nextFileContents);			

		   // Parse that string (this example assumes JSON encoding in read file)
		   
		   IBaseResource resource=null;
		   // LenientErrorHandler lEH = new LenientErrorHandler();
		   // lEH.setErrorOnInvalidValue(false);
		   Boolean parsePassed = false;
		   try {
//			   resource = ctx.newJsonParser().setParserErrorHandler(lEH).parseResource(nextFileContents);
			   resource = ctx.newJsonParser().parseResource(nextFileContents);
			   parsePassed = true;
		   }
		   catch (DataFormatException dfe) {
			   // System.out.println("... DataformatException: ");
			   dfe.printStackTrace();
		   }
		 
		   if (parsePassed)
		   {
			   // Apply the validation. This will throw an exception on the first
			   // validation failure
			   ValidationResult result=null;
			   try {
				   System.out.println("... Validating content of '" + nextFile + "':");			
				   result = validator.validateWithResult(resource);
			   }
			   catch (Exception ex) {
				   System.out.println("\nValidation error on File '" + nextFile + "' -->" + ex.getMessage());
			   }
			   if (!result.isSuccessful()) {
				   System.out.println("... Validating content of '" + nextFile + "' failed: \n" + result.toString());			
			   }
		   }
		   else
			   System.out.println("\n... Validating content of '" + nextFile + "' is skipped.");			
		    
		}
		System.out.println("... stopping FHIR DSTU2 JSON resource validator.");			

	}

}
