/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 30, 2008
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.exchange.webservices;

import gov.va.med.PatientIdentifier;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.InsufficientPatientSensitivityException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ExchangeRouter;
import gov.va.med.imaging.exchange.ImagingExchangeContext;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.webservices.soap.types.v1.FilterType;
import gov.va.med.imaging.exchange.webservices.soap.types.v1.RequestorType;
import gov.va.med.imaging.exchange.webservices.soap.types.v1.StudyType;
import gov.va.med.imaging.exchange.webservices.translator.v1.ExchangeTranslator;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author       WERFEJ
 *
 */
public class ExchangeWebservices 
implements gov.va.med.imaging.exchange.webservices.soap.v1.ImageMetadata
{
	private ExchangeTranslator exchangeTranslator = new ExchangeTranslator();
	private final static Logger logger = LogManager.getLogger(ExchangeWebservices.class);

	@Override
	public StudyType[] getPatientStudyList(String datasource,
			RequestorType requestor, FilterType filter, String patientId,
			String transactionId) 
	throws RemoteException 
	{
		setTransactionContext(requestor, transactionId);
		Long startTime = System.currentTimeMillis();
		logger.info("start getPatientStudyList transaction(" + transactionId + ")");
		ExchangeRouter router = ImagingExchangeContext.getExchangeRouter();
		if(router == null)
			throw new RemoteException("Internal error, unable to retrieve patient studies");
		
		StudyFilter studyFilter = exchangeTranslator.transformFilter(filter);			
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType("Exchange WebApp getStudyList");
		//TODO: look at requesting site number and setRequestingSource 
		transactionContext.setRequestingSource("unknown");		
		transactionContext.setPatientID(patientId);
		transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(studyFilter.getFromDate(), studyFilter.getToDate()));
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		
		//TODO: get the site number from the request (somewhere). if none is specified then get the site 
		// number from appConfig and go against the local site
		String siteNumber = ImagingExchangeContext.getAppConfiguration().getLocalSiteNumber();// "660";				
		try 
		{
			List<Study> studies = router.getPatientStudyList(RoutingTokenHelper.createSiteAppropriateRoutingToken(siteNumber), 
					PatientIdentifier.icnPatientIdentifier(patientId), studyFilter);
		
			gov.va.med.imaging.exchange.webservices.soap.types.v1.StudyType[] studyTypes = 
				exchangeTranslator.transformStudies(studies);
			logger.info("Converted [" + (studies == null ? 0 : studies.size()) + "] business studies into [" + (studyTypes == null ? 0 : studyTypes.length) + "] studies to return");
			transactionContext.setEntriesReturned( studyTypes == null ? 0 : studyTypes.length );
			if (studyTypes != null)
			{
				String dumpExchangeGraphs = System.getenv("dumpvaexchangegraphs");
				if (dumpExchangeGraphs != null && dumpExchangeGraphs.equalsIgnoreCase("true"))
				{
					dumpVaStudyGraph(patientId, studyTypes);
				}
			}
			logger.info("SUCCESS getPatientStudyList transaction(" + transactionId + ") in " + 
					(System.currentTimeMillis() - startTime) + 	" ms)" );
			return studyTypes;
		}
		catch(InsufficientPatientSensitivityException ipsX)
		{
			logger.info("Insufficient patient sensitivity to view specified patient, returning empty study list for now... This is not being logged as an exception", ipsX);
			transactionContext.setEntriesReturned(0);
			logger.info("SUCCESS getPatientStudyList transaction(" + transactionId + ") in " + 
					(System.currentTimeMillis() - startTime) + 	" ms, returned no studies)" );
			return new gov.va.med.imaging.exchange.webservices.soap.types.v1.StudyType[0];
		}
		catch(ParseException pX)
		{
			transactionContext.setErrorMessage(pX.getMessage());
			transactionContext.setExceptionClassName(pX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study procedure date", pX);
		}
		catch(URNFormatException iurnfX)
		{
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", iurnfX);
		}
		catch(MethodException mX)
		{
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", mX);
		}
		catch(ConnectionException cX)
		{
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", rtfX);
		}
	}
	
	/**
	 * Set the transaction context properties that are passed in the webservices.
	 * @param requestor
	 * @param transactionId
	 */
	private void setTransactionContext(
		gov.va.med.imaging.exchange.webservices.soap.types.v1.RequestorType requestor,
		java.lang.String transactionId)
	{
		logger.info(
				"setTransactionContext, id='" + transactionId + 
				"', username='" + requestor == null || requestor.getUsername() == null ? "null" : requestor.getUsername() + 
				"'.");
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		if(transactionId != null)
			transactionContext.setTransactionId(transactionId);
		
		if(requestor != null)
		{
			if( requestor.getUsername() != null )
				transactionContext.setFullName(requestor.getUsername());
			if( requestor.getFacilityId() != null )
				transactionContext.setSiteNumber(requestor.getFacilityId());
			if( requestor.getFacilityName() != null )
				transactionContext.setSiteName(requestor.getFacilityName());
			if( requestor.getPurposeOfUse() != null )
				transactionContext.setPurposeOfUse(requestor.getPurposeOfUse().toString());
			if( requestor.getSsn() != null )
				transactionContext.setSsn(requestor.getSsn());
		}
	}

	private void dumpVaStudyGraph(String patientIcn, gov.va.med.imaging.exchange.webservices.soap.types.v1.StudyType[] exchangeStudies)
	{
		String vixcache = System.getenv("vixcache");
		if (vixcache != null)
		{
			XMLEncoder xmlEncoder = null;
			try
			{
				String fileSpec = vixcache + "/vaexchange" + patientIcn + ".xml";
				xmlEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(fileSpec)));
				xmlEncoder.writeObject(exchangeStudies);
			}
			catch (FileNotFoundException ex)
			{
				logger.error("Error dumping study graph: " + ex.getMessage());
			}
			finally
			{
				if (xmlEncoder != null)
				{
					xmlEncoder.close();
				}
			}
		}
	}
	
}
