package gov.va.med.imaging.dx.rest.proxy;


import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.core.MediaType;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.urlconnection.HTTPSProperties;

/**
 * @author vhaisltjahjb
 *
 */
public abstract class RestTest
{
	private final static Logger logger = LogManager.getLogger(RestTest.class);
	
	public RestTest()
	{
		logger.debug( "Creating Rest Test!");
    }
	
	private static KeyStore createKeyStore(final URL url, final String password) 
			throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException
	{
		if (url == null)
			throw new IllegalArgumentException("Keystore url may not be null");

		KeyStore keystore = KeyStore.getInstance("jks");
		InputStream is = null;
		try
		{
			is = url.openStream();
			keystore.load(is, password != null ? password.toCharArray() : null);
		}
		finally
		{
			if (is != null)
				is.close();
		}
		return keystore;
	}
		    
    private static SSLContext createSSLContext(String keystorefile, String keystorePassword, 
    		String truststorefile, String truststorepwd) 
	{
		try
		{
			URL truststoreUrl = new URL(truststorefile);
			KeyManager[] keymanagers = null;
			logger.debug("keystoreurl=" + keystorefile);
			if (keystorefile != null) 
			{
				URL keystoreUrl = new URL(keystorefile);
				KeyStore keystore = createKeyStore(keystoreUrl, keystorePassword);
				keymanagers = createKeyManagers(keystore, keystorePassword);
			}
			
			KeyStore truststore = createKeyStore(truststoreUrl, truststorepwd);
			TrustManager[] trustmanagers = createTrustManagers(truststore);
			
			SSLContext sslcontext = SSLContext.getInstance("SSL");
			sslcontext.init(keymanagers, trustmanagers, null);
			return sslcontext;
		}
		catch (NoSuchAlgorithmException e)
		{
			StringWriter sw = new StringWriter();
			e.printStackTrace(new PrintWriter(sw));
			logger.debug("Create SSL Context Error: " + sw.toString());
		}
		catch (KeyStoreException e)
		{
			StringWriter sw = new StringWriter();
			e.printStackTrace(new PrintWriter(sw));
			logger.debug("Create SSL Context Error: " + sw.toString());
		}
		catch (GeneralSecurityException e)
		{
			StringWriter sw = new StringWriter();
			e.printStackTrace(new PrintWriter(sw));
			logger.debug("Create SSL Context Error: " + sw.toString());
		}
		catch (IOException e)
		{
			StringWriter sw = new StringWriter();
			e.printStackTrace(new PrintWriter(sw));
			logger.debug("Create SSL Context Error: " + sw.toString());
		}
		
		return null;
	}

    private static KeyManager[] createKeyManagers(final KeyStore keystore, final String password)
    		throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException
	{
		if (keystore == null)
			throw new IllegalArgumentException("Keystore may not be null");

		KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
		kmfactory.init(keystore, password != null ? password.toCharArray() : null);
		return kmfactory.getKeyManagers();
	}

	private static TrustManager[] createTrustManagers(final KeyStore keystore)
			throws KeyStoreException,
		NoSuchAlgorithmException
	{
		if (keystore == null)
			throw new IllegalArgumentException("Keystore may not be null");

		TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
		tmfactory.init(keystore);
		tmfactory.getTrustManagers();
		return tmfactory.getTrustManagers();
	}
	
	protected ClientResponse executeSslRequest(
			MediaType mediaTypex,
			String urlx,
			String truststoreUrl, 
			String truststorePassword,
			String keystoreUrl, 
			String keystorePassword)
	{
		logger.debug( "Https Rest Test!");
        logger.debug( "---- truststorefile:" + truststoreUrl + " pwd: " + truststorePassword);
        logger.debug( "---- keystorefile:" + keystoreUrl + " pwd: " + keystorePassword);
        
		HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        ClientConfig config = new DefaultClientConfig();
        
        SSLContext sslContext = createSSLContext(null, null, truststoreUrl, truststorePassword);
        config.getProperties().put(HTTPSProperties.PROPERTY_HTTPS_PROPERTIES, new HTTPSProperties(hostnameVerifier, sslContext));
		config.getProperties().put(
				ClientConfig.PROPERTY_CONNECT_TIMEOUT, 30000);
		config.getProperties().put(
				ClientConfig.PROPERTY_READ_TIMEOUT, 60000);

		// According to http://jersey.java.net/nonav/apidocs/1.2/contribs/jersey-apache-client/com/sun/jersey/client/apache/ApacheHttpClient.html
		// some properties must be provided in constructor of ApacheHttpClient		
		Client client = ApacheHttpClient.create(config);
		((ApacheHttpClient)client).getClientHandler().getHttpClient().getParams().setConnectionManagerTimeout(60000);
		((ApacheHttpClient)client).getClientHandler().getHttpClient().getHttpConnectionManager().getParams().setDefaultMaxConnectionsPerHost(50);
		((ApacheHttpClient)client).getClientHandler().getHttpClient().getHttpConnectionManager().getParams().setMaxTotalConnections(200);
        
        String url = 
        		"https://das-test.DNS   /des_proxy_adapter/v1/filter/dmix/dataservice/v4.0/mhs/query/123/ICN:1008689409V873033/34794-8?queryStartDate=19000101&queryEndDate=20170609&requestSource=VADAS";
           		//"http://localhost:PORT/csp/samples/docserver/v1/filter/dmix/dataservice/v4.0/mhs/query/DNS  VIDER/:icn/:loinc";
  
		String mediaType = MediaType.APPLICATION_JSON;

        logger.debug( "---- Creating WebResource");
		WebResource webResource = client.resource(url);

		logger.debug( "---- Creating WebResource.Builder request");
		WebResource.Builder request = webResource.accept(mediaType);

		logger.debug( "---- Executing get request for url:" + url + " mediaType: " + mediaType);
		
		try
		{
			ClientResponse res = request.get(ClientResponse.class);
			if (res == null)
			{
				logger.debug("**** DAS response: null");
			}
			else
			{
				logger.debug("**** DAS response: "  + res.getEntity(String.class));
			}
		}
		catch (Exception e)
		{
			StringWriter sw = new StringWriter();
			e.printStackTrace(new PrintWriter(sw));
			logger.debug("Get Request exception: " + sw.toString());
		}
		
        return null;
	}
	
	

}
