package gov.va.med.imaging.dx.rest.proxy;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.transactioncontext.TransactionContextHttpHeaders;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
//import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.urlconnection.HTTPSProperties;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

//import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;

import javax.net.ssl.HostnameVerifier;
//import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
//import com.sun.jersey.api.client.ClientResponse;

/**
* @author vhaisltjahjb
*
*/
               
public class DxBasicAuthRestClient {
    private final static Logger logger = LogManager.getLogger(DxBasicAuthRestClient.class);
    private String basicAuthUrl = null;
    private String alexdelargePassword = null;
    private TransactionContext transactionContext = null;
    
    public DxBasicAuthRestClient(String url, String alexdelargePassword) 
    {
    	this.basicAuthUrl = url;
    	this.alexdelargePassword = alexdelargePassword;
    	transactionContext = TransactionContextFactory.get();
    }

    public String getDataFromServer(String keystoreUrl, String keystorePassword) 
    {
    	String result = null;
	   
	   //HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    	HostnameVerifier hostnameVerifier = new HostnameVerifier() {
		   @Override
		   public boolean verify(String hostname, SSLSession session)
		   {
			   return true;
		   }
    	};
	 	 
    	SSLContext sslContext = createSSLContext(keystoreUrl, keystorePassword, keystoreUrl, keystorePassword);
		logger.debug("DX createSSLContext done.");
	   
    	ClientConfig config = new DefaultClientConfig();
    	 config.getProperties().put(
			   HTTPSProperties.PROPERTY_HTTPS_PROPERTIES, new HTTPSProperties(hostnameVerifier, sslContext));
	     config.getProperties().put(
			   ClientConfig.PROPERTY_CONNECT_TIMEOUT, 30000);
    	 config.getProperties().put(
			   ClientConfig.PROPERTY_READ_TIMEOUT, 60000);

    	Client client = Client.create(config);
		logger.debug("DX Client.reate(config) done.");
      
    	try 
    	{
		    client.addFilter(new HTTPBasicAuthFilter("alexdelarge", alexdelargePassword));

    		WebResource resource = client.resource(basicAuthUrl);
    		logger.debug("DX client resource done.");
		    addTransactionHeaders(resource);

    		result = resource.accept(MediaType.TEXT_PLAIN_TYPE).get(String.class);
    		logger.debug("DX got result:" + result);
    	} 
    	catch (Exception e) {
    		logger.debug("DX getDataFromServer exception: " + e.getMessage());
    	  
    	}
    	finally 
    	{
    		client.destroy();
    	}
	   
    	return result;

    }

    private static SSLContext createSSLContext(
    		String keystorefile, String keystorePassword, 
       		String truststorefile, String truststorepwd) 
   	{
		logger.debug("keystoreurl=" + keystorefile);

		try
   		{
   			KeyManager[] keymanagers = null;
   			if (keystorefile != null) 
   			{
   				URL keystoreUrl = new URL(keystorefile);
   				KeyStore keystore = createKeyStore(keystoreUrl, keystorePassword);
   				keymanagers = createKeyManagers(keystore, keystorePassword);
   			}
   			
   			TrustManager[] trustmanagers = null;
   			if (truststorefile != null) 
   			{
   				URL truststoreUrl = new URL(truststorefile);
   				KeyStore truststore = createKeyStore(truststoreUrl, truststorepwd);
   				trustmanagers = createTrustManagers(truststore);
   			}
   			
   			SSLContext sslcontext = SSLContext.getInstance("SSL");
   			sslcontext.init(keymanagers, trustmanagers, null);
   			return sslcontext;
   		}
   		catch (NoSuchAlgorithmException e)
   		{
   			StringWriter sw = new StringWriter();
   			e.printStackTrace(new PrintWriter(sw));
   			logger.debug("Create SSL Context Error: " + sw.toString());
   		}
   		catch (KeyStoreException e)
   		{
   			StringWriter sw = new StringWriter();
   			e.printStackTrace(new PrintWriter(sw));
   			logger.debug("Create SSL Context Error: " + sw.toString());
   		}
   		catch (GeneralSecurityException e)
   		{
   			StringWriter sw = new StringWriter();
   			e.printStackTrace(new PrintWriter(sw));
   			logger.debug("Create SSL Context Error: " + sw.toString());
   		}
   		catch (IOException e)
   		{
   			StringWriter sw = new StringWriter();
   			e.printStackTrace(new PrintWriter(sw));
   			logger.debug("Create SSL Context Error: " + sw.toString());
   		}
   		
   		return null;
   	}

   	
    private static KeyStore createKeyStore(final URL url, final String password) 
   	throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException
   	{
   		if (url == null)
   			throw new IllegalArgumentException("Keystore url may not be null");

   		KeyStore keystore = KeyStore.getInstance("jks");
   		InputStream is = null;
   		try
   		{
   			is = url.openStream();
   			keystore.load(is, password != null ? password.toCharArray() : null);
   		}
   		finally
   		{
   			if (is != null)
   				is.close();
   		}
   		return keystore;
   	}
   		    
    private static KeyManager[] createKeyManagers(final KeyStore keystore, final String password)
       		throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException
   	{
   		if (keystore == null)
   			throw new IllegalArgumentException("Keystore may not be null");

   		KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
   		kmfactory.init(keystore, password != null ? password.toCharArray() : null);
   		return kmfactory.getKeyManagers();
   	}

   	private static TrustManager[] createTrustManagers(final KeyStore keystore)
   	throws KeyStoreException, NoSuchAlgorithmException
   	{
   		if (keystore == null)
   			throw new IllegalArgumentException("Keystore may not be null");

   		TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
   		tmfactory.init(keystore);
   		tmfactory.getTrustManagers();
   		return tmfactory.getTrustManagers();
   	}

   	private void addTransactionHeaders(WebResource request)
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		String duz = transactionContext.getDuz();
		if(duz != null && duz.length() > 0)
			   request.header( TransactionContextHttpHeaders.httpHeaderDuz, duz);
		
		String fullname = transactionContext.getFullName();
		if(fullname != null && fullname.length() > 0)
			   request.header( TransactionContextHttpHeaders.httpHeaderFullName, fullname);
		
		String sitename = transactionContext.getSiteName();
		if(sitename != null && sitename.length() > 0)
			   request.header( TransactionContextHttpHeaders.httpHeaderSiteName, sitename);
		
		String sitenumber = transactionContext.getSiteNumber();
		if(sitenumber != null && sitenumber.length() > 0)
			   request.header( TransactionContextHttpHeaders.httpHeaderSiteNumber, sitenumber);
		
		String ssn = transactionContext.getSsn();
		if(ssn != null && ssn.length() > 0)
			   request.header( TransactionContextHttpHeaders.httpHeaderSSN, ssn);
		
		String securityToken = transactionContext.getBrokerSecurityToken();
		if(securityToken != null && securityToken.length() > 0)
			   request.header(TransactionContextHttpHeaders.httpHeaderBrokerSecurityTokenId, securityToken);
		
		String cacheLocationId = transactionContext.getCacheLocationId();
		if(cacheLocationId != null && cacheLocationId.length() > 0)
			   request.header(TransactionContextHttpHeaders.httpHeaderCacheLocationId, cacheLocationId);
		
		String userDivision = transactionContext.getUserDivision();
		if(userDivision != null && userDivision.length() > 0)
			   request.header(TransactionContextHttpHeaders.httpHeaderUserDivision, userDivision);     
		
		String transactionId = transactionContext.getTransactionId();
		if(transactionId != null && transactionId.length() > 0)
			   request.header(TransactionContextHttpHeaders.httpHeaderTransactionId, transactionId);
		
		String requestingVixSiteNumber = transactionContext.getVixSiteNumber();
		if(requestingVixSiteNumber != null && requestingVixSiteNumber.length() > 0)
			   request.header(TransactionContextHttpHeaders.httpHeaderRequestingVixSiteNumber, requestingVixSiteNumber);
		
		String imagingSecurityContextType = transactionContext.getImagingSecurityContextType();
		if(imagingSecurityContextType != null && imagingSecurityContextType.length() > 0)
			   request.header(TransactionContextHttpHeaders.httpHeaderOptionContext, imagingSecurityContextType);
		
		debugHeaders();
	}
	
	private void debugHeaders()
	{
		String duz = transactionContext.getDuz();
		if(duz != null && duz.length() > 0)
		    logger.debug("Header Duz: " + duz);
		
		String fullname = transactionContext.getFullName();
		if(fullname != null && fullname.length() > 0)
		logger.debug("Header fullname: " + fullname);
		       
		String sitename = transactionContext.getSiteName();
		if(sitename != null && sitename.length() > 0)
		logger.debug("Header sitename: " + sitename);
		       
		String sitenumber = transactionContext.getSiteNumber();
		if(sitenumber != null && sitenumber.length() > 0)
		logger.debug("Header sitenumber: " + sitenumber);
		       
		String ssn = transactionContext.getSsn();
		if(ssn != null && ssn.length() > 0)
		logger.debug("Header ssn: " + ssn);
		       
		String securityToken = transactionContext.getBrokerSecurityToken();
		if(securityToken != null && securityToken.length() > 0)
		logger.debug("Header securityToken: " + securityToken);
		       
		String cacheLocationId = transactionContext.getCacheLocationId();
		if(cacheLocationId != null && cacheLocationId.length() > 0)
		logger.debug("Header cacheLocationId: " + cacheLocationId);
		       
		String userDivision = transactionContext.getUserDivision();
		if(userDivision != null && userDivision.length() > 0)
		logger.debug("Header userDivision: " + userDivision);
		       
		String transactionId = transactionContext.getTransactionId();
		if(transactionId != null && transactionId.length() > 0)
		logger.debug("Header transactionId: " + transactionId);
		       
		String requestingVixSiteNumber = transactionContext.getVixSiteNumber();
		if(requestingVixSiteNumber != null && requestingVixSiteNumber.length() > 0)
		logger.debug("Header requestingVixSiteNumber: " + requestingVixSiteNumber);
		       
		String imagingSecurityContextType = transactionContext.getImagingSecurityContextType();
		if(imagingSecurityContextType != null && imagingSecurityContextType.length() > 0)
		logger.debug("Header imagingSecurityContextType: " + imagingSecurityContextType);
		
	}

	// java.exe 
	// 	-Dlog4j.configuration=file:/C:/VixConfig/log4j.properties 
	// 	-cp ./*;DxDataSourceProvider-0.1.jar 
	// 	gov.va.med.imaging.dx.rest.proxy.DxBasicAuthRestClient <params>
//	public static void main(String[] argv)
//	{
//		String keystoreUrl = "file:///C:/VixCertStore/cvix.jks";
//		String keystorePassword = "REDACTED";
//		String url = "https://IP           /MIXWebApp/restservices/mix/DasCachedDocumentId?repoId=central&docId=h0103d64813f486400db75d39430b805f110111-IP           ";
//		
//		DxBasicAuthRestClient basicClient = new DxBasicAuthRestClient(url); 
//		String result = basicClient.getDataFromServer(keystoreUrl, keystorePassword);
//		System.out.println(result);
//	}	
	
}

