/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 11, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author vhaiswbeckec
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (301) 734-0100.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicom.dataelement;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.logging.log4j.Level;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataElementFactory;
import gov.va.med.imaging.dicom.DataElementTag;
import gov.va.med.imaging.dicom.ValueRepresentation;
import gov.va.med.imaging.dicom.dictionary.DicomDictionaryEntry;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_IS;
import gov.va.med.imaging.dicom.exceptions.DicomFormatException_UI;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

/**
 * A character string containing a UID that is used to uniquely identify a wide variety of items. 
 * The UID is a series of numeric components separated by the period '.' character. 
 * If a Value Field containing one or more UIDs is an odd number of bytes in length, 
 * the Value Field shall be padded with a single trailing NULL (00H) character to 
 * ensure that the Value Field is an even number of bytes in length. 
 * See Section 9 and Annex B
 * 
 * @author vhaiswbeckec
 *
 */
public class DataElement_UI 
extends DataElement<String>
{
	private String value;
	private static Pattern uidPattern = Pattern.compile("([\\d]+)(\\x2e[\\d]+)*");
	
	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param explicitVRField
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException
	 */
	public DataElement_UI(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, ValueRepresentation explicitVRField,
	        long valueLength, byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, explicitVRField, valueLength, value);
	}

	/**
	 * @param instantiatingFactory
	 * @param dataElementTag
	 * @param dictionaryEntry
	 * @param valueLength
	 * @param value
	 * @throws DicomFormatException
	 */
	public DataElement_UI(DataElementFactory instantiatingFactory, DataElementTag dataElementTag, DicomDictionaryEntry dictionaryEntry,
	        long valueLength, byte[] value) 
	throws DicomFormatException
	{
		super(instantiatingFactory, dataElementTag, dictionaryEntry, valueLength, value);
	}

	/**
	 * @see gov.va.med.imaging.dicom.DataElement#getValue()
	 */
	@Override
	public String getValue() 
	throws ValueRepresentationInterpretationException
	{
		return value;
	}

	/**
	 * @see gov.va.med.imaging.dicom.DataElement#parseRawValue()
	 */
	@Override
	protected void parseRawValue() 
	throws DicomFormatException
	{
		value = new String(getRawValue());
		value = value.trim();
		Matcher matcher = DataElement_UI.uidPattern.matcher(value);
		if( ! matcher.matches() )
		{
			getLogger().log(Level.WARN, "UID '" + value + "' is not in the correct form.");
			throw new DicomFormatException_UI(value);
		}
	}

}
