/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: August 24, 2006
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        PETRB
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+
 */
package gov.va.med.imaging.exchange.business;

import junit.framework.TestCase;

import java.nio.charset.Charset;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

/**
 *
 * @author William Peterson
 *
 */
public class DicomCommonTestBase extends TestCase {
    
    public static Logger TESTLOGGER = null; //LogManager.getLogger("JUNIT_TEST");
    public static Logger logger = null; //LogManager.getLogger(DicomCommonTestBase.class);
    public static ConsoleAppender appender;


    /*
     * @see TestCase#setUp()
     */
    @SuppressWarnings("deprecation")
    protected void setUp() throws Exception {
        super.setUp();
//        appender = new ConsoleAppender(new PatternLayout());
//        TESTLOGGER.addAppender(appender);
//        TESTLOGGER.setLevel(Level.INFO);
//        logger.addAppender(appender);
//        logger.setLevel(Level.ERROR);
        
        
        LoggerContext context= (LoggerContext) LogManager.getContext();
        Configuration config= context.getConfiguration();
		
		PatternLayout layout = PatternLayout.createLayout(
				"%d{DATE} %5p [%t] (%F:%L) - %m%n", 
				null, 
				null, 
				null, 
				Charset.defaultCharset(), 
				false,
				false,
				null,
				null);

        appender=ConsoleAppender.createAppender(layout, null, null, "CONSOLE_APPENDER", null, null);
	    appender.start();
	    
	    AppenderRef ref= AppenderRef.createAppenderRef("CONSOLE_APPENDER",null,null);
        AppenderRef[] refs = new AppenderRef[] {ref};
        LoggerConfig loggerConfig= LoggerConfig.createLogger(
        		"false", Level.INFO,"CONSOLE_LOGGER","true",
        		refs,null,config,null);
        loggerConfig.addAppender(appender,null,null);
		
		config.addAppender(appender);
        config.addLogger("DicomCommonTestBase", loggerConfig);
        context.updateLoggers(config);

        logger=LogManager.getContext().getLogger("DicomCommonTestBase");
        Configurator.setLevel("DicomCommonTestBase", Level.ERROR);

		config.addAppender(appender);
        config.addLogger("JUNIT_TEST", loggerConfig);
        context.updateLoggers(config);

        TESTLOGGER=LogManager.getContext().getLogger("JUNIT_TEST");
        Configurator.setLevel("JUNIT_TEST", Level.INFO);
        
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
        //TESTLOGGER.removeAllAppenders();
        LogManager.shutdown();

    }

    /**
     * Constructor for DicomCommonTestBase.
     * @param arg0
     */
    public DicomCommonTestBase(String arg0) {
        super(arg0);
    }

}
