/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 8, 2008
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.clinicaldisplay.webservices.translator;

import gov.va.med.GlobalArtifactIdentifier;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.imaging.*;
import gov.va.med.imaging.clinicaldisplay.configuration.ClinicalDisplayWebAppConfiguration;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.ImageAccessLogEvent.ImageAccessLogEventType;
import gov.va.med.imaging.exchange.business.ArtifactResults;
import gov.va.med.imaging.exchange.business.Image;
import gov.va.med.imaging.exchange.business.Series;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import gov.va.med.imaging.exchange.enums.SiteConnectivityStatus;
import gov.va.med.imaging.exchange.enums.VistaImageType;
import gov.va.med.imaging.webservices.clinical.ClinicalContentTypeConfig;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author       WERFEJ
 *
 */
public class ClinicalDisplayTranslator3 
{
private final static Logger logger = LogManager.getLogger(ClinicalDisplayTranslator2.class);
	
	private final static String clinicalDisplayWebserviceShortDateFormat = "MM/dd/yyyy";
	private final static String clinicalDisplayWebserviceLongDateFormat = "MM/dd/yyyy HH:mm";
	
	public ClinicalDisplayTranslator3()
	{
		super();
	}
	
	// be careful about re-using SimpleDateFormat instances because they are not thread-safe 
	private DateFormat getClinicalDisplayWebserviceShortDateFormat()
	{
		return new SimpleDateFormat(clinicalDisplayWebserviceShortDateFormat);
	}
	
	private DateFormat getClinicalDisplayWebserviceLongDateFormat()
	{
		return new SimpleDateFormat(clinicalDisplayWebserviceLongDateFormat);
	}
	
	/**
	 * Transform a clinical display webservice FilterType to an internal Filter instance.
	 * 
	 */
	public StudyFilter transformFilter(gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FilterType filterType) 
	{
		StudyFilter filter = new StudyFilter();
		
		if(filterType != null) 
		{
			DateFormat df = getClinicalDisplayWebserviceShortDateFormat();
			
			Date fromDate = null;
			try
			{
				fromDate = filterType.getFromDate() == null  || filterType.getFromDate().length() == 0 ? null : df.parse(filterType.getFromDate());
			} 
			catch (ParseException x)
			{
				logger.error("ParseException converting webservice format string from-date '" +  filterType.getFromDate() + "' to internal Date", x);
				fromDate = null;
			}
			
			Date toDate = null;
			try
			{
				toDate = filterType.getToDate() == null || filterType.getToDate().length() == 0 ? null : df.parse(filterType.getToDate());
			} 
			catch (ParseException x)
			{
				logger.error("ParseException converting webservice format string to-date '" +  filterType.getToDate() + "' to internal Date", x);
				fromDate = null;
			}
			
			// some business rules for the filter dates
			if (fromDate != null && toDate == null)
			{
				// default toDate to today
				toDate = new Date();
			}
			else if (fromDate == null && toDate != null)
			{
				// default to unfiltered
				toDate = null;
			}
			
			filter.setFromDate(fromDate);
			filter.setToDate(toDate);
			
			filter.setStudy_class(filterType.get_class() == null ? "" : filterType.get_class());
			filter.setStudy_event(filterType.getEvent() == null ? "" : filterType.getEvent());
			filter.setStudy_package(filterType.get_package() == null ? "" : filterType.get_package());
			filter.setStudy_specialty(filterType.getSpecialty() == null ? "" : filterType.getSpecialty());
			filter.setStudy_type(filterType.getTypes() == null ? "" : filterType.getTypes());
			
			if(filterType.getOrigin() == null) {
				filter.setOrigin("");
			}
			else {
				if("UNSPECIFIED".equals(filterType.getOrigin().getValue())) {
					filter.setOrigin("");
				}
				else {
					filter.setOrigin(filterType.getOrigin().getValue());
				}
			}
			// don't have a study id used here
		}
		return filter;
	}
	
	public gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType[] transformStudiesToShallowStudies(
			ArtifactResults artifactResults)
	throws URNFormatException
	{
		if(artifactResults == null)
			return null;
		if(artifactResults.getStudySetResult() == null)
			return null;
		return transformStudiesToShallowStudies(artifactResults.getStudySetResult().getArtifacts());
		
	}
	
	private gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType[] transformStudiesToShallowStudies(
		Collection<Study> studyList) 
	throws URNFormatException 
	{
		if(studyList == null || studyList.size() == 0)
			return null;
		
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType [] res = 
			new gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType[studyList.size()];
		
		int index=0;
		for(Iterator<Study> studiesIter = studyList.iterator(); studiesIter.hasNext(); ++index)
			res[index] = transformStudyToShallowStudy(studiesIter.next());
		
		return res;
	}
	
	public gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType transformStudyToShallowStudy(Study study) 
	throws URNFormatException 
	{
		if(study == null)
			return null;
		
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType result = 
			new gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType();
		
		result.setDescription(extractIllegalCharacters(study.getDescription()));
		//result.setDicomImageNumber(study.get);
		//result.setDicomSequenceNumber(study.getst)
		result.setEvent(extractIllegalCharacters(study.getEvent()));
		result.setImageCount(BigInteger.valueOf(study.getImageCount()));
		result.setImagePackage(extractIllegalCharacters(study.getImagePackage()));
		result.setImageType(study.getImageType());
		result.setNoteTitle(extractIllegalCharacters(study.getNoteTitle()));
		result.setOrigin(extractIllegalCharacters(study.getOrigin()));
		result.setPatientIcn(study.getPatientId());
		result.setPatientName(study.getPatientName());
		result.setProcedure(extractIllegalCharacters(study.getProcedure()));
		result.setRadiologyReport(study.getRadiologyReport());
		result.setSiteNumber(study.getSiteNumber());
		result.setSpecialty(extractIllegalCharacters(study.getSpecialty()));
		
		// 2/19/08 - now include the site name so the Display client shows what specific DOD facility the study is from
		if(ExchangeUtil.isSiteDOD(study.getSiteNumber()))
		{
			result.setSiteAbbreviation(study.getSiteAbbr()+ (study.getSiteName() != null ? "-" + study.getSiteName() : ""));			
		}
		else
		{
			result.setSiteAbbreviation(study.getSiteAbbr());
		}				
		result.setStudyPackage(extractIllegalCharacters(study.getImagePackage()));
		result.setStudyClass(extractIllegalCharacters(study.getStudyClass() == null ? "" : study.getStudyClass())); // get this from study
		result.setStudyType(extractIllegalCharacters(study.getImageType()));
		result.setCaptureDate(study.getCaptureDate());
		result.setCapturedBy(study.getCaptureBy());		
		if(study.getProcedureDate() == null)
		{
			logger.warn("Setting null procedure date for study");
			result.setProcedureDate("");
		}
		else
		{
			if((study.getProcedureDateString() == null) || (study.getProcedureDateString().length() <= 0))
			{
				// if the hour and minute are not 0, then likely they contain real values for hour and minute (not 00:00)
				// this leaves open the possibility of invalid data, if the real date was at 00:00 then this would not show that time.
				// we would then omit data, not show invalid data
				if((study.getProcedureDate().getHours() <= 0) && (study.getProcedureDate().getMinutes() <= 0))
				{
					result.setProcedureDate(getClinicalDisplayWebserviceShortDateFormat().format(study.getProcedureDate()));
				}
				else
				{
					result.setProcedureDate(getClinicalDisplayWebserviceLongDateFormat().format(study.getProcedureDate()));
				}
				
			}
			else if(study.getProcedureDateString().length() > 10)
			{
				result.setProcedureDate(getClinicalDisplayWebserviceLongDateFormat().format(study.getProcedureDate()));
			}
			else {
				result.setProcedureDate(getClinicalDisplayWebserviceShortDateFormat().format(study.getProcedureDate()));
			}
		}
		result.setRpcResponseMsg(study.getRpcResponseMsg());
		// JMW - need to find series for first image, ugly but necessary
		Series firstSeries = null;
		for(Series series : study.getSeries())
		{
			for(Image image : series)
			{
				if(image.equals(study.getFirstImage()))
				{
					firstSeries = series;
					break;
				}						
			}
			if(firstSeries != null)
			{
				break;
			}			 
		}
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType firstImage = 
			transformImageToFatImage(study.getFirstImage(), firstSeries);
		
		result.setFirstImage(firstImage);
		
		// need to add site number field
		
		GlobalArtifactIdentifier imageIdentifier = study.getGlobalArtifactIdentifier();
		if(imageIdentifier instanceof BhieStudyURN)
			result.setStudyId( ((BhieStudyURN)imageIdentifier).toStringCDTP() );
		else
			result.setStudyId( imageIdentifier.toString() );
		
		return result;
	}
	
	/*
	public gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType[] transformImagesToFatImages(List<Image> images) 
	throws ImagingURNFormatException 
	{
		if(images == null)
			return null;
		
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType[] result = 
			new gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType[images.size()];
		
		int index=0;
		for(Iterator<Image> imagesIter = images.iterator(); imagesIter.hasNext(); ++index)
			result[index] = transformImageToFatImage(imagesIter.next());
		
		return result;
	}
	*/
	
	public gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType[] transformStudyToFatImages(
		Study study) 
	throws URNFormatException 
	{
		if(study == null)
			return null;
		if(study.getSeries() == null)
			return null;
		
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType[] result = 
			new gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType[study.getImageCount()];
		
		int index=0;
		//for(Iterator<Image> imagesIter = images.iterator(); imagesIter.hasNext(); ++index)
		//	result[index] = transformImageToFatImage(imagesIter.next());
		
		for(Series series : study.getSeries())
		{
			if(series != null)
			{
				for(Image image : series)
				{
					result[index] = transformImageToFatImage(image, series);
					index++;
				}
			}
				 
		}
		return result;
	}

	public gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType transformImageToFatImage(
		Image image, Series series) 
	throws URNFormatException 
	{
		if(image == null)
			return null;
		
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType result = 
			new gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType();
		
		result.setDescription(extractIllegalCharacters(image.getDescription()));
		//result.setDicomImageNumber(image.getDicomImageNumberForDisplay());
		result.setDicomImageNumber((image.getImageNumber() != null) && (image.getImageNumber().length() > 0) ? image.getImageNumber() : image.getDicomImageNumberForDisplay());
		//result.setDicomSequenceNumber(image.getDicomSequenceNumberForDisplay());
		result.setDicomSequenceNumber((series != null) && (series.getSeriesNumber() != null) && (series.getSeriesNumber().length() > 0) ? series.getSeriesNumber() : image.getDicomSequenceNumberForDisplay());
		//result.setDicomSequenceNumber(image.get)
		result.setPatientIcn(image.getPatientId());
		result.setPatientName(image.getPatientName());
		result.setProcedure(extractIllegalCharacters(image.getProcedure()));
		if(image.getProcedureDate() == null)
		{
			logger.warn("Setting null procedure date for image");
			result.setProcedureDate("");
		}
		else 
		{
			// if the hour and minute are not 0, then likely they contain real values for hour and minute (not 00:00)
			// this leaves open the possibility of invalid data, if the real date was at 00:00 then this would not show that time.
			// we would then omit data, not show invalid data
			if((image.getProcedureDate().getHours() <= 0) && (image.getProcedureDate().getMinutes() <= 0))
			{
				result.setProcedureDate(getClinicalDisplayWebserviceShortDateFormat().format(image.getProcedureDate()));
			}
			else
			{
				result.setProcedureDate(getClinicalDisplayWebserviceLongDateFormat().format(image.getProcedureDate()));
			}
		}
		result.setSiteNumber(image.getSiteNumber());
		result.setSiteAbbr(image.getSiteAbbr());
		result.setImageClass(extractIllegalCharacters(image.getImageClass()));
		result.setAbsLocation(image.getAbsLocation());
		result.setFullLocation(image.getFullLocation());
		
		result.setQaMessage(image.getQaMessage());
		result.setImageType(BigInteger.valueOf(image.getImgType()));

		GlobalArtifactIdentifier imageIdentifier = image.getGlobalArtifactIdentifier();
		if(imageIdentifier instanceof BhieImageURN)
			result.setImageId( ((BhieImageURN)imageIdentifier).toStringCDTP() );
		else
			result.setImageId( imageIdentifier.toString() );
		
		boolean isRadImage = isRadImage(image);
		if((image.getFullFilename() != null) && (image.getFullFilename().startsWith("-1")))
		{
			result.setFullImageURI(image.getFullFilename()); // put in error state
		}
		else
		{
			// if the image is not radiology, then this is a ref image request, if not rad image
			// then ref location is for the diagnostic image.
			int imageQuality = (isRadImage ? ImageQuality.REFERENCE.getCanonical() : ImageQuality.DIAGNOSTICUNCOMPRESSED.getCanonical());
			result.setFullImageURI("imageURN=" + result.getImageId() + "&imageQuality=" + imageQuality + "&contentType=" + getContentType(image, ImageQuality.REFERENCE));
		}
		if((image.getAbsFilename() != null) && (image.getAbsFilename().startsWith("-1")))
		{
			result.setAbsImageURI(image.getAbsFilename());
		}
		else
		{
			//result.setAbsImageURI("imageURN=" + imageUrn.toString() + "&imageQuality=20&contentType=*/*");
			result.setAbsImageURI("imageURN=" + result.getImageId() + "&imageQuality=20&contentType=" + getContentType(image, ImageQuality.THUMBNAIL));
		}
		
		if(isRadImage)
		{
			if((image.getBigFilename() != null) && (image.getBigFilename().startsWith("-1")))
			{
				result.setBigImageURI(image.getBigFilename());
			}
			else
			{
				result.setBigImageURI("imageURN=" + result.getImageId() + "&imageQuality=90&contentType=" + getContentType(image, ImageQuality.DIAGNOSTIC));
			}
		}
		else
		{
			result.setBigImageURI("");
		}
		return result;
	}
	
	private boolean isRadImage(Image image)
	{
		if(image == null)
			return false;
		int imgType = image.getImgType();
		if((imgType == VistaImageType.DICOM.getImageType()) || 
				(imgType == VistaImageType.XRAY.getImageType()))
		{
			return true;
		}
		return false;
	}
	
	private ClinicalContentTypeConfig getContentTypeConfig(int imageType, ImageQuality imageQuality)
	{
		VistaImageType vistaImageType = getVistaImageType(imageType);
		if(vistaImageType == null)
		{
			return null;			
		}
		return getClinicalDisplayConfiguration().getContentTypeConfiguration(vistaImageType, 
				imageQuality);
	}
	
	
	private ClinicalDisplayWebAppConfiguration getClinicalDisplayConfiguration()
	{
		return ClinicalDisplayWebAppConfiguration.getConfiguration();
	}
	
	private VistaImageType getVistaImageType(int imageType)
	{
		return VistaImageType.valueOfImageType(imageType);
	}
	
	private String getContentType(Image image, ImageQuality imageQuality)
	{
		String contentType = "";
		
		ClinicalContentTypeConfig config = getContentTypeConfig(image.getImgType(), imageQuality);
		if(config != null)
			contentType = config.getContentType();
		
		if(contentType.length() > 0)
		{
			contentType += ",*/*";
		}
		else
		{
			contentType = "*/*";
		}
		return contentType;
	}
	
	public ImageAccessLogEvent transformLogEvent(gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageAccessLogEventType logEventType) 
	throws URNFormatException 
	{
		if(logEventType == null)
			return null;
		
		AbstractImagingURN urn = URNFactory.create(logEventType.getId(), 
				SERIALIZATION_FORMAT.CDTP, AbstractImagingURN.class);
		
		boolean isDodImage = ExchangeUtil.isSiteDOD(urn.getOriginatingSiteId());		
		
		ImageAccessLogEventType imageAccessLogEventType = transformLogEventType(logEventType.getEventType());
		ImageAccessLogEvent result = 			
			new ImageAccessLogEvent(urn.getImagingIdentifier(), "", logEventType.getPatientIcn(), 
					urn.getOriginatingSiteId(), System.currentTimeMillis(), 
				logEventType.getReason(), "", imageAccessLogEventType, isDodImage, 
				logEventType.getCredentials().getSiteNumber());		
		return result;
	}	

	public ImageAccessLogEventType transformLogEventType(gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageAccessLogEventTypeEventType eventType) {
		ImageAccessLogEventType result;// = new gov.va.med.imaging.exchange.enums.ImageAccessLogEventType();
		if(eventType == gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageAccessLogEventTypeEventType.IMAGE_COPY) {
			result = ImageAccessLogEventType.IMAGE_COPY;
		}
		else if(eventType == gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageAccessLogEventTypeEventType.PATIENT_ID_MISMATCH)
		{
			result = ImageAccessLogEventType.PATIENT_ID_MISMATCH;
		}
		else if(eventType == gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageAccessLogEventTypeEventType.IMAGE_ACCESS)
		{
			result = ImageAccessLogEventType.IMAGE_ACCESS;
		}
		else {
			result = ImageAccessLogEventType.IMAGE_PRINT;
		}
		return result;
	}
	
	public gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.PingServerTypePingResponse transformServerStatusToPingServerResponse(SiteConnectivityStatus siteStatus)
	{
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.PingServerTypePingResponse response = null;
		if(siteStatus == SiteConnectivityStatus.VIX_READY)
		{
			response = gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.PingServerTypePingResponse.SERVER_READY;
		}
		else if(siteStatus == SiteConnectivityStatus.DATASOURCE_UNAVAILABLE)
		{
			response = gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.PingServerTypePingResponse.VISTA_UNAVAILABLE;
		}
		else 
		{
			response = gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.PingServerTypePingResponse.SERVER_UNAVAILABLE;
		}
		
		return response;
	}
	
	/**
	 * Certain characters cannot be given to the Clinical Display client because they will cause exceptions
	 * in the parsing, they must be removed to ensure proper display of metadata. This function removes those
	 * characters and replaces them with a space
	 * @param input Input string to check
	 * @return
	 */
	private String extractIllegalCharacters(String input)
	{
		if(input == null)
			return "";
		return input.replaceAll("\\^", " ");	
	}
}
