/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 8, 2008
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.clinicaldisplay.webservices;

import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.clinicaldisplay.ClinicalDisplayRouter;
import gov.va.med.imaging.clinicaldisplay.ImagingClinicalDisplayContext;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FilterType;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageAccessLogEventType;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageClinicalDisplayMetadata;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.PingServerTypePingResponse;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.PrefetchResponseTypePrefetchResponse;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType;
import gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.UserCredentials;
import gov.va.med.imaging.clinicaldisplay.webservices.translator.ClinicalDisplayTranslator3;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.ImageNotFoundException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.business.ArtifactResults;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudyFilter;
import gov.va.med.imaging.exchange.business.Requestor.PurposeOfUse;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;
import gov.va.med.imaging.exchange.enums.SiteConnectivityStatus;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.rmi.RemoteException;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author       WERFEJ
 *
 */
public class ClinicalDisplayWebservices_v3 
extends AbstractClinicalDisplayWebservices
implements ImageClinicalDisplayMetadata
{
	
	private final static Logger logger = LogManager.getLogger(ClinicalDisplayWebservices_v3.class);
	private final static ClinicalDisplayTranslator3 interpreter = new ClinicalDisplayTranslator3();

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageClinicalDisplayMetadata#getPatientShallowStudyList(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FilterType, gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.UserCredentials)
	 */
	@Override
	public ShallowStudyType[] getPatientShallowStudyList(String transactionId,
			String siteId, String patientId, FilterType filter,
			UserCredentials credentials) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		Long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getPatientShallowStudyList transaction(" + transactionId + ")" );
		TransactionContext transactionContext = TransactionContextFactory.get();
		StudyFilter internalFilter = interpreter.transformFilter(filter);
		// initialize the transaction context
		//TODO: set Request type generically
		transactionContext.setRequestType(getWepAppName() + " getPatientShallowStudyList");
		transactionContext.setPatientID(patientId);
		transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(internalFilter.getFromDate(), internalFilter.getToDate()));
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		if(ExchangeUtil.isSiteDOD(credentials.getSiteNumber()))
		{
			transactionContext.setRequestingSource("DOD");
		}
		else
		{
			transactionContext.setRequestingSource("VA");
		}
		
		// get the message context first
        //MessageContext msgContext = MessageContext.getCurrentContext();
        //HttpServletRequest request = (HttpServletRequest) msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
       		
		logger.debug("getPatientShallowStudyList transforming filter into business object.");
		
		ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
		//Router router = ImagingClinicalDisplayContext.getVixRouter();

		logger.debug("getPatientShallowStudyList getting patient studies list from " + rtr.getClass().getName() + 
				" type manager instance.");
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ShallowStudyType[] result = null;
		
		try 	
		{				
			RoutingToken routingToken = RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId);
			logger.info("Routing getPatientShallowStudyList to site '" + routingToken.toRoutingTokenString() + "'.");
			// must call patient artifact command in order to get all studies if calling a VA site with patch 104 installed (since study graph SPI now only returns radiology data)
			ArtifactResults artifactResults = rtr.getStudyWithReportArtifactResultsForPatientFromSite(
					routingToken, 
					PatientIdentifier.icnPatientIdentifier(patientId),
					internalFilter, true, false);
			
			// update the transaction context with the study count
			transactionContext.setEntriesReturned( artifactResults == null ? 0 : artifactResults.getArtifactSize() );
			logger.debug("getPatientShallowStudyList transforming results from business objects.");
			result = interpreter.transformStudiesToShallowStudies(artifactResults);
		}
		catch(MethodException mX)
		{
			logger.error("FAILED getPatientShallowStudyList method Exception: " + mX.toString() + " ms", mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", mX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getPatientShallowStudyList connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(URNFormatException iurnfX)
		{
			logger.error("FAILED getPatientShallowStudyList transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", iurnfX);
		}	
		catch (RoutingTokenFormatException rtfX)
		{
			logger.error("FAILED getPatientShallowStudyList transaction(" + transactionId, rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", rtfX);
		}	
		
		if( logger.getLevel() == Level.DEBUG )
		{
			StringBuilder sb = new StringBuilder();
			
			sb.append("getPatientShallowStudyList returning " + (result == null ? "<null>" : result.length) + " study IDs: \n");
			for(int studyIndex = 0; result != null && studyIndex < result.length; ++studyIndex)
				sb.append("  - " + result[studyIndex].getStudyId() + " \n");
			
			logger.debug(sb.toString());
		}
		
		logger.info("complete ClinicalDisplay getPatientShallowStudyList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms)" );
        return result;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageClinicalDisplayMetadata#getStudyImageList(java.lang.String, java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.UserCredentials)
	 */
	@Override
	public FatImageType[] getStudyImageList(String transactionId,
			String studyId, UserCredentials credentials) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
    	
    	long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getStudyImageList transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		StudyURN studyUrn = null;
		gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType[] result = null;
		// initialize the transaction context
		//TODO: set Request type generically
		
		if(ExchangeUtil.isSiteDOD(credentials.getSiteNumber()))
		{
			transactionContext.setRequestingSource("DOD");
		}
		else
		{
			transactionContext.setRequestingSource("VA");
		}
		
		transactionContext.setRequestType(getWepAppName() + " getStudyImageList");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		
		try {
			studyUrn = URNFactory.create(studyId, SERIALIZATION_FORMAT.CDTP, StudyURN.class);
			
			transactionContext.setUrn(studyId);
			// update the transaction context with patientId
			transactionContext.setPatientID(studyUrn.getPatientId());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			
			Study study = rtr.getPatientStudy(studyUrn);
			transactionContext.setEntriesReturned( study == null ? 0 : study.getImageCount());
			result = interpreter.transformStudyToFatImages(study);
			/*
			images = vixCore.getStudyImageList(studyUrn);
			// update the transaction context with the image count
			transactionContext.setEntriesReturned( images == null ? 0 : images.size() );
			result = (gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FatImageType[])interpreter.transformImagesToFatImages(images);
			*/
		}
		catch (ClassCastException e)
        {
			// the URN.create() can throw a ClassCastException if the string URN has the wrong namespace identifier
			String msg = "'" + studyId + "' is not a valid study identifier (StudyURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study Id", e);
        } 
		catch(URNFormatException iurnfX) {
			logger.info("FAILED getStudyImageList transaction(" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable " + ((studyUrn==null) ? "to translate study Id" : "to transform Images"), iurnfX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getStudyImageList connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(MethodException mX) {
			logger.info("FAILED getStudyImageList method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve study images", mX);
		}
		logger.info("complete ClinicalDisplay getStudyImageList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms" );
		return result;   
	}
	
	

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageClinicalDisplayMetadata#pingServerEvent(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.UserCredentials)
	 */
	@Override
	public PingServerTypePingResponse pingServerEvent(String transactionId,
			String clientWorkstation, String requestSiteNumber, UserCredentials credentials) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		logger.info("pingServerEvent from [" + clientWorkstation + "] going to site number [" + requestSiteNumber + "]");
    	
		//IAppConfiguration appConfiguration = ImagingClinicalDisplayContext.getAppConfiguration();
		PingServerTypePingResponse response = PingServerTypePingResponse.SERVER_UNAVAILABLE;
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " pingServer to (" + requestSiteNumber + ")");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		transactionContext.setRequestingSource(credentials.getSiteNumber());
		
		ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
		try
		{
			/*
			ClinicalDisplayWebAppConfiguration configuration = getClinicalDisplayConfiguration();
			// if the requested site is DOD or if V2V is allowed, then check for site status
			// if not DOD and V2V not allowed, don't bother checking, just return unavailable
			if(ExchangeUtil.isSiteDOD(requestSiteNumber) || (configuration.getAllowV2V()))
			{
				SiteConnectivityStatus siteStatus = rtr.isSiteAvailable(requestSiteNumber);			
				response = interpreter.transformServerStatusToPingServerResponse(siteStatus);
			}
			*/			
			SiteConnectivityStatus siteStatus = rtr.isSiteAvailable(RoutingTokenHelper.createSiteAppropriateRoutingToken(requestSiteNumber));			
			response = interpreter.transformServerStatusToPingServerResponse(siteStatus);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED pingServerEvent connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(MethodException cX)
		{
			logger.error("FAILED pingServerEvent connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			logger.error("FAILED getPatientShallowStudyList transaction(" + transactionId, rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", rtfX);
		}	
		
		return response;
	}
	

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageClinicalDisplayMetadata#postImageAccessEvent(java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageAccessLogEventType)
	 */
	@Override
	public boolean postImageAccessEvent(String transactionId,
			ImageAccessLogEventType logEvent) 
	throws RemoteException 
	{
		setTransactionContext(logEvent.getCredentials(), transactionId);
		TransactionContext transactionContext = TransactionContextFactory.get();
    	long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay postImageAccessEvent transaction(" + transactionId + ")" );
		logger.info("logEvent image [" + logEvent.getId() + "].");
		try
		{
			transactionContext.setRequestType(getWepAppName() + " postImageAccessEvent [" + logEvent.getEventType() + "]");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			// need to use the Id from the webservice log event since it is the full URN and not just 
			// the individual image identifier
			transactionContext.setUrn(logEvent.getId());
			ImageAccessLogEvent event = interpreter.transformLogEvent(logEvent);
			transactionContext.setPatientID(event.getPatientIcn());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			rtr.logImageAccessEvent(event);
		}
		catch(ConnectionException cX)
		{
			getLogger().error("FAILED postImageAccessEvent connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to post image access", cX);
		}
		catch(MethodException cX)
		{
			getLogger().error("FAILED postImageAccessEvent method Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			handleMethodException(cX);
			throw new RemoteException("Internal error, unable to post image access", cX);
		}
		catch(URNFormatException iurnfX) {
			logger.info("FAILED postImageAccessEvent transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		} 
		logger.info("complete ClinicalDisplay postImageAccessEvent transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return true;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.ImageClinicalDisplayMetadata#prefetchStudyList(java.lang.String, java.lang.String, java.lang.String, gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.FilterType, gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.UserCredentials)
	 */
	@Override
	public PrefetchResponseTypePrefetchResponse prefetchStudyList(String transactionId, String siteId, String patientId, 
			FilterType filter, UserCredentials credentials)
	throws RemoteException 
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	
	
	@Override
	public String getImageInformation(String imageId, String transactionId,
			UserCredentials credentials) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getImageInformation transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		AbstractImagingURN urn = null;
		try
		{
			urn = URNFactory.create(imageId, SERIALIZATION_FORMAT.CDTP, AbstractImagingURN.class);
			transactionContext.setPatientID(urn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageInformation");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(urn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageInformation(urn);
			logger.info("complete ClinicalDisplay getImageInformation transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch (ClassCastException e)
        {
			// the URN.create() can throw a ClassCastException if the string URN has the wrong namespace identifier
			String msg = "'" + imageId + "' is not a valid image identifier (ImageURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", e);
        } 
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getImageInformation transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image information", infX);
		}
		catch(ConnectionException ioX)
		{
			logger.info("FAILED getImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", ioX);
			transactionContext.setErrorMessage(ioX.getMessage());
			transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image information", ioX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getImageInformation method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image information", mX);
		}
	}

	@Override
	public String getImageSystemGlobalNode(String imageId, String transactionId, 
		UserCredentials credentials)
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getImageSystemGlobalNode transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		AbstractImagingURN urn = null;
		try
		{
			urn = URNFactory.create(imageId, SERIALIZATION_FORMAT.CDTP, AbstractImagingURN.class);
			transactionContext.setPatientID(urn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageSystemGlobalNode");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(urn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageSystemGlobalNode(urn);
			logger.info("complete ClinicalDisplay getImageSystemGlobalNode transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch (ClassCastException e)
        {
			// the URN.create() can throw a ClassCastException if the string URN has the wrong namespace identifier
			String msg = "'" + imageId + "' is not a valid image identifier (ImageURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", e);
        } 
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getImageSystemGlobalNode transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getImageSystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image global node", infX);
		}
		catch(ConnectionException ioX)
		{
			logger.info("FAILED getImageSystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", ioX);
			transactionContext.setErrorMessage(ioX.getMessage());
			transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image global node", ioX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getImageSystemGlobalNode method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image global node", mX);
		}
	}
	@Override
	public String getImageDevFields(String imageId, String flags, String transactionId, 
			UserCredentials credentials)
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		long startTime = System.currentTimeMillis();
		logger.info("start ClinicalDisplay getImageDevFields transaction(" + transactionId + ")" );
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		AbstractImagingURN urn = null;
		try
		{
			urn = URNFactory.create(imageId, SERIALIZATION_FORMAT.CDTP, AbstractImagingURN.class);
			transactionContext.setPatientID(urn.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " getImageDevFields");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			transactionContext.setUrn(urn.toString());
			transactionContext.setRequestingSource(transactionContext.getSiteNumber());
			ClinicalDisplayRouter rtr = ImagingClinicalDisplayContext.getRouter(); 
			//Router vixCore = ImagingClinicalDisplayContext.getVixRouter();
			String response = rtr.getImageDevFields(urn, flags);
			logger.info("complete ClinicalDisplay getImageDevFields transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch (ClassCastException e)
        {
			// the URN.create() can throw a ClassCastException if the string URN has the wrong namespace identifier
			String msg = "'" + imageId + "' is not a valid image identifier (ImageURN).";
			logger.info(msg);
			transactionContext.setErrorMessage(msg);
			transactionContext.setExceptionClassName(e.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", e);
        } 
		catch(URNFormatException iurnfX)
		{
			logger.info("FAIlED getImageDevFields transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		}
		catch(ImageNotFoundException infX)
		{
			logger.info("FAILED getImageDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", infX);
			transactionContext.setErrorMessage(infX.getMessage());
			transactionContext.setExceptionClassName(infX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image dev fields", infX);
		}
		catch(ConnectionException ioX)
		{
			logger.info("FAILED getImageDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", ioX);
			transactionContext.setErrorMessage(ioX.getMessage());
			transactionContext.setExceptionClassName(ioX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image dev fields", ioX);
		}
		catch(MethodException mX)
		{
			logger.info("FAILED getImageDevFields method exception (" + transactionId + ") after " + (System.currentTimeMillis() - startTime) + " ms", mX);
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve image dev fields", mX);
		}
	}
	
	private void setTransactionContext(
			gov.va.med.imaging.clinicaldisplay.webservices.soap.v3.UserCredentials credentials,
			String transactionId)
	{
		logger.info(
				"setTransactionContext, id='" + transactionId + 
				"', username='" + credentials == null || credentials.getFullname() == null ? "null" : credentials.getFullname() + 
				"'.");
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		if(transactionId != null)
			transactionContext.setTransactionId(transactionId);
		
		if(credentials != null)
		{
			if( credentials.getFullname() != null )
				transactionContext.setFullName(credentials.getFullname());
			if( credentials.getSiteNumber() != null )
				transactionContext.setSiteNumber(credentials.getSiteNumber());
			if( credentials.getSiteName() != null )
				transactionContext.setSiteName(credentials.getSiteName());
			if( credentials.getSsn() != null )
				transactionContext.setSsn(credentials.getSsn());
			if(credentials.getDuz() != null)
				transactionContext.setDuz(credentials.getDuz());
			transactionContext.setPurposeOfUse(PurposeOfUse.routineMedicalCare.getDescription());
		}		
	}
	
	protected String getWepAppName()
	{
		return "Clinical Display WebApp V3";
	}
}
