/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 2, 2016
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vacotittoc
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.ax.webservices.commands;

// import java.sql.Date;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
// import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

import gov.va.med.MediaType;
// import gov.va.med.PatientIdentifier;
import gov.va.med.RoutingToken;
import gov.va.med.RoutingTokenImpl;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.DicomDateFormat;
import gov.va.med.imaging.ax.AxWebAppRouter;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.core.interfaces.exceptions.PatientNotFoundException;
import gov.va.med.imaging.exchange.business.DocumentFilter;
import gov.va.med.imaging.exchange.business.documents.Document;
import gov.va.med.imaging.exchange.business.documents.DocumentSet;
// import gov.va.med.imaging.mix.webservices.translator.v1.MixTranslatorV1;
import gov.va.med.imaging.exchange.business.documents.DocumentSetResult;
import gov.va.med.imaging.exchange.enums.PatientSensitivityLevel;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.transactioncontext.TransactionContext;
// import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

/**
 * @author vacotittoc
 *
 */
public abstract class AbstractAxGetDocumentListCommand<E extends Object>
extends AbstractAxWebserviceCommand<DocumentSetResult, E>
{
	private final String patientId;
	private final String loinc;
//	private final String requestor;
//	private final String transactionId;
//	private final String requestedSite;

	private final DocumentFilter documentFilter;
	private DateFormat utilityDateFormat = new SimpleDateFormat("yyyyMMdd");
	
	private java.util.Date getDate(String yMD)
	{
		java.util.Date theDate = null;
		DicomDateFormat ddf = new DicomDateFormat();

		if (yMD!=null) {
			try {
			theDate = ddf.parse(yMD);
			} 
			catch (ParseException pe) {
				getLogger().info("ParseException on date string '" + yMD + "'.");
				theDate=null;
			} 
			return theDate;
		} else
			return null;
	}

	public AbstractAxGetDocumentListCommand(String patientId, String LOINC, String fromDate, String toDate) // String requestor, String transactionId)
	{
		super("GetDocumentSetResultForPatientCommand");
		this.patientId = patientId;
		this.loinc = LOINC;

		java.util.Date begDate = getDate(fromDate); // time is 00:00:00
		java.util.Date endDate = getDate(toDate);
		if (endDate==null)
			endDate = new java.util.Date(); // now!
		// endDate.setTime(86399999); // make sure end of day is set in milliseconds!!
		documentFilter = new DocumentFilter(patientId, begDate, endDate);
		documentFilter.setMaximumAllowedLevel(PatientSensitivityLevel.DISPLAY_WARNING_REQUIRE_OK); // =2, 3 or higher blocked! set 1 to call PatientSensitivityLevel.DISPLAY_WARNING);
		
//		this.requestor = requestor;
//		this.transactionId = transactionId;
	}

	@Override
	protected DocumentSetResult executeRouterCommand() 
	throws MethodException, ConnectionException
	{
    	TransactionContext transactionContext = TransactionContextFactory.get();
    	
    	AxWebAppRouter router = getRouter();

		try
		{
			documentFilter.setExcludeSiteNumbers(getExcludedSiteNumbers());
		}
		catch(RoutingTokenFormatException rtfX)
		{
			getLogger().warn("RoutingTokenFormatException while setting excluded sites, " + rtfX.getMessage(), rtfX);
		}
		getTransactionContext().setQueryFilter(TransactionContextFactory.getFilterDateRange(documentFilter.getFromDate(), documentFilter.getToDate()));
		DocumentSetResult result = null;

		try
		{
			transactionContext.setPatientID(documentFilter.getPatientId());
			transactionContext.setRequestType(getWepAppName() + " Query");
			transactionContext.setQueryFilter(TransactionContextFactory.getFilterDateRange(documentFilter.getCreationTimeFrom(), documentFilter.getCreationTimeTo()));

			// we should have a configuration for the OID that we are representing
			RoutingToken routingToken = RoutingTokenImpl.createVADocumentSite(RoutingToken.ROUTING_WILDCARD);

			// get documents from all sites for this patient
			logger.info("AX -- calling router.getDocumentSetList(" + documentFilter.toString() + ");"); //$NON-NLS-1$ //$NON-NLS-2$
			result = router.getDocumentSetResultForPatient(routingToken, documentFilter);
			// check for null documentSetResult - really shouldn't happen but just in case
			if(result == null)
				throw new MethodException("documentSetResult is null, no response getting results for patient '" + documentFilter.getPatientId() + "'.");

			//TODO: check for partial result and for errors and add them to the response, make translator use DocumentSetResult
			result = removeDicomDocs(result);
			// logger.info("AX Got " + (result == null ? "null" : Integer.toString(result.getArtifactSize())) + " DocumentSet instances."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			transactionContext.setEntriesReturned(result == null ? 0 : result.getArtifactSize());
			// logger.info("Translated DocumentSet instances into '" + result.getClass().getSimpleName() + "' instance."); //$NON-NLS-1$ //$NON-NLS-2$			

		}
		catch(PatientNotFoundException pnfX)
		{
			getLogger().warn("AX PatientNotFoundException returning empty document list for patient '" + getPatientId() + "', " + pnfX.getMessage());
			// for this interface return an empty document list if a patient is not found
			SortedSet<DocumentSet> fullResults = new TreeSet<DocumentSet>();
			result = DocumentSetResult.createFullResult(fullResults);
		}
		catch (RoutingTokenFormatException x)
		{
			logger.error("AX RoutigTokenformatexception: " + x);
		}
		getLogger().info("AX Got " + (result == null ? "null" : result.getArtifactSize()) + " Artifacts in DocumentSetResult from router for patient '" + getPatientId() + "'.");
		getTransactionContext().addDebugInformation("Result has status [" + result == null ? "null result" : result.getArtifactResultStatus() + "].");

		return result;
	}	
	
	private Collection<String> getExcludedSiteNumbers()
	{
		Collection<String> excludedSiteNumbers = new ArrayList<String>();
		excludedSiteNumbers.add("200");
		return excludedSiteNumbers;
	}

	private DocumentSetResult removeDicomDocs(
			DocumentSetResult routerResult) {
		int removedCount = 0;
		if ((routerResult != null) && (routerResult.getArtifactSize() > 0)) {
			getLogger().info("AX -- router.getDocumentSetList completed -- checking for DICOM document(s) in returned list ...");
			SortedSet<DocumentSet> inDocs = routerResult.getArtifacts();
			SortedSet<DocumentSet> outDocs = new TreeSet<DocumentSet>();
			for (DocumentSet docSet: inDocs) {
				boolean includeDocSet=true;
				if (docSet.size() > 0) {
					for (Document doc:docSet) {
						if ((doc.getMediaType() == MediaType.APPLICATION_DICOM) /* || 
							(doc.getMediaType() == MediaType.IMAGE_J2K) || 
							(doc.getMediaType() == MediaType.IMAGE_JP2) */ ) {
							// if (docSet.size()==1) {
								// remove docset
							// } else {
								// remove doc
							// }
							removedCount += docSet.size(); // assuming a group that has 1 DICOM document contains only DICOM documents
							includeDocSet = false;
							break;
							}
						}
					}
				if (includeDocSet==true) {
					outDocs.add(docSet);
				}
			}
			if (removedCount > 0)
				getLogger().info("AX -- ... removed " + removedCount + " DICOM document(s) from list !");

			if (!outDocs.isEmpty()) {
				DocumentSetResult fileredDocumentSetResult = DocumentSetResult.createFullResult(outDocs);
				return fileredDocumentSetResult;
			}
		}
		return routerResult;
	}

	@Override
	protected String getMethodParameterValuesString()
	{
		return "for patient '" + getPatientId() + "'.";
	}

	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
			new HashMap<WebserviceInputParameterTransactionContextField, String>();
		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.patientId, getPatientId());

		return transactionContextFields;
	}

	public String getPatientId()
	{
		return patientId;
	}

	public String getLoinc()
	{
		return loinc;
	}
	
//	protected gov.va.med.imaging.mix.webservices.fhir.types.v1.ReportStudyListResponseType translateRouterResult(
//			StudySetResult routerResult) throws TranslationException
//	{
//		// convert StudySetResult to ReportStudyListResponseType -- setting Study and instance UIDs as VA URNs to carry site and studyId and AssignedId respectively
//		ReportStudyListResponseType rslrt = null;
//		try {
//			rslrt = MixTranslatorV1.translate(routerResult);;
//		} catch (TranslationException te) {
//			throw new MethodException(te.getMessage());
//		}
//		return rslrt;
//	}
	
}
