/**
 * 
 * Property of ISI Group, LLC
 * Date Created: Jul 8, 2014
 * Developer: Julian Werfel
 */
package gov.va.med.imaging.ax.web;

// import gov.va.med.GlobalArtifactIdentifier;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.imaging.DocumentURN;
// import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
// import gov.va.med.imaging.core.interfaces.exceptions.SecurityCredentialsExpiredException;
import gov.va.med.imaging.exceptions.URNFormatException;
// import gov.va.med.imaging.mix.webservices.rest.MixServices;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.wado.AbstractBaseImageServlet;

import java.io.IOException;
import java.io.OutputStream;
// import java.net.URLDecoder;
// import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
/**
 * @author Julian
 *
 */
public abstract class AbstractAxDoGetDocument
extends AbstractBaseImageServlet
{
	private static final long serialVersionUID = 4698967362249071150L;
		
	private final static Logger logger = LogManager.getLogger(AbstractAxDoGetDocument.class);

	protected Logger getLogger()
	{
		return logger;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.wado.AbstractBaseImageServlet#getUserSiteNumber()
	 */
	@Override
	public String getUserSiteNumber()
	{
		return null;
	}
		
	protected abstract String getOperationName();

	protected abstract String getDocumentURN();

	protected abstract OutputStream getOutputStream()
	throws IOException;

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.wado.AbstractBaseImageServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		String msg="";
		String documentUrnString = getDocumentURN();

		// String requestURI = request.getProtocol() + "://" + request.getRemoteHost() + "/AxWebApp/restservices/ax/Binary/" + documentUrnString + "/";
        // @SuppressWarnings("deprecation")
        // String requestURL = URLDecoder.decode((request.getRequestURI()==null)?requestURI:request.getRequestURI()  + "?" + request.getQueryString() ); // , "ISO-8859-1");
		getLogger().debug("Ax received GET REST document request: " + request.getPathInfo()  + "?" + request.getQueryString());

		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType("Ax Web App V1 " + getOperationName());

		try
		{
			DocumentURN documenteUrn = URNFactory.create(documentUrnString, SERIALIZATION_FORMAT.RAW, DocumentURN.class); 
			transactionContext.setPatientID(documenteUrn.getThePatientIdentifier().toString());
			transactionContext.setUrn(documentUrnString);

			OutputStream outStream = getOutputStream(); // response.getOutputStream();
			getLogger().info("Ax retrieve Binary document: Requesting document [DocumentURN = " + documentUrnString + "]");
			long bytesTransferred = streamDocument(documenteUrn, outStream,
					new AxImageMetadataNotification(response));
			
			transactionContext.setEntriesReturned( bytesTransferred==0 ? 0 : 1 );
			transactionContext.setFacadeBytesSent(bytesTransferred);
			transactionContext.setResponseCode(HttpServletResponse.SC_OK + "");
		}
		catch(URNFormatException urnfX)
		{
			msg = "Ax: URNFormatException (on documentURN), " + urnfX.getMessage();
			getLogger().error(msg);
			transactionContext.setResponseCode(HttpServletResponse.SC_NOT_ACCEPTABLE + "");
			transactionContext.setErrorMessage(msg);
			response.sendError(HttpServletResponse.SC_NOT_ACCEPTABLE, msg); // 406 <= comment this line for FHIR error response
		}
		catch(ImageServletException isX)
		{
			msg = isX.getMessage();
			getLogger().error(msg);
			transactionContext.setResponseCode(isX.getResponseCode() + "");
			transactionContext.setErrorMessage(msg);
			response.sendError(isX.getResponseCode(), isX.getMessage());
		}
		
	}
}
