/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: 
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.server;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.awiv.client.UserSessionService;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class UserSessionServiceImpl 
extends RemoteServiceServlet 
implements UserSessionService 
{
	private static final long serialVersionUID = 8039835440697951133L;
	private final static Logger logger = LogManager.getLogger(UserSessionServiceImpl.class);

	@Override
	public boolean logout()
	{
		HttpSession session = getThreadLocalRequest().getSession(false);
		if(session != null)
			session.invalidate();
		Cookie cookie = AwivCredentialsCookie.getAwivCredentialsCookieValue(getThreadLocalRequest());		
		if(cookie != null)
		{
			cookie.setMaxAge(0); // delete the cookie
			getThreadLocalResponse().addCookie(cookie);
		}
		return true;
	}

	@Override
	public boolean isSessionStillActive()
	{
		HttpSession session = getThreadLocalRequest().getSession(false);
		
		logger.debug("Session " + session == null ? "is dead" : "is active");
		
		return (session != null);
	}
}
