/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 23, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.server;

import gov.va.med.imaging.artifactsource.ArtifactSource;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.awiv.web.UserDetails;
import gov.va.med.imaging.exchange.business.Site;
import gov.va.med.imaging.tomcat.vistarealm.VistaRealmPrincipal.AuthenticationCredentialsType;
import gov.va.med.imaging.transactioncontext.ClientPrincipal;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.UUID;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * @author       WERFEJ
 *
 */
public abstract class AbstractAwivClientRemoteServiceServlet
extends RemoteServiceServlet
{
	private static final long serialVersionUID = 8545988357367562961L;
	private final static Logger logger = LogManager.getLogger(AbstractAwivClientRemoteServiceServlet.class);
	
	protected Logger getLogger()
	{
		return logger;
	}
	
	protected void setTransactionContextProperties(String transactionId, String methodName)
	{
		setTransactionContextProperties(transactionId, methodName, null, null);
	}
	
	protected void setTransactionContextProperties(String transactionId, String methodName, String patientIcn)
	{
		setTransactionContextProperties(transactionId, methodName, patientIcn, null);
	}
	
	/*
	protected void setTransactionContextProperties(String methodName, String patientIcn, String urn)
	{
		setTransactionContextProperties(null, methodName, patientIcn, null);
	}*/

	protected void setTransactionContextProperties(String transactionId, String methodName, String patientIcn, String urn)
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		if(transactionId == null)
			transactionContext.setTransactionId(UUID.randomUUID().toString());
		else
			transactionContext.setTransactionId(transactionId);	
		transactionContext.setRequestType("AWIV Client Web App " + methodName);
		if(patientIcn != null)
			transactionContext.setPatientID(patientIcn);
		if(urn != null)
			transactionContext.setUrn(urn);
	}
	
	protected void setEntriesReturned(Integer entriesReturned)
	{
		TransactionContextFactory.get().setEntriesReturned(entriesReturned);
	}
	
	protected String getUserSiteNumber()
	{
		UserDetails user = getUserDetails();	
		return user.getSiteNumber();
	}
	
	protected UserDetails getUserDetails()
	{
		//return new UserDetails(this.getThreadLocalRequest().getSession(false));
		
		// the filter should have put the information into place
		return new UserDetails(TransactionContextFactory.get());
	}
	
	protected void setUserCredentials(String siteNumber, String username, String password)
	{
		ClientPrincipal principal = new ClientPrincipal(
				siteNumber, true,AuthenticationCredentialsType.Password, 
				username, password,
				null, null, null, null, null,
				new ArrayList<String>(),
				new HashMap<String, Object>()
		);
		TransactionContextFactory.createClientTransactionContext(principal);
	}
	
	protected class ResolvedArtifactSourceComparator 
	implements Comparator<ResolvedArtifactSource>
	{

		/* (non-Javadoc)
		 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
		 */
		@Override
		public int compare(ResolvedArtifactSource source1, ResolvedArtifactSource source2)
		{
			ArtifactSource a1 = source1.getArtifactSource();
			ArtifactSource a2 = source2.getArtifactSource();
			if(a1 instanceof Site && a2 instanceof Site)
			{
				Site s1 = (Site)a1;
				Site s2 = (Site)a2;
				return s1.getSiteName().compareToIgnoreCase(s2.getSiteName());
			}
			return 0;
		}
		
	}
	
}
