/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Feb 21, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets.dialogs;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.awiv.business.AwivAuthenticationSitesInformation;
import gov.va.med.imaging.awiv.business.AwivSite;
import gov.va.med.imaging.awiv.business.AwivWelcomeMessage;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.dao.UserAuthenticationDao;
import gov.va.med.imaging.awiv.client.events.UserAuthenticatedEvent;
import gov.va.med.imaging.awiv.client.ui.widgets.AwivConstants;
import gov.va.med.imaging.awiv.client.ui.widgets.AwivExceptionHandler;
import gov.va.med.imaging.awiv.exceptions.AwivCredentialsExpiredException;
import gov.va.med.imaging.awiv.exceptions.AwivInvalidUserCredentialsException;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Window.Location;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.types.TitleOrientation;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.Window;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.PasswordItem;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.form.fields.events.KeyPressEvent;
import com.smartgwt.client.widgets.form.fields.events.KeyPressHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;

/**
 * This is the user authentication dialog.  It captures the site the user is authenticating against and their 
 * access and verify codes.  When this dialog is completed the user has been authenticated
 * 
 * @author       WERFEJ
 *
 */
public class AuthenticateUserDialog
extends Window
{
	private static Logger logger = LogManager.getLogger("");
	private SelectItem selectSites = new SelectItem();
	private final Label welcomeMessageLabel = new Label();
	private final Map<String, AwivSite> sitesById = new HashMap<String, AwivSite>();
	private final Map<String, AwivSite> sitesByName = new HashMap<String, AwivSite>();
	private final HLayout loginLayout = new HLayout();
	private AwivSite selectedSite = null;
	private final UserAuthenticatedEvent userAuthenticatedEvent;
	private final String specifiedSiteNumber;
	private final PasswordItem accessCode = new PasswordItem();
	private final PasswordItem verifyCode = new PasswordItem();
	private final DynamicForm loginForm = new DynamicForm();
	private final IButton loginButton = new IButton("OK");
	private final Label browserWarning = new Label();
	
	public AuthenticateUserDialog(UserAuthenticatedEvent userAuthenticatedEvent, String specifiedSiteNumber)
	{
		super();
		this.userAuthenticatedEvent = userAuthenticatedEvent;
		this.specifiedSiteNumber = specifiedSiteNumber;
		setWidth(550);  
		setHeight(500);  
		setAutoSize(true);
		setTitle("VistA Imaging AWIV - Login");
		setHeaderIcon(Location.getProtocol() + "//" + Location.getHost() + "/Awiv/images/ccow_broken16.gif");
		setShowMinimizeButton(false);
		setShowCloseButton(false);
		setIsModal(true);  
		setShowModalMask(true);  
		centerInPage();  
		
		Label introLabel = new Label();
		introLabel.setMargin(2);
		introLabel.setWidth100();
		introLabel.setHeight(20);
		introLabel.setAlign(Alignment.CENTER);
		introLabel.setContents("Welcome to the VistA Imaging Advanced Web Image Viewer (AWIV). This provides access to images stored at VA sites in VistA Imaging and images stored in the DoD." +  
				"<br><br>To begin select an authentication site from the list below. This must be a site at which you have an account (access and verify codes).");
		
		final DynamicForm form = new DynamicForm();
		form.setTitleOrientation(TitleOrientation.LEFT);
		form.setNumCols(2);
		selectSites.setTitle("Select Authentication Site");
		selectSites.setAddUnknownValues(false);
		selectSites.setTitleAlign(Alignment.RIGHT);
		selectSites.setWrapTitle(false);
		
		form.setFields(selectSites);
		
		welcomeMessageLabel.setContents("");
		welcomeMessageLabel.setWidth100();
		welcomeMessageLabel.setHeight(280);
		welcomeMessageLabel.setAlign(Alignment.CENTER);
		welcomeMessageLabel.setValign(VerticalAlignment.CENTER);
		welcomeMessageLabel.setOverflow(Overflow.AUTO);
		welcomeMessageLabel.setBorder("2px solid dimgray");
		
		final IButton selectSiteButton = new IButton("OK");
		selectSiteButton.setDisabled(true);
		selectSites.addChangedHandler(new ChangedHandler()
		{
			@Override
			public void onChanged(ChangedEvent event)
			{
				selectSiteButton.setDisabled(false);
				clearWelcomeMessage();
			}
		});
		// add handler for the enter key if the user presses it when on the selectsite combo box to select that site
		selectSites.addKeyPressHandler(new KeyPressHandler()
		{
			@Override
			public void onKeyPress(KeyPressEvent event)
			{
				if(AwivConstants.enterButtonKeyName.equals(event.getKeyName()))
				{
					selectSite();
				}
			}
		});				
		
		loginForm.setWrapItemTitles(false);
		loginForm.setMargin(2);
		loginForm.setTitleOrientation(TitleOrientation.LEFT);		
		
		accessCode.setTitle("Access Code");
		accessCode.setRequired(true);
		accessCode.setType("password");
		
		// if the user puts the access code and verify code into the access code field separated by a semicolon
		// then capture the enter key press made from this field
		accessCode.addKeyPressHandler(new KeyPressHandler()
		{
			@Override
			public void onKeyPress(KeyPressEvent event)
			{
				if(AwivConstants.enterButtonKeyName.equals(event.getKeyName()))
				{
					loginUser();
				}
			}
		});
		
		verifyCode.setTitle("Verify Code");
		verifyCode.setRequired(true);
		verifyCode.setType("password");
		
		verifyCode.addKeyPressHandler(new KeyPressHandler()
		{			
			@Override
			public void onKeyPress(KeyPressEvent event)
			{
				if(AwivConstants.enterButtonKeyName.equals(event.getKeyName()))
				{
					loginUser();
				}
			}
		});
				
		loginForm.setFields(accessCode, verifyCode);
		
		selectSiteButton.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(ClickEvent event)
			{
				/*
				Object value = selectSites.getValue();
				if(value != null)
				{
					String siteNumber = value.toString();	
					logger.info("User selected site '" + siteNumber + "'.");
					AwivSite awivSite = sites.get(siteNumber);
					if(awivSite != null)
					{
						loadWelcomeMessage(awivSite);
						setAccessCodeFocus();
					}
					else
						clearWelcomeMessage();
				}
				else
				{
					clearWelcomeMessage();
				}
				*/
				selectSite();
			}
		});
		
		loginButton.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(ClickEvent event)
			{
				loginUser();
			}
		});
				
		browserWarning.setWidth100();
		browserWarning.setHeight(22);
		browserWarning.setStyleName("Browser-Warning");
		browserWarning.setContents("WARNING: Your browser is not supported for viewing images. You can continue to view patient studies however you will not be able to view images using the AWIV unless you are using Internet Explorer");
		
		browserWarning.setVisible(false);//!AwivHelper.isBrowserIE());			
		
		HLayout selectSiteLayout = new HLayout();
		selectSiteLayout.setMargin(2);
		selectSiteLayout.setWidth100();
		selectSiteLayout.setHeight(20);
		selectSiteLayout.addMember(form);
		selectSiteLayout.addMember(selectSiteButton);
		//selectSiteLayout.setBackgroundColor("orange");
		
		loginLayout.setWidth100();
		loginLayout.addMember(loginForm);
		loginLayout.addMember(loginButton);
		loginLayout.setMargin(2);
		//loginLayout.setBackgroundColor("green");
		
        VLayout layout = new VLayout();
        layout.setHeight100();
        layout.setWidth100();
        
        layout.addMember(introLabel);
        layout.addMember(selectSiteLayout);
        layout.addMember(welcomeMessageLabel);
        layout.addMember(loginLayout);
        layout.addMember(browserWarning);
        
        loginLayout.setVisible(false);
       
    	this.addItem(layout);
    	Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand () {
	        public void execute () 
	        {
	        	loadAuthenticationSites();
	        	if(AuthenticateUserDialog.this.specifiedSiteNumber == null)
	        		form.focusInItem(selectSites);
	        }
	    });
	}
	
	private void selectSite()
	{
		Object value = selectSites.getValue();
		if(value != null)
		{
			String siteName = value.toString();	
			logger.info("User selected site '" + siteName + "'.");
			AwivSite awivSite = sitesByName.get(siteName);
			if(awivSite != null)
			{
				loadWelcomeMessage(awivSite);
				setAccessCodeFocus();
			}
			else
				clearWelcomeMessage();
		}
		else
		{
			clearWelcomeMessage();
		}
	}
	
	private void setAccessCodeFocus()
	{
		Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand () {
	        public void execute () 
	        {
	        	loginForm.focusInItem(accessCode);
	        }
	    });
	}
	
	private void loginUser()
	{
		loginButton.setDisabled(true);
		String transactionId = UUID.uuid();
		logger.info("Authenticating user to site '" + selectedSite.getSiteNumber() + "' with transaction Id '" + transactionId + "'.");
		UserAuthenticationDao.userAuthenticationDao.authenticateUser(transactionId, selectedSite.getSiteNumber(), 
				accessCode.getValueAsString(), verifyCode.getValueAsString(), new AsyncCallback<Boolean>()
				{
					
					@Override
					public void onSuccess(Boolean arg0)
					{						
						AuthenticateUserDialog.this.userAuthenticatedEvent.onUserAuthenticated();
					}
					
					@Override
					public void onFailure(Throwable arg0)
					{
						loginButton.setDisabled(false);
						logger.error("Error authenticating user, " + arg0.getMessage());
						if(!AwivExceptionHandler.handleServiceException(arg0))
						{
							if(arg0 instanceof AwivInvalidUserCredentialsException)
							{
								SC.warn("There was an error authenticating your access and verify codes with the specified site. <br>This might have been caused by entering incorrect access and verify codes or selecting a site you do not have credentials at.", 
										new BooleanCallback()
								{									
									@Override
									public void execute(Boolean value)
									{
										accessCode.setValue("");
										verifyCode.setValue("");
										setAccessCodeFocus();		
									}
								});								
							}
							else if(arg0 instanceof AwivCredentialsExpiredException)
							{
								SC.warn("Your verify code has expired. Please use another application (such as CPRS or VistA Imaging Clinical Display) to change your Verify code and then login again.", 
										new BooleanCallback()
								{									
									@Override
									public void execute(Boolean value)
									{
										accessCode.setValue("");
										verifyCode.setValue("");
										setAccessCodeFocus();		
									}
								});		
							}
							else
							{
								// some other error
								SC.warn("There was an error authenticating your access and verify codes with the specified site. <br>Please try again, if the error persists contact your administrator.<br><br>" + arg0.getMessage(), 
										new BooleanCallback()
								{									
									@Override
									public void execute(Boolean value)
									{
										accessCode.setValue("");
										verifyCode.setValue("");
										setAccessCodeFocus();		
									}
								});		
							}
						}
					}
				});
	}
	
	private void clearWelcomeMessage()
	{
		accessCode.setValue("");
		verifyCode.setValue("");
		welcomeMessageLabel.setContents(" ");
		loginLayout.setVisible(false);
	}
	
	/**
	 * Load and display the welcome message for the specified site
	 * @param awivSite
	 */
	private void loadWelcomeMessage(final AwivSite awivSite)
	{
		selectedSite = awivSite;
		clearWelcomeMessage();
		welcomeMessageLabel.setContents("Loading welcome message from site");		
		//WaitDialog.displayWaitDialog("Loading Welcome Message", "Please wait while loading welcome message");
    	String transactionId = UUID.uuid();
    	logger.info("Retrieving welcome message from site '" + awivSite.getSiteNumber() + "' with transaction Id '" + transactionId + "'.");
    	
    	UserAuthenticationDao.userAuthenticationDao.getWelcomeMessage(transactionId, awivSite.getSiteNumber(), 
    			new AsyncCallback<AwivWelcomeMessage>()
		{
			
			@Override
			public void onSuccess(AwivWelcomeMessage welcomeMessage)
			{
				loginLayout.setVisible(true);
				//WaitDialog.hideWaitDialog();
				welcomeMessageLabel.setContents(welcomeMessage.getWelcomeMessage());
				selectSites.setValue(awivSite.toString()); // this is to ensure the displayed site matches the welcome message
				setAccessCodeFocus();
			}
			
			@Override
			public void onFailure(Throwable arg0)
			{
				//WaitDialog.hideWaitDialog();
				logger.error("Error loading welcome message, " + arg0.getMessage());
				if(!AwivExceptionHandler.handleServiceException(arg0))
				{
					welcomeMessageLabel.setContents("There was an error retrieving the welcome message from VistA, please try again.  If the error persists please contact your system administrator.<hr/>Error Details:<br />" + arg0.getMessage());
				}				
			}
		});
	}
	
	/**
	 * Load and display the list of authentication sites
	 */
	private void loadAuthenticationSites()
	{
    	WaitDialog.displayWaitDialog("Loading Authentication Sites", "Please wait while loading authentication sites");
    	String transactionId = UUID.uuid();
    	logger.info("Retrieving list of user authentication lookup sites with transaction Id '" + transactionId + "'.");
    	UserAuthenticationDao.userAuthenticationDao.getUserAuthenticationSites(transactionId, new AsyncCallback<AwivAuthenticationSitesInformation>()
		{
			
			@Override
			public void onSuccess(AwivAuthenticationSitesInformation awivAuthenticationSitesInformation)
			{
				WaitDialog.hideWaitDialog();
				// make the browser warning visible if not IE and if IE is required
				browserWarning.setVisible(awivAuthenticationSitesInformation.getAwivServerInformation().isIeOnly() && !AwivHelper.isBrowserIE());
				
				sitesById.clear();
				sitesByName.clear();
				LinkedHashMap<String, String> linkedSites = new LinkedHashMap<String, String>();
				for(AwivSite awivSite : awivAuthenticationSitesInformation.getAwivSites())
				{
					sitesById.put(awivSite.getSiteNumber(), awivSite);
					sitesByName.put(awivSite.toString(), awivSite);
					//linkedSites.put(awivSite.getSiteNumber(), awivSite.toString());
					// JMW 7/25/2012 P124, IE 9 does the sorting based on the key, not the value. Putting the value into the key to get the right sorting
					linkedSites.put(awivSite.toString(), awivSite.toString());
				}
										
				selectSites.setValueMap(linkedSites);				
				
				if(specifiedSiteNumber != null)
				{
					AwivSite site = sitesById.get(specifiedSiteNumber);
					if(site != null)
					{
						selectSites.setValue(site.toString());
						loadWelcomeMessage(site);
					}
				}
			}
			
			@Override
			public void onFailure(Throwable arg0)
			{
				WaitDialog.hideWaitDialog();
				logger.error("Error loading user authentication lookup sites, " + arg0.getMessage());
				if(!AwivExceptionHandler.handleServiceException(arg0))
				{
					AwivHelper.displayErrorMessage("Error loading authentication sites", arg0);
				}
			}
		});		
	}
}
