/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 9, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import gov.va.med.imaging.awiv.business.AwivSite;
import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.client.events.PatientSelectedEvent;
import gov.va.med.imaging.awiv.client.events.PatientSiteLookupSelectedEvent;
import gov.va.med.imaging.awiv.client.events.StudySelectedEvent;
import gov.va.med.imaging.awiv.client.ui.data.StudyRecord;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gwt.core.client.GWT;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tab.Tab;
import com.smartgwt.client.widgets.tab.TabSet;
import com.smartgwt.client.widgets.tab.events.CloseClickHandler;
import com.smartgwt.client.widgets.tab.events.TabCloseClickEvent;

/**
 * Tab container holding all of the tabs used by the AWIV
 * 
 * @author       WERFEJ
 *
 */
public class TabArea
extends VLayout
implements StudySelectedEvent, PatientSiteLookupSelectedEvent
{
	private final TabSet tabSet;
	
	private PatientSelectionTab patientSelectionTab = null;
	private PatientStudiesTab patientStudiesTab = null;
	private PatientSelectedEvent patientSelectedEvent = null;
	private LogTab logTab = null;
	private AwivUserInformation awivUserInformation = null;
	private PatientSiteLookupTab patientSiteLookupTab = null;
	private static Logger logger = LogManager.getLogger("");
	private DebugTab debugTab = null;
	
	public TabArea(PatientSelectedEvent onPatientSelectedEvent)
	{
		super();
		this.setBackgroundColor("white");
		this.patientSelectedEvent = onPatientSelectedEvent;
		this.tabSet = new TabSet();
		GWT.log("init TabArea()...", null);
		this.setWidth("*");
		this.addMember(tabSet);
		this.logTab = new LogTab();
		this.setRedrawOnResize(false);
		this.tabSet.addCloseClickHandler(new CloseClickHandler()
		{
			
			@Override
			public void onCloseClick(TabCloseClickEvent event)
			{
				AwivTab tab = (AwivTab)event.getTab();
				List<Tab> killTabs = new ArrayList<Tab>();
				for(Tab t : tabSet.getTabs())
				{
					if(t != tab)
					{
						if(t instanceof AwivTab)
						{
							AwivTab at = (AwivTab)t;
							if(tab.getCreationIndex() < at.getCreationIndex())
							{
								killTabs.add(t);
							}
						}
					}
				}
				for(Tab at : killTabs)
				{
					if(at == patientStudiesTab)
					{
						patientStudiesTab = null;
					}
					tabSet.removeTab(at);
				}
				if(tab == patientStudiesTab)
					patientStudiesTab = null;
				
				if(patientStudiesTab == null)
				{
					// the patient is cleared, make sure everyone knows it
					if(patientSelectedEvent != null)
						patientSelectedEvent.onPatientSelected(null, true);
				}
			}
		});

	}
	
	private void displayTab(Tab tab)
	{
		for(Tab t : tabSet.getTabs())
		{
			if(t == tab)
			{
				tabSet.selectTab(t);
				return;
			}
		}
		this.tabSet.addTab(tab);
		tabSet.selectTab(tab); // make this thing visible
	}
	
	/**
	 * Display the patient selection tab (does not clear the current results of searched patients)
	 */
	public void displayPatientSelectionTab()
	{
		displayPatientSelectionTab(false);
	}

	/**
	 * Display the patient selection tab, can specify if the current results of searched patients should be cleared
	 * @param clear If true any currently displayed patient search results are cleared, otherwise they are shown
	 */
	public void displayPatientSelectionTab(boolean clear)
	{
		if(clear && patientSelectionTab != null)
		{
			tabSet.removeTab(patientSelectionTab);
			patientSelectionTab = null;
		}		
		if(patientSelectionTab == null)
		{
			patientSelectionTab = new PatientSelectionTab(getAwivUserInformation());
			patientSelectionTab.addPatientSelectedHandler(patientSelectedEvent);
		}		
		displayTab(patientSelectionTab);
	}
	
	/**
	 * Display the specified patient
	 * @param patient The patient to display
	 * @param canClosePatient indicates if the patient can be closed (to allow displaying another patient). If this is false then this patient is the only patient which can be seen
	 */
	public void displayPatient(Patient patient, boolean canClosePatient)
	{
		AwivViewerManager.closeAwivViewer();
		if(patient != null)
		{
			if(patientStudiesTab != null)
			{
				tabSet.removeTab(patientStudiesTab);
			}
			patientStudiesTab = new PatientStudiesTab(getAwivUserInformation(), 
					this.patientSelectedEvent, canClosePatient);
			patientStudiesTab.setStudySelectedEvent(this);
			patientStudiesTab.displayPatient(patient);
			displayTab(patientStudiesTab);
		}
		else
		{
			if(patientStudiesTab != null)
			{
				// in this case a null patient was passed (indicating a clear patient) but the patientStudiesTab is not null - shouldn't really happen but just in case
				tabSet.removeTab(patientStudiesTab);
				patientStudiesTab = null;
			}
		}
		if(debugTab != null)
			debugTab.setPatient(patient);
	}

	@Override
	public void onStudySelected(Patient patient, StudyRecord study)
	{
		StudyTab studyTab = new StudyTab();
		displayTab(studyTab);
		studyTab.displayStudy(awivUserInformation, patient, study);
	}

	public AwivUserInformation getAwivUserInformation()
	{
		return awivUserInformation;
	}

	public void setAwivUserInformation(AwivUserInformation awivUserInformation)
	{
		this.awivUserInformation = awivUserInformation;
	}

	/**
	 * Display the log
	 * @param visible
	 */
	public void displayLog(boolean visible)
	{
		if(visible)
		{
			tabSet.addTab(logTab, 0);
			tabSet.selectTab(logTab);
		}
		else
		{
			Canvas logCanvas = logTab.getPane();
			tabSet.updateTab(0, null);
			tabSet.removeTab(0);
			logTab.setPane(logCanvas);
			//tabSet.removeTab(logTab); // calling this destroys the tab
		}
	}
	
	/**
	 * Display the tab for patient site lookup. This is used by Claims users
	 */
	public void displayPatientSiteLookup()
	{
		if(patientSiteLookupTab == null)
		{
			patientSiteLookupTab = new PatientSiteLookupTab(this);
		}
		displayTab(patientSiteLookupTab);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.events.PatientSiteLookupSelectedEvent#OnPatientSiteLookupSelected(java.lang.String)
	 */
	@Override
	public void OnPatientSiteLookupSelected(AwivSite awivSite)
	{
		logger.info("Setting patient lookup site to '" + awivSite.getSiteNumber() + "'.");
		this.awivUserInformation.setPatientLookupSite(awivSite);
		//displayPatient(null); // clear the patient // don't need to call since the event will call this
		if(patientSelectedEvent != null)
			patientSelectedEvent.onPatientSelected(null, true);
		displayPatientSelectionTab(true);
	}
	
	/**
	 * Display the debug tab (experimental and currently disabled)
	 */
	public void displayDebugTab()
	{
		if(debugTab == null)
		{
			debugTab = new DebugTab();
		}
		displayTab(debugTab);
	}
}
