/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Mar 2, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Dialog;
import com.smartgwt.client.widgets.HTMLPane;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ButtonClickEvent;
import com.smartgwt.client.widgets.events.ButtonClickHandler;

import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.awiv.client.dao.PatientStudyServiceDao;
import gov.va.med.imaging.awiv.client.ui.data.StudyRecord;
import gov.va.med.imaging.awiv.client.ui.widgets.dialogs.WaitDialog;

/**
 * This is a replacement for the StudyReportViewer.  This is meant to handle all of the operations necessary
 * to display a study report including exception handling. The problem with the StudyReportWindow is that it 
 * is a user created window (which are hard to make look good) and it does not provide a 508 compliant way to close
 * the dialog
 * 
 * @author       WERFEJ
 *
 */
public class StudyReportViewer
{
	private static Logger logger = LogManager.getLogger("");
	
	public static void displayStudyReport(final StudyRecord studyRecord, final Patient patient)
	{
		
		WaitDialog.displayWaitDialog("Loading Report", "Loading study report...");
		String transactionId = UUID.uuid();
		logger.info("Retrieving study report '" + studyRecord.getStudyIdentifier() + "' with transaction Id '" + transactionId + "'.");
		PatientStudyServiceDao.patientStudyServiceDao.getStudyReport(transactionId, studyRecord.getStudyIdentifier(), new AsyncCallback<String>()
		{
			
			@Override
			public void onSuccess(String report)
			{
				WaitDialog.hideWaitDialog();
				
				if(report != null)
				{
					// the first line should be a status line, exclude that from the result
					if(report.startsWith("0"))
					{
						report = report.substring(2);
					}
					else
					{
						int loc = report.indexOf("\n");
						if(loc >= 0)
						{
							report = report.substring(loc + 1);
						}
						CharSequence newLine = new String("\n");
						CharSequence breakLine = new String("<br>");
						report = report.replace(newLine, breakLine);
					}
				}
				else
				{
					report = "";
				}
				
				report = studyRecord.getShortDescription() + "<br>" + report;
				
				//SC.say("Study Report - " + patient.getName(), report);
				displayReportDialog(patient.getName(), report);
			}
			
			@Override
			public void onFailure(Throwable arg0)
			{
				WaitDialog.hideWaitDialog();
				if(!AwivExceptionHandler.handleServiceException(arg0))
				{
					SC.warn("Error loading study report. Please try again, if this error persists contact your administrator<hr/><br><br>" + arg0.getMessage());
				}
			}
		});        
	}
	
	private static void displayReportDialog(String patientName, String report)
	{
		final Dialog dialog = new Dialog();
		
		
		dialog.setSize("50%", "65%");
		dialog.setAutoCenter(true);
		dialog.setLeaveScrollbarGap(false);
		
		dialog.setCanDragReposition(true);
		dialog.setCanDragResize(true);
		dialog.setCanSelectText(false);
		dialog.setIsModal(true);
		dialog.setDismissOnEscape(true);
		dialog.setShowTitle(true);
		dialog.setTitle("Study Report - " + patientName);
		
		dialog.setShowToolbar(true);
		dialog.setAutoFocus(true);
		dialog.addButtonClickHandler(new ButtonClickHandler()
		{
			
			@Override
			public void onButtonClick(ButtonClickEvent event)
			{
				dialog.destroy();
			}
		});
		
		dialog.setButtons(new Button("OK"));
		Label contents = new Label(report);
		dialog.addItem(contents);
		contents.setOverflow(Overflow.SCROLL);
		
		contents.setWidth100();
		contents.setHeight100();
		
		dialog.show();
	}

}
