/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 29, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.business.Patient;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.user.client.ui.Image;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.WidgetCanvas;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;

/**
 * Component for displaying the photo ID image and patient information
 * @author       WERFEJ
 *
 */
public class PhotoIdViewer
extends VLayout
{
	private Patient patient = null;
	private Label patientLabel = null;
	private Label patientSsnLabel = null;
	private Label veteranStatusLabel;
	private Label errorLabel = null;
	private Label dobLabel = null;
	private Image image = null;
	private boolean showPatientInfo = true;
	private AwivUserInformation awivUserInformation = null;
	
	private final int MAX_IMAGE_HEIGHT = 150;
	private final int MAX_IMAGE_WIDTH = 150;
	
	private static Logger logger = LogManager.getLogger("");
	
	public PhotoIdViewer()
	{		
		super(2);
		
		patientLabel = new Label();
		patientSsnLabel = new Label();
		errorLabel = new Label();
		HLayout imageLayout = new HLayout();
		
		image = new Image();
		imageLayout.setHeight(MAX_IMAGE_HEIGHT);
		
		//imageLayout.setWidth100();
		imageLayout.setWidth(MAX_IMAGE_WIDTH);
		imageLayout.setAlign(Alignment.LEFT);
		// need to put the image in a WidgetCanvas so we can set its width to 100% - was defaulting to 100px and caused problems in FireFox
		WidgetCanvas wc = new WidgetCanvas(image);
		wc.setWidth100();		
		imageLayout.addMember(wc);
		
		imageLayout.setOverflow(Overflow.VISIBLE);
		
		patientLabel.setHeight(20);
		patientLabel.setAlign(Alignment.LEFT);
		patientLabel.setPadding(2);
		errorLabel.setHeight(20);
		errorLabel.setAlign(Alignment.LEFT);
		
		patientSsnLabel = new Label();
		patientSsnLabel.setAlign(Alignment.LEFT);
		patientSsnLabel.setOverflow(Overflow.HIDDEN);
		patientSsnLabel.setHeight(20);
		
		veteranStatusLabel = new Label();
		veteranStatusLabel.setAlign(Alignment.LEFT);
		veteranStatusLabel.setOverflow(Overflow.HIDDEN);
		veteranStatusLabel.setHeight(20);
		dobLabel = new Label();
		dobLabel.setAlign(Alignment.LEFT);
		dobLabel.setOverflow(Overflow.HIDDEN);
		dobLabel.setHeight(20);
		
		this.setDefaultLayoutAlign(Alignment.LEFT);
		
		// add a handler if there is an error
		image.addErrorHandler(new ErrorHandler()
		{
			@Override
			public void onError(ErrorEvent arg0)
			{
				logger.error("Error loading photo ID image, " + arg0.toString());				
				image.setVisible(false);
				image.setAltText("No photo ID image");
				errorLabel.setVisible(true);
				errorLabel.setContents("No photo ID image");
			}
		});
		
		image.addLoadHandler(new LoadHandler()
		{			
			@Override
			public void onLoad(LoadEvent event)
			{
				Element element = event.getRelativeElement();
				if (element == image.getElement())
				{
					int originalHeight = image.getOffsetHeight();
					int originalWidth = image.getOffsetWidth();
					if (originalHeight > originalWidth)
					{
						image.setHeight(MAX_IMAGE_HEIGHT + "px");
						logger.info("Set image height to '" + MAX_IMAGE_HEIGHT + "'.");
					} 
					else
					{
						image.setWidth(MAX_IMAGE_WIDTH + "px");
						logger.info("Set image width to '" + MAX_IMAGE_WIDTH + "'.");
					}
					logger.info("Image width: "+ image.getWidth() + ", height: " + image.getHeight() + ", offset width: + " + image.getOffsetWidth() + ", offset height: " + image.getOffsetHeight());
				}
			}
		});
		
		this.addMember(patientLabel);
		this.addMember(patientSsnLabel);
		this.addMember(dobLabel);
		this.addMember(veteranStatusLabel);
		this.addMember(errorLabel);
		this.addMember(imageLayout);
		
		displayPatient();		
	}
	
	/**
	 * @return the awivUserInformation
	 */
	public AwivUserInformation getAwivUserInformation()
	{
		return awivUserInformation;
	}

	/**
	 * @param awivUserInformation the awivUserInformation to set
	 */
	public void setAwivUserInformation(AwivUserInformation awivUserInformation)
	{
		this.awivUserInformation = awivUserInformation;
	}

	public void setPatient(Patient patient)
	{
		this.patient = patient;
		clearPatient(); // hide the photo ID image before displaying the new one
		displayPatient();
	}
	
	/**
	 * display the specified patient, if the patient is null then clear the displayed patient
	 */
	private void displayPatient()
	{
		if(patient == null)
		{
			clearPatient();
		}
		else
		{
			patientLabel.setContents(patient.getName());
			patientSsnLabel.setContents(patient.getSsn());
			veteranStatusLabel.setContents(patient.getVeteranStatus());
			dobLabel.setContents(patient.getDobFormatted());
			errorLabel.setContents("");
			errorLabel.setVisible(false);
			logger.info("Loading photo ID image for patient '" + patient.getIcn() + "'.");
			image.setWidth(MAX_IMAGE_WIDTH + "px");
			image.setHeight(MAX_IMAGE_HEIGHT + "px");
			image.setUrl("/Awiv/photoid/" + getAwivUserInformation().getPatientLookupSiteNumber() + "/" + patient.getIcn());
			image.setVisible(true);
			
			//img.setSrc("/Awiv/photoid/" + patient.getIcn());
			//img.setVisible(true);
		}	
	}
	
	/**
	 * Clear the displayed patient
	 */
	private void clearPatient()
	{
		patientLabel.setContents("");
		patientSsnLabel.setContents("");
		veteranStatusLabel.setContents("");
		dobLabel.setContents("");
		errorLabel.setContents("");			
		errorLabel.setVisible(false);
		loadClearImage();
		image.setVisible(false);
		//img.setVisible(false);
	}
	
	/**
	 * To ensure the previous patient image is not displayed a blank image is loaded when clearing the displayed patient
	 */
	private void loadClearImage()
	{
		image.setUrl("/Awiv/images/blankImage.JPG");
	}

	public boolean isShowPatientInfo()
	{
		return showPatientInfo;
	}

	public void setShowPatientInfo(boolean showPatientInfo)
	{
		this.showPatientInfo = showPatientInfo;
		veteranStatusLabel.setVisible(this.showPatientInfo);
		dobLabel.setVisible(this.showPatientInfo);
		patientSsnLabel.setVisible(this.showPatientInfo);
	}
}
