/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 12, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.events.StudySelectedEvent;
import gov.va.med.imaging.awiv.client.ui.data.StudyRecord;

import com.google.gwt.user.client.Window.Location;
import com.smartgwt.client.core.KeyIdentifier;
import com.smartgwt.client.data.RecordList;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.types.SelectionStyle;
import com.smartgwt.client.types.SortDirection;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickEvent;
import com.smartgwt.client.widgets.grid.events.RecordDoubleClickHandler;
import com.smartgwt.client.widgets.menu.Menu;
import com.smartgwt.client.widgets.menu.MenuItem;
import com.smartgwt.client.widgets.menu.MenuItemSeparator;
import com.smartgwt.client.widgets.menu.events.ClickHandler;
import com.smartgwt.client.widgets.menu.events.MenuItemClickEvent;

/**
 * List grid that shows the patient studies 
 * @author       WERFEJ
 *
 */
public class PatientStudiesListGrid
extends ListGrid
{
	private Patient patient = null;
	private StudySelectedEvent studySelectedEvent = null;
	private final AwivUserInformation awivUserInformation;
	private static Logger logger = LogManager.getLogger("");
	
	public PatientStudiesListGrid(AwivUserInformation awivUserInformation)
	{
		super();
		this.awivUserInformation = awivUserInformation;
		
		this.setShowAllRecords(false);
		this.setCanGroupBy(false);
		this.setCanFreezeFields(false);
		this.setCanMultiSort(false);
		this.setSelectionType(SelectionStyle.SINGLE);
		this.setEmptyMessage("Select a site to retrieve the list of studies for the patient.");
		
		ListGridField iconField = new ListGridField("icon", " ", 30);
		iconField.setType(ListGridFieldType.IMAGE);  
		iconField.setAlign(Alignment.RIGHT);
		iconField.setCanSort(false); // doesn't make sense to sort this column
		iconField.setImageURLPrefix(Location.getProtocol() + "//" + Location.getHost() + "/Awiv/images/");
		logger.info("Setting icon URL prefix: " + Location.getProtocol() + "//" + Location.getHost() + "/Awiv/images/");
		ListGridField siteField = new ListGridField("siteAbbr", "Site", 75);		
		ListGridField dateField = new ListGridField("procedureDate", "Procedure Date", 125);
		ListGridField procedureField = new ListGridField("procedure", "Procedure", 150);
		ListGridField numberOfImagesField = new ListGridField("imageCount", "# Imgs", 70);
		ListGridField shortDescriptionField = new ListGridField("shortDescription", "Short Desc", 200);
		ListGridField packageField = new ListGridField("studyPackage", "Package", 100);
		ListGridField classField = new ListGridField("studyClass", "Class", 120);
		ListGridField typeField = new ListGridField("studyType", "Type", 200);
		ListGridField specialtyField = new ListGridField("studySpecialty", "Specialty", 150);
		
		
		this.setFields(iconField, siteField, dateField, procedureField, 
				numberOfImagesField, shortDescriptionField, packageField, classField, 
				typeField, specialtyField);
		
		// sort by date by default
		this.setSortField("procedureDate");
		this.setSortDirection(SortDirection.DESCENDING);
		
		this.addRecordDoubleClickHandler(new RecordDoubleClickHandler()
		{			
			@Override
			public void onRecordDoubleClick(RecordDoubleClickEvent event)
			{
				StudyRecord studyRecord = (StudyRecord) event.getRecord();
				displayStudy(studyRecord, false);
			}
		});		
		
		Menu contextMenu = new Menu();
		//contextMenu.setShowIcons(false); // made it harder to see the menu when right clicked
		contextMenu.setTitle("Right click"); // this isn't shown anywhere
		
		MenuItem openImageMenuItem = new MenuItem("Open Image");
		KeyIdentifier openImageKey = createKeyIdentifier(true, false, true, "O");
		openImageMenuItem.setKeys(openImageKey);
		openImageMenuItem.setKeyTitle("Ctrl+Shift+O");
		openImageMenuItem.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(MenuItemClickEvent event)
			{
				StudyRecord studyRecord = (StudyRecord)getSelectedRecord();
				if(studyRecord != null)
				{
					displayStudy(studyRecord, false);
				}
			}
		});
		
		boolean debugMode = AwivHelper.isDebugMode();
				
		MenuItem showImageInformationMenuItem = new MenuItem("Image Information");
		KeyIdentifier imageInfoKey = createKeyIdentifier(true, false, true, "F");
		showImageInformationMenuItem.setKeys(imageInfoKey);
		showImageInformationMenuItem.setKeyTitle("Ctrl+Shift+F");
		showImageInformationMenuItem.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(MenuItemClickEvent event)
			{
				StudyRecord studyRecord = (StudyRecord)getSelectedRecord();
				if(studyRecord != null)
				{
					ImageInformationWindow.displayImageInformationWindow(patient, studyRecord);
				}
				
			}
		});
		
		MenuItem showImageInformationAdvancedMenuItem = null;
		if(this.awivUserInformation.userHasKey(AwivConstants.magSystemSecurityKey))
		{
			showImageInformationAdvancedMenuItem = new MenuItem("Image Information Advanced");
			KeyIdentifier imageInfoAdvancedKey = createKeyIdentifier(true, false, true, "A");
			showImageInformationAdvancedMenuItem.setKeys(imageInfoAdvancedKey);
			showImageInformationAdvancedMenuItem.setKeyTitle("Ctrl+Shift+A");
			showImageInformationAdvancedMenuItem.addClickHandler(new ClickHandler()
			{			
				@Override
				public void onClick(MenuItemClickEvent event)
				{
					StudyRecord studyRecord = (StudyRecord)getSelectedRecord();
					if(studyRecord != null)
					{
						ImageInformationWindow.displayAdvancedImageInformationWindow(patient, studyRecord);						
					}
				}
			});
		}
		
		MenuItem showStudyReportMenuItem = new MenuItem("View Report");
		KeyIdentifier reportKey = createKeyIdentifier(true, false, true, "V");
		showStudyReportMenuItem.setKeys(reportKey);
		showStudyReportMenuItem.setKeyTitle("Ctrl+Shift+V");
		showStudyReportMenuItem.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(MenuItemClickEvent event)
			{
				StudyRecord studyRecord = (StudyRecord)getSelectedRecord();
				if(studyRecord != null)
				{
					displayStudyReport(studyRecord);
				}
			}
		});
		
		MenuItem openAlternateViewerMenuItem = new MenuItem("Open Alternate Image Viewer");
		openAlternateViewerMenuItem.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(MenuItemClickEvent event)
			{
				StudyRecord studyRecord = (StudyRecord)getSelectedRecord();
				if(studyRecord != null)
				{
					displayStudy(studyRecord, true);
				}				
			}
		});
		
		contextMenu.addItem(openImageMenuItem);
		if(debugMode)
			contextMenu.addItem(openAlternateViewerMenuItem);
		contextMenu.addItem(showStudyReportMenuItem);	
		contextMenu.addItem(new MenuItemSeparator());
		contextMenu.addItem(showImageInformationMenuItem);		
		if(showImageInformationAdvancedMenuItem != null)
		{
			contextMenu.addItem(showImageInformationAdvancedMenuItem);
		}
		
		this.setContextMenu(contextMenu);
	}
	
	private KeyIdentifier createKeyIdentifier(boolean control, boolean alt, boolean shift, String keyName)
	{
		KeyIdentifier keyIdentifier = new KeyIdentifier();
		keyIdentifier.setCtrlKey(control);
		keyIdentifier.setShiftKey(shift);
		keyIdentifier.setAltKey(alt);
		keyIdentifier.setKeyName(keyName);
		return keyIdentifier;
	}
	
	private void displayStudyReport(StudyRecord studyRecord)
	{
		StudyReportViewer.displayStudyReport(studyRecord, patient);
	}
	
	public StudySelectedEvent getStudySelectedEvent()
	{
		return studySelectedEvent;
	}

	public void setStudySelectedEvent(StudySelectedEvent studySelectedEvent)
	{
		this.studySelectedEvent = studySelectedEvent;
	}
	
	public void setPatient(Patient patient)
	{
		this.patient = patient;
	}
	
	public void addStudies(StudyRecord [] studyRecords)
	{
		RecordList recordList = getDataAsRecordList();
		recordList.addList(studyRecords);
		setData(recordList);
	}	
	
	public void removeStudies(StudyRecord [] studyRecords)
	{
		RecordList recordList = getDataAsRecordList();
		recordList.removeList(studyRecords);
		setData(recordList);
	}
	
	private void displayStudy(StudyRecord studyRecord, boolean useAlternateViewer)
	{
		if(useAlternateViewer)
		{
			if(studySelectedEvent != null)
				studySelectedEvent.onStudySelected(patient, studyRecord);			
		}
		else
		{
			AwivViewerManager.displayAwivViewer(PatientStudiesListGrid.this.awivUserInformation,
				patient, studyRecord);
		}
	}
}
