/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 25, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.awiv.business.AwivSite;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.dao.UserServiceDao;
import gov.va.med.imaging.awiv.client.events.PatientSiteLookupSelectedEvent;
import gov.va.med.imaging.awiv.client.ui.widgets.dialogs.WaitDialog;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.TitleOrientation;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tab.Tab;

/**
 * For claims user this tab allows them to select the site to do patient lookup at
 * 
 * @author vhaiswwerfej
 *
 */
public class PatientSiteLookupTab
extends Tab
implements AwivTab
{
	private final PatientSiteLookupSelectedEvent patientSiteLookupSelectedEvent;
	private SelectItem selectSites = new SelectItem();
	private static Logger logger = LogManager.getLogger("");
	private final Map<String, AwivSite> sites = new HashMap<String, AwivSite>();
	private final DynamicForm selectSitesForm = new DynamicForm();
	
	public PatientSiteLookupTab(PatientSiteLookupSelectedEvent patientSiteLookupSelectedEvent)
	{
		this.patientSiteLookupSelectedEvent = patientSiteLookupSelectedEvent;
		this.setCanClose(false);
		this.setTitle("Select Patient Lookup Site");
		
		VLayout vlayout = new VLayout();
		vlayout.setWidth100();
		vlayout.setHeight100();
		vlayout.setRedrawOnResize(false);
				
		//selectSitesForm.setWidth100();
		selectSitesForm.setTitleOrientation(TitleOrientation.LEFT);
		
		selectSites.setTitle("Select Patient Lookup Site");		
		selectSites.setWrapTitle(false);
		selectSites.setAddUnknownValues(false);
		selectSitesForm.setFields(selectSites);
		
		Label informationLabel = new Label("You are authenticated to the Claims system, please select a site to use for patient lookup.");
		informationLabel.setWidth100();
		informationLabel.setHeight(10);
		
		final IButton selectSiteButton = new IButton("OK");
		selectSiteButton.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(ClickEvent event)
			{
				Object value = selectSites.getValue();
				if(value != null)
				{
					String siteNumber = value.toString();	
					if(PatientSiteLookupTab.this.patientSiteLookupSelectedEvent != null)
					{
						logger.info("User selected site '" + siteNumber + "'.");
						AwivSite awivSite = sites.get(siteNumber);
						PatientSiteLookupTab.this.patientSiteLookupSelectedEvent.OnPatientSiteLookupSelected(awivSite);
					}
				}
			}
		});
		
		selectSiteButton.setDisabled(true);
		selectSites.addChangedHandler(new ChangedHandler()
		{
			
			@Override
			public void onChanged(ChangedEvent event)
			{
				selectSiteButton.setDisabled(false);
			}
		});
		
		HLayout hlayout = new HLayout();
		hlayout.setWidth100();
		hlayout.addMember(selectSitesForm);
		hlayout.addMember(selectSiteButton);
		
		vlayout.addMember(informationLabel);
		/*
		vlayout.addMember(selectSitesForm);
		vlayout.addMember(selectSiteButton);
		*/
		vlayout.addMember(hlayout);
		
		
		this.setPane(vlayout);
		loadSites();
	}

	private void loadSites()
	{
		WaitDialog.displayWaitDialog("Loading Sites", "Loading patient selection sites");
		String transactionId = UUID.uuid();
		logger.info("Retrieving list of patient lookup sites with transaction Id '" + transactionId + "'.");
		UserServiceDao.userServiceDao.getPatientLookupSites(transactionId, new AsyncCallback<AwivSite[]>()
		{
			
			@Override
			public void onSuccess(AwivSite[] awivSites)
			{
				WaitDialog.hideWaitDialog();
				sites.clear();
				LinkedHashMap<String, String> linkedSites = new LinkedHashMap<String, String>();
				for(AwivSite awivSite : awivSites)
				{
					sites.put(awivSite.getSiteNumber(), awivSite);
					linkedSites.put(awivSite.getSiteNumber(), awivSite.toString());
				}
				
				selectSites.setValueMap(linkedSites);
				
				Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand () {
			        public void execute () 
			        {
			        	selectSitesForm.focusInItem(selectSites);
			        }
			    });
				
			}
			
			@Override
			public void onFailure(Throwable arg0)
			{
				WaitDialog.hideWaitDialog();
				logger.error("Error loading patient lookup sites, " + arg0.getMessage());
				if(!AwivExceptionHandler.handleServiceException(arg0))
				{
					AwivHelper.displayErrorMessage("Error loading patient lookup sites", arg0);
				}
			}
		});
	}
	
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.client.ui.widgets.AwivTab#getCreationIndex()
	 */
	@Override
	public int getCreationIndex()
	{
		return 0;
	}	
}
