/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 9, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.dao.PatientLookupServiceDao;
import gov.va.med.imaging.awiv.client.events.PatientClickedEvent;
import gov.va.med.imaging.awiv.client.events.PatientSelectedEvent;
import gov.va.med.imaging.awiv.client.ui.data.PatientRecord;
import gov.va.med.imaging.awiv.client.ui.widgets.dialogs.WaitDialog;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.TitleOrientation;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.TextItem;
import com.smartgwt.client.widgets.form.fields.events.KeyPressEvent;
import com.smartgwt.client.widgets.form.fields.events.KeyPressHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tab.Tab;

/**
 * @author       WERFEJ
 *
 */
public class PatientSelectionTab
extends Tab
implements AwivTab, PatientClickedEvent
{
	private PatientSelectionListGrid patientSelectionGrid = null;//new PatientSelectionListGrid();
	private PatientSelectedEvent patientSelectedEvent;
	private PhotoIdViewer photoId = null;
	private static Logger logger = LogManager.getLogger("");
	private final IButton searchButton = new IButton("Search");
	private final AwivUserInformation awivUserInformation;
	private TextItem patientSearch;
	private DynamicForm form;
	
	public PatientSelectionTab(AwivUserInformation awivUserInformation)
	{
		super();
		this.awivUserInformation = awivUserInformation;
		patientSelectionGrid = new PatientSelectionListGrid(this.awivUserInformation);
		setCanClose(false); // can't close this one
		
		if(this.awivUserInformation.isClaimsAuthentication() && this.awivUserInformation.getPatientLookupSite() != null)
		{
			setTitle("Select Patient - " + this.awivUserInformation.getPatientLookupSite().toString());
		}
		else
		{		
			setTitle("Select Patient");
		}
		
		HLayout hlayout = new HLayout();
		hlayout.setWidth100();
		hlayout.setHeight100();
		hlayout.setRedrawOnResize(false);
		
		photoId = new PhotoIdViewer();
		photoId.setWidth(160);
		photoId.setShowPatientInfo(false);
		photoId.setAwivUserInformation(awivUserInformation);
		
		VLayout rightSideLayout = new VLayout(2);
		HLayout patientSearchLayout = new HLayout(2);
		patientSearchLayout.setHeight(10);
		patientSearchLayout.setWidth100();
		
		form = new DynamicForm();
		
		patientSearch = new TextItem();
		patientSearch.setTitle("Patient Search");
		patientSearch.setWidth("*");
		patientSearch.setRequired(true);
		
		form.setWidth("*");
		form.setFields(patientSearch);
		form.setTitleOrientation(TitleOrientation.LEFT);
		patientSelectionGrid.setEmptyMessage("Click the <b>Search</b> button to search for a patient");		
		patientSearch.addKeyPressHandler(new KeyPressHandler()
		{			
			@Override
			public void onKeyPress(KeyPressEvent event)
			{
				if(AwivConstants.enterButtonKeyName.equals(event.getKeyName()))
				{
					searchPatient(patientSearch.getValueAsString());
				}
			}
		});
		
		searchButton.addClickHandler(new ClickHandler()
		{			
			@Override
			public void onClick(ClickEvent event)
			{
				searchPatient(patientSearch.getValueAsString());				
			}
		});
		
		patientSearchLayout.addMember(form);
		patientSearchLayout.addMember(searchButton);
		
		Label patientSearchCriteriaDescription = new Label("Search by patient name (partial is OK), last initial, or full SSN (without dashes)");
		patientSearchCriteriaDescription.setWidth100();
		patientSearchCriteriaDescription.setHeight(10);
		
		Label viewPhotosOnlyWarning = new Label("WARNING: You do not have privileges to view patient images, only photo ID images");
		viewPhotosOnlyWarning.setWidth100();
		viewPhotosOnlyWarning.setStyleName("View-Photos-Only-Warning");
		viewPhotosOnlyWarning.setHeight(10);
		
		rightSideLayout.addMember(patientSearchLayout);
		rightSideLayout.addMember(patientSearchCriteriaDescription);
		rightSideLayout.addMember(patientSelectionGrid);
		
		// only add the context menu if the user is allowed to view patient images
		if(!AwivHelper.canUserViewPatients(this.awivUserInformation))
		{
			rightSideLayout.addMember(viewPhotosOnlyWarning);
		}		
		
		hlayout.addMember(photoId);
		hlayout.addMember(rightSideLayout);
				
		// set the focus on the search text box  
		setPatientSearchTextboxFocus();
		this.setPane(hlayout);
	}
	
	/**
	 * Sets the focus on the search textbox
	 */
	private void setPatientSearchTextboxFocus()
	{
		Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand () {
	        public void execute () 
	        {
	        	form.focusInItem(patientSearch);
	        }
	    });
	}
	
	/**
	 * @return the awivUserInformation
	 */
	public AwivUserInformation getAwivUserInformation()
	{
		return awivUserInformation;
	}

	private void searchPatient(final String searchText)
	{
		// if the search string is empty, do nothing (fix for TFS #45938)
		if(searchText == null || searchText.trim().length() <= 0)
			return;
		final String searchString = searchText;
		selectPatient(null); // clear the current patient (if there is one)
		photoId.setPatient(null);
		this.setIcon("busy_indicator_blu.gif");
		searchButton.setDisabled(true);
		
		String transactionId = UUID.uuid();
		logger.info("Searching for patient '" + searchString + "' at site '" + getAwivUserInformation().getPatientLookupSiteNumber() + "', with transaction Id '" + transactionId + "'.");
		WaitDialog.displayWaitDialog("Searching", "Searching for patient");
		PatientLookupServiceDao.patientLookupServiceDao.search(transactionId, getAwivUserInformation().getPatientLookupSiteNumber(), 
				searchString, new AsyncCallback<Patient[]>()
		{
			
			@Override
			public void onSuccess(Patient[] result)
			{
				WaitDialog.hideWaitDialog();
				PatientRecord []patients = new PatientRecord[result.length];
				for(int i = 0; i < patients.length; i++)
				{
					patients[i] = new PatientRecord(result[i]);
				}
				patientSelectionGrid.setPatients(patients);
				
				if(patients.length == 0)
				{
					patientSelectionGrid.setEmptyMessage("<b>NO MATCH for lookup on \"" + searchText + "\"</b>");
					setPatientSearchTextboxFocus();
				}
				else
				{					
					// give the patient list grid focus
					Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand () {
				        public void execute () 
				        {
				        	patientSelectionGrid.focus();
				        }
				    });
				}
			}
			
			@Override
			public void onFailure(Throwable caught)
			{
				WaitDialog.hideWaitDialog();
				logger.error("Error searching for patient, " + caught.getMessage());
				if(!AwivExceptionHandler.handleServiceException(caught))
				{
					AwivHelper.displayErrorMessage("Error searching for patient", caught);
				}
			}
		});
		this.setIcon(null);
		searchButton.setDisabled(false);		
	}
	
	public void addPatientSelectedHandler(PatientSelectedEvent patientSelectedEvent)
	{
		this.patientSelectedEvent = patientSelectedEvent;
		patientSelectionGrid.addPatientSelectedHandler(this.patientSelectedEvent);
		patientSelectionGrid.addPatientClickedHandler(this);
	}

	@Override
	public int getCreationIndex()
	{
		return 1;
	}

	@Override
	public void onPatientClicked(Patient patient)
	{
		photoId.setPatient(patient);	
	}
	
	public void clearResults()
	{
		patientSelectionGrid.clearResults();
	}
	
	private void selectPatient(Patient patient)
	{
		if(this.patientSelectedEvent != null)
		{
			this.patientSelectedEvent.onPatientSelected(patient, true);
		}
	}
}
