/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 9, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.business.UUID;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.UserSessionService;
import gov.va.med.imaging.awiv.client.UserSessionServiceAsync;
import gov.va.med.imaging.awiv.client.dao.UserServiceDao;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;

/**
 * @author       WERFEJ
 * 
 */
public class PatientInformationPane
extends VLayout
{

	//private static final int WEST_WIDTH = 200;
	private static final int WEST_WIDTH = 160;

	private PhotoIdViewer photoId = null;
	
	private static Logger logger = LogManager.getLogger("");

	public PatientInformationPane()
	{
		super();

		this.setWidth(WEST_WIDTH);
		//this.setBackgroundColor("#3F4C6B");
		//this.setBackgroundColor("#C3D9FF");
		this.setStyleName("PatientInformationPane");
		this.setShowResizeBar(true);
		this.setLayoutAlign(VerticalAlignment.TOP);
		this.setLayoutAlign(Alignment.CENTER);
		

		this.setDefaultLayoutAlign(Alignment.CENTER);
		this.setAlign(Alignment.CENTER);
		this.setMembersMargin(2);
		
		photoId = new PhotoIdViewer();
		photoId.setShowPatientInfo(true);
		photoId.setAlign(Alignment.CENTER);
		
		Label emptyLabel = new Label();
		emptyLabel.setHeight("*");
		
		boolean debugEnabled = AwivHelper.isDebugMode();
		IButton invalidateSession = null;
		IButton getUserInfoButton = null;
		if(debugEnabled)
		{
			invalidateSession = new IButton();
			invalidateSession.setTitle("Invalidate Session");
			invalidateSession.addClickHandler(new ClickHandler()
			{
				
				@Override
				public void onClick(ClickEvent event)
				{
					UserSessionServiceAsync userService = UserSessionService.Util
							.getInstance();
					userService.logout(new AsyncCallback<Boolean>()
					{
	
						@Override
						public void onSuccess(Boolean arg0)
						{
							Window.alert("User session invalidated.");
						}
	
						@Override
						public void onFailure(Throwable arg0)
						{
							Window.alert("Exception logging out, "
									+ arg0.getMessage());
						}
					});
	
				}
			});

			getUserInfoButton = new IButton("Get User Information");
			getUserInfoButton.addClickHandler(new ClickHandler()
			{

				@Override
				public void onClick(ClickEvent event)
				{
					UserServiceDao.userServiceDao.getUserInformation(UUID.uuid(),
						new AsyncCallback<AwivUserInformation>()
						{

							@Override
							public void onFailure(Throwable arg0)
							{
								if (!AwivExceptionHandler
										.handleServiceException(arg0))
								{
									Window.alert("Failed to get user info, "
											+ arg0.getClass().getName()
											+ "|<br>|" + arg0.getMessage());
								}
							}

							@Override
							public void onSuccess(AwivUserInformation arg0)
							{
								Window.alert("got user info...");
							}

					});
				}
			});
		}

		this.addMember(photoId);
		this.addMember(emptyLabel);
		if(debugEnabled)
		{
			if(invalidateSession != null)
				this.addMember(invalidateSession);
			if(getUserInfoButton != null)
				this.addMember(getUserInfoButton);
		}
		displayPatient(null);
	}
	
	public void setAwivUserInformation(AwivUserInformation awivUserInformation)
	{
		photoId.setAwivUserInformation(awivUserInformation);
	}
	
	public void displayPatient(Patient patient)
	{
		photoId.setPatient(patient);
		if(patient == null)
		{
			// clear patient			
		}
		else
		{
			logger.info("Displaying patient '" + (patient == null ? "<null patient>" : patient.getName()) + "'.");
		}
	}

}
