/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 3, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import java.util.logging.Logger;

import com.google.gwt.logging.client.HasWidgetsLogHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.widgets.IButton;
import com.smartgwt.client.widgets.WidgetCanvas;
import com.smartgwt.client.widgets.Window;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.TextAreaItem;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tab.Tab;

/**
 * Contains the log tab
 * 
 * @author       WERFEJ
 *
 */
public class LogTab
extends Tab
implements AwivTab
{
	private static Logger logger = Logger.getLogger("");
	private VerticalPanel vLogPanel = new VerticalPanel();
	
	@Override
	public int getCreationIndex()
	{
		return 0;
	}
	
	public LogTab()
	{
		super();
		this.setTitle("Log");
		vLogPanel.setWidth("100%");
		vLogPanel.setHeight("100%");
		
		// receive log message
		logger.addHandler(new HasWidgetsLogHandler(vLogPanel));
		
		// the contents shown in the log cannot be copied to the clipboard (for some reason) so to solve that problem
		// i created a button that allows the user to open a new dialog containing a textbox with the log contents
		// that can be copied to the clipboard.  The button title is a bit misleading since it doesn't actually
		// copy the contents to the clipboard, it just makes it possible to do it
		IButton copyToClipboardButton = new IButton("Copy to Clipboard");
		copyToClipboardButton.addClickHandler(new ClickHandler()
		{
			
			@Override
			public void onClick(ClickEvent event)
			{			
				Window w = new Window();
				w.setWidth(400);
				w.setHeight(400);
				
				w.setTitle("AWIV Log");
				w.centerInPage();
				w.setShowCloseButton(true);
				w.setShowMinimizeButton(false);
				w.setCanDragReposition(true);  
		        w.setCanDragResize(true); 
		        
		        DynamicForm dynamicForm = new DynamicForm();
		        dynamicForm.setSize("100%", "100%");
		        dynamicForm.setNumCols(1);
		        TextAreaItem textAreaItem = new TextAreaItem();
		        textAreaItem.setShowTitle(false);
		        textAreaItem.setWidth("*");
		        textAreaItem.setHeight("*");
		        textAreaItem.setValue(getLogHtml());
		        dynamicForm.setFields(textAreaItem);
		        w.addItem(dynamicForm);
		        
		        w.show();
			}
		});
		
		VLayout layout = new VLayout();
		layout.setWidth100();
		layout.setHeight100();
		layout.setCanSelectText(true);
		layout.setRedrawOnResize(false);
		layout.addMember(copyToClipboardButton);
		WidgetCanvas wc = new WidgetCanvas(vLogPanel);
		wc.setOverflow(Overflow.AUTO);
		wc.setWidth100();
		wc.setHeight100();		
		//layout.addMember(scrollPanel);
		layout.addMember(wc);
		this.setPane(layout);
		
	}
	
	private String getLogHtml()
	{
		StringBuilder sb = new StringBuilder();
		
		for(int i = 0; i < vLogPanel.getWidgetCount(); i++)
		{
			Widget widget = vLogPanel.getWidget(i);
			if(widget instanceof HTML)
			{
				HTML html = (HTML)widget;
				sb.append(html.getHTML());
				sb.append("\n");
			}
		}
		
		return sb.toString();
	}

}
