/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 4, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.client.ui.widgets;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.imaging.awiv.business.AwivStudy;
import gov.va.med.imaging.awiv.business.AwivUserInformation;
import gov.va.med.imaging.awiv.business.Patient;
import gov.va.med.imaging.awiv.client.AwivHelper;
import gov.va.med.imaging.awiv.client.events.BooleanResultEvent;
import gov.va.med.imaging.awiv.client.ui.data.StudyRecord;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Cookies;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;

/**
 * This class contains helper methods used by the AWIV client
 * 
 * @author       WERFEJ
 *
 */
public class AwivViewerManager
{
	private static AwivPopupWindow awivPopupWindow = null;
	private static Logger logger = LogManager.getLogger(AwivViewerManager.class);
	
	/**
	 * If the AWIV popup window exists give it focus
	 */
	public static void bringAwivToFront()
	{
		if(awivPopupWindow != null)
		{
			awivPopupWindow.focusWindow();
		}
	}
	
	/**
	 * Close the AWIV (if it is open). If the AWIV is not open then calling this method does nothing
	 */
	public static void closeAwivViewer()
	{
		if(awivPopupWindow != null)
		{
			logger.info("Closing AWIV Window");
			awivPopupWindow.closeWindow();
			awivPopupWindow = null;
			logger.info("Closed AWIV Window");
		}
	}
	
	/**
	 * Display the specified study in the AWIV component
	 * 
	 * @param awivUserInformation
	 * @param patient
	 * @param studyRecord
	 */
	public static void displayAwivViewer(final AwivUserInformation awivUserInformation, 
			final Patient patient, final StudyRecord studyRecord)
	{		
		canUserViewStudy(awivUserInformation, studyRecord, new BooleanResultEvent()
		{
			
			@Override
			public void onBooleanResult(boolean value)
			{
				if(value)
				{
					if(AwivHelper.isBrowserIE() || !awivUserInformation.getAwivServerInformation().isIeOnly())
					{
						String url = "/Awiv/AWIVViewer.jsp";/*?identifierSiteNumber=" + studyRecord.getSiteNumber() + "&patientIcn=" + studyRecord.getPatientIcn() + 
						"&patientName=" + patient.getName() + "&identifier=" + studyRecord.getStudyIdentifier() +					
						"&patientSsn=" + (patient == null ? "" : patient.getSsn()) +				
						"&viewType=" + getViewType(studyRecord.getAwivStudy()) + "&hasNcatKey=" + (userHasNcatKey(awivUserInformation) == true ? "Y" : "N") + 
						"&patientLookupSite=" + awivUserInformation.getPatientLookupSiteNumber();
						*/
						setAwivParameterCookies(awivUserInformation, patient, studyRecord);
						
						// JMW 7/27/2012 fix to allow the AWIV component to be resized and maximized (TFS #48179)
						String features = "location=no,status=yes,center=yes,dialogHeight=500px,dialogWidth=600px,help=no,resizable=1,toolbar=0";
						closeAwivViewer();
						
						logger.log(Level.INFO, "Opening AWIV Window");
						JavaScriptObject javaScriptObject = JavaScriptMethods.newWindow(url, "awivDialog", features);
						awivPopupWindow = javaScriptObject.cast();
					}
					else
					{
						AwivHelper.displayUnsupportedBrowserWarning();
					}
				}
				// error message for not being able to view study is handled in canUserViewStudy() method		
			}
		});
	}
	
	private static void setAwivParameterCookies(AwivUserInformation awivUserInformation, Patient patient, StudyRecord studyRecord)
	{
		StringBuilder cookieValue = new StringBuilder();		
		cookieValue.append(patient.getIcn()); // 0
		cookieValue.append(AwivConstants.awivParametersDelimiter);
		cookieValue.append(patient.getName()); // 1
		cookieValue.append(AwivConstants.awivParametersDelimiter);
		cookieValue.append(patient.getSsn()); // 2
		cookieValue.append(AwivConstants.awivParametersDelimiter);
		cookieValue.append(studyRecord.getStudyIdentifier()); // 3
		cookieValue.append(AwivConstants.awivParametersDelimiter);
		cookieValue.append(getViewType(studyRecord.getAwivStudy())); // 4
		cookieValue.append(AwivConstants.awivParametersDelimiter);
		cookieValue.append(studyRecord.getSiteNumber()); // 5
		cookieValue.append(AwivConstants.awivParametersDelimiter);
		cookieValue.append((userHasNcatKey(awivUserInformation) == true ? "Y" : "N")); // 6
		cookieValue.append(AwivConstants.awivParametersDelimiter);
		cookieValue.append(awivUserInformation.getPatientLookupSiteNumber()); // 7
		cookieValue.append(AwivConstants.awivParametersDelimiter);
		cookieValue.append((userHasMagRoiKey(awivUserInformation) == true ? "Y" : "N")); // 8
		
		logger.info("Cookie value: " + cookieValue.toString());
		
		Cookies.setCookie(AwivConstants.awivParametersCookie, cookieValue.toString());
	}
	
	private static String getViewType(AwivStudy awivStudy)
	{
		return awivStudy.isDodArtifact() == true ? "VIDOD" : "VI";
	}
	
	private static boolean userHasNcatKey(AwivUserInformation awivUserInformation)
	{
		return awivUserInformation.userHasKey(AwivConstants.magReviewNcatSecurityKey);
	}
	
	private static boolean userHasMagRoiKey(AwivUserInformation awivUserInformation)
	{
		return awivUserInformation.userHasKey(AwivConstants.magRoiSecurityKey);
	}
	
	/**
	 * Checks to see if the user can view the study (based on their security keys)
	 * 
	 * @param awivUserInformation
	 * @param studyRecord
	 * @return
	 */
	private static void canUserViewStudy(final AwivUserInformation awivUserInformation, final StudyRecord studyRecord, 
			final BooleanResultEvent booleanResult)
	{
		// in order to support asking the user if they want to view blocked images (if they are allowed) I needed to change this method to not return value but use an event
		
		// claims users can view everything regardless of the status of the study (based on conversations with Pam Heller)
		if(AwivConstants.claimsServerSiteNumber.equals(awivUserInformation.getSiteNumber()))
		{
			booleanResult.onBooleanResult(true);
			return;
		}
		
		if(!studyRecord.getAwivStudy().isStudyViewable())
		{
			logger.info("Study '" + studyRecord.getStudyIdentifier() + "' has a non-viewable status.");
			if((studyRecord.getAwivStudy().getStudyViewStatus().getStudyStatus() == AwivConstants.objectStatusNeedsReview) && 
					(AwivHelper.canUserViewNeedsReviewStudies(awivUserInformation)))
			{				
				// special case for Needs Review studies
				logger.info("Study '" + studyRecord.getStudyIdentifier() + "' has a need-review status and user can override and view study if they choose.");
				StringBuilder message = new StringBuilder();
				message.append("Status is: ");
				message.append(studyRecord.getAwivStudy().getStudyViewStatus().getStudyStatusDescription());
				message.append("<br><br>");
				message.append("Do you want to override and view the image?");
				SC.ask("Non Viewable Image", message.toString(),
						new BooleanCallback()
				{
					
					@Override
					public void execute(Boolean value)
					{
						if(value == null || !value.booleanValue())							
						{
							logger.info("User declined to view study '" + studyRecord.getStudyIdentifier() + "'.");
							booleanResult.onBooleanResult(false);
							return;
						}
						else
						{
							canUserViewStudyClass(awivUserInformation, studyRecord, booleanResult);
						}
					}
				});				
			}			
			else
			{
				// study is not viewable and user cannot override the non-viewable status
				SC.say("Non Viewable Image","Status is: " + studyRecord.getAwivStudy().getStudyViewStatus().getStudyStatusDescription());
				booleanResult.onBooleanResult(false);
			}
		}		
		else
		{
			// study has viewable status, check study class
			canUserViewStudyClass(awivUserInformation, studyRecord, booleanResult);
		}
	}	
	
	private static void canUserViewStudyClass(AwivUserInformation awivUserInformation, StudyRecord studyRecord, 
			final BooleanResultEvent booleanResult)
	{
		String studyClass = studyRecord.getStudyClass();
		if((studyClass.contains(AwivConstants.clinStudyClass) && awivUserInformation.userHasKey(AwivConstants.magDispClinSecurityKey)) ||
			(studyClass.contains(AwivConstants.adminStudyClass) && awivUserInformation.userHasKey(AwivConstants.magDispAdminSecurityKey)))
		{
			booleanResult.onBooleanResult(true);
			return;
		}
		else if((!studyClass.contains(AwivConstants.clinStudyClass)) && (!studyClass.contains(AwivConstants.adminStudyClass)))
		{
			// not a CLIN or ADMIN image - probably from the DoD, allow the user to view the image regardless of their keys
			booleanResult.onBooleanResult(true);
			return;
		}
		AwivHelper.displayUnallowedToViewStudyWarning();
		booleanResult.onBooleanResult(false);
	}
	
	/*
	private static void canUserViewStudyPartDuex(AwivUserInformation awivUserInformation, StudyRecord studyRecord, 
			final BooleanResultEvent booleanResult)
	{
		if(!studyRecord.getAwivStudy().isStudyViewable())
		{
			SC.say("Non Viewable Image","Status is: " + studyRecord.getAwivStudy().getStudyViewStatus().getStudyStatusDescription());
			booleanResult.onBooleanResult(false);		
		}
		
		String studyClass = studyRecord.getStudyClass();
		if((studyClass.contains(AwivConstants.clinStudyClass) && awivUserInformation.userHasKey(AwivConstants.magDispClinSecurityKey)) ||
			(studyClass.contains(AwivConstants.adminStudyClass) && awivUserInformation.userHasKey(AwivConstants.magDispAdminSecurityKey)))
		{
			booleanResult.onBooleanResult(true);
		}
		else if((!studyClass.contains(AwivConstants.clinStudyClass)) && (!studyClass.contains(AwivConstants.adminStudyClass)))
		{
			// not a CLIN or ADMIN image - probably from the DoD, allow the user to view the image regardless of their keys
			booleanResult.onBooleanResult(true);
		}
		AwivHelper.displayUnallowedToViewStudyWarning();
		booleanResult.onBooleanResult(false);
	}*/
	
	/**
	 * This class represents the AWIV Control Popup window
	 * @author       WERFEJ
	 *
	 */
	static class AwivPopupWindow extends JavaScriptObject
	{
		protected AwivPopupWindow() {}
		
		public final native void closeWindow() /*-{this.close();}-*/;
		
		public final native void focusWindow() /*-{this.focus();}-*/;
		
	}
}
