/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: May 20, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.webservices;

import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.CprsIdentifier;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.awiv.AWIVContext;
import gov.va.med.imaging.awiv.AWIVRouter;
import gov.va.med.imaging.awiv.translator.AWIVTranslatorV1;
import gov.va.med.imaging.awiv.webservices.soap.v1.GroupType;
import gov.va.med.imaging.awiv.webservices.soap.v1.UserCredentialsType;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.Requestor.PurposeOfUse;
import gov.va.med.imaging.exchange.enums.SiteConnectivityStatus;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;

import java.rmi.RemoteException;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
/**
 * @author vhaiswwerfej
 *
 */
public class AWIVWebServices 
implements gov.va.med.imaging.awiv.webservices.soap.v1.ImageAWIVMetadata
{
	
	
	private final static Logger logger = LogManager.getLogger(AWIVWebServices.class);
	
	private final static AWIVTranslatorV1 awivTranslator = new AWIVTranslatorV1();

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.soap.v1.ImageAWIVMetadata#getImageList(java.lang.String, gov.va.med.imaging.awiv.webservices.soap.v1.UserCredentials, java.lang.String, java.lang.String, java.lang.String)
	 */
	public gov.va.med.imaging.awiv.webservices.soap.v1.GroupType getImageList(String transactionId, 
			gov.va.med.imaging.awiv.webservices.soap.v1.UserCredentialsType credentials, 
			String siteId, String patientIcn, String cprsIdentifier) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		Long startTime = System.currentTimeMillis();
		logger.info("start AWIV getImageListFromCprs transaction(" + transactionId + ")" );
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getImageList");
		transactionContext.setPatientID(patientIcn);
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		
		AWIVRouter router = AWIVContext.getRouter();
		logger.debug("getImageList getting patient studies list from " + router.getClass().getName() + 
				" type manager instance.");
		gov.va.med.imaging.awiv.webservices.soap.v1.GroupType result = null;
		
		try 	
		{
			List<Study> studies = router.getStudiesByCprsIdentifier(patientIcn, 
					RoutingTokenHelper.createSiteAppropriateRoutingToken(siteId), 
					new CprsIdentifier(cprsIdentifier));
			
			logger.info("Got '" + (studies == null ? "null" : studies.size()) + "' studies from Router for CprsIdentifier '" + cprsIdentifier + "'.");			
			result = awivTranslator.translateStudiesToGroupType(studies);
			logger.info("Translated studies result into group containing '" + (result == null ? "<null>"  : result.getImageCount()) + "' images.");
			transactionContext.setEntriesReturned( result == null ? 0 : result.getImageCount().intValue() );
		}
		catch(MethodException mX)
		{
			logger.error("FAILED getImageList method Exception: " + mX.toString() + " ms", mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", mX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getImageList connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(URNFormatException iurnfX)
		{
			logger.error("FAILED getImageList transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", iurnfX);
		}	
		catch(Exception ex)
		{
			logger.error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		logger.info("complete AWIV getImageList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms)" );
        return result;
	}


	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.soap.v1.ImageAWIVMetadata#postImageAccessEvent(java.lang.String, gov.va.med.imaging.awiv.webservices.soap.v1.ImageAccessLogEventType)
	 */
	public boolean postImageAccessEvent(String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v1.ImageAccessLogEventType logEvent) 
	throws RemoteException 
	{
		setTransactionContext(logEvent.getCredentials(), transactionId);
		TransactionContext transactionContext = TransactionContextFactory.get();
    	long startTime = System.currentTimeMillis();
		logger.info("start AWIV postImageAccessEvent transaction(" + transactionId + ")" );
		logger.info("logEvent image [" + logEvent.getId() + "].");
		try
		{
			transactionContext.setRequestType(getWepAppName() + " postImageAccessEvent [" + logEvent.getEventType() + "]");
			transactionContext.setQueryFilter("n/a");
			transactionContext.setQuality("n/a");
			// need to use the Id from the webservice log event since it is the full URN and not just 
			// the individual image identifier
			transactionContext.setUrn(logEvent.getId());
			ImageAccessLogEvent event = awivTranslator.transformLogEvent(logEvent);
			transactionContext.setPatientID(event.getPatientIcn());
			AWIVRouter rtr = AWIVContext.getRouter(); 
			rtr.logImageAccessEvent(event);
		}
		catch(URNFormatException iurnfX) {
			logger.info("FAILED postImageAccessEvent transaction (" + transactionId + "), unable to translate image Id", iurnfX);
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate image Id", iurnfX);
		} 
		catch(Exception ex)
		{
			logger.error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		logger.info("complete AWIV postImageAccessEvent transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
		return true;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.soap.v1.ImageAWIVMetadata#pingServerEvent(java.lang.String, gov.va.med.imaging.awiv.webservices.soap.v1.UserCredentials, java.lang.String, java.lang.String)
	 */
	public gov.va.med.imaging.awiv.webservices.soap.v1.PingServerTypePingResponse pingServerEvent(
			String transactionId,
			gov.va.med.imaging.awiv.webservices.soap.v1.UserCredentialsType credentials, 
			String clientWorkstation, String requestSiteNumber) 
	throws RemoteException 
	{
		setTransactionContext(credentials, transactionId);
		logger.info("pingServerEvent from [" + clientWorkstation + "] going to site number [" + requestSiteNumber + "]");
    	
		gov.va.med.imaging.awiv.webservices.soap.v1.PingServerTypePingResponse response = 
			gov.va.med.imaging.awiv.webservices.soap.v1.PingServerTypePingResponse.SERVER_UNAVAILABLE;
		
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " pingServer to (" + requestSiteNumber + ")");
		transactionContext.setQueryFilter("n/a");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn("n/a");
		
		AWIVRouter rtr = AWIVContext.getRouter(); 
		try
		{
			SiteConnectivityStatus siteStatus = rtr.isSiteAvailable(RoutingTokenHelper.createSiteAppropriateRoutingToken(requestSiteNumber));			
			response = awivTranslator.transformServerStatusToPingServerResponse(siteStatus);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED pingServerEvent connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(MethodException cX)
		{
			logger.error("FAILED pingServerEvent connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch (RoutingTokenFormatException rtfX)
		{
			logger.error("FAILED pingServerEvent connection Exception: " + rtfX.toString() + " ms", rtfX );
			transactionContext.setErrorMessage(rtfX.getMessage());
			transactionContext.setExceptionClassName(rtfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", rtfX);
		}
		catch(Exception ex)
		{
			logger.error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		
		return response;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.soap.v1.ImageAWIVMetadata#getStudy(java.lang.String, gov.va.med.imaging.awiv.webservices.soap.v1.UserCredentialsType, java.lang.String)
	 */
	@Override
	public GroupType getStudy(String transactionId,
			UserCredentialsType userCredentials, String studyUrnAsString)
	throws RemoteException 
	{
		setTransactionContext(userCredentials, transactionId);
		Long startTime = System.currentTimeMillis();
		logger.info("start AWIV getStudy transaction(" + transactionId + ")" );
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getStudy");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn(studyUrnAsString);
		
		AWIVRouter router = AWIVContext.getRouter();
		logger.debug("getStudy getting study from " + router.getClass().getName() + 
				" type manager instance.");
		gov.va.med.imaging.awiv.webservices.soap.v1.GroupType result = null;
		
		try 	
		{
			StudyURN studyUrn = URNFactory.create(studyUrnAsString, SERIALIZATION_FORMAT.CDTP, StudyURN.class);
			transactionContext.setPatientID(studyUrn.getPatientId());
			
			Study study = router.getPatientStudy(studyUrn);			
			
			// update the transaction context with the study count
			transactionContext.setEntriesReturned( study == null ? 0 : study.getImageCount() );
			logger.debug("getStudy transforming results from business objects.");
			result = awivTranslator.translateStudyToGroupType(study);
		}
		catch(MethodException mX)
		{
			logger.error("FAILED getStudy method Exception: " + mX.toString() + " ms", mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", mX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getStudy connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(URNFormatException iurnfX)
		{
			logger.error("FAILED getStudy transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", iurnfX);
		}	
		catch(Exception ex)
		{
			logger.error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
		logger.info("complete AWIV getImageList transaction(" + transactionId + ") in " + 
				(System.currentTimeMillis() - startTime) + 	" ms)" );
        return result;
	}


	/* (non-Javadoc)
	 * @see gov.va.med.imaging.awiv.webservices.soap.v1.ImageAWIVMetadata#getStudyReport(java.lang.String, gov.va.med.imaging.awiv.webservices.soap.v1.UserCredentialsType, java.lang.String)
	 */
	@Override
	public String getStudyReport(String transactionId,
			UserCredentialsType userCredentials, String studyId)
	throws RemoteException 
	{
		setTransactionContext(userCredentials, transactionId);
		Long startTime = System.currentTimeMillis();
		logger.info("start AWIV getStudyReport transaction(" + transactionId + ")" );
		TransactionContext transactionContext = TransactionContextFactory.get();
		transactionContext.setRequestType(getWepAppName() + " getStudyReport");
		transactionContext.setQuality("n/a");
		transactionContext.setUrn(studyId);
		
		AWIVRouter router = AWIVContext.getRouter();
		logger.debug("getStudyReport getting study from " + router.getClass().getName() + 
				" type manager instance.");
		String response = null;
		try 	
		{
			StudyURN studyUrn = URNFactory.create(studyId, 
					SERIALIZATION_FORMAT.CDTP, StudyURN.class);
			transactionContext.setPatientID(studyUrn.getPatientId());
			
			Study study = router.getPatientStudy(studyUrn);
			if(study != null)
				response = study.getRadiologyReport(); 
			logger.info("complete AWIV getStudyReport transaction(" + transactionId + ") in " + (System.currentTimeMillis() - startTime) + " ms" );
			return response;
		}
		catch(MethodException mX)
		{
			logger.error("FAILED getStudy method Exception: " + mX.toString() + " ms", mX );
			transactionContext.setErrorMessage(mX.getMessage());
			transactionContext.setExceptionClassName(mX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", mX);
		}
		catch(ConnectionException cX)
		{
			logger.error("FAILED getStudy connection Exception: " + cX.toString() + " ms", cX );
			transactionContext.setErrorMessage(cX.getMessage());
			transactionContext.setExceptionClassName(cX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to retrieve patient studies", cX);
		}
		catch(URNFormatException iurnfX)
		{
			logger.error("FAILED getStudy transaction(" + transactionId, iurnfX );
			transactionContext.setErrorMessage(iurnfX.getMessage());
			transactionContext.setExceptionClassName(iurnfX.getClass().getSimpleName());
			throw new RemoteException("Internal error, unable to translate study metadata", iurnfX);
		}	
		catch(Exception ex)
		{
			logger.error("Generic exception: " + ex.getMessage(), ex);
			transactionContext.setErrorMessage(ex.toString());
			transactionContext.setExceptionClassName(ex.getClass().getSimpleName());
			throw new RemoteException("Internal error, generic exception", ex);
		}
	}


	private void setTransactionContext(
			gov.va.med.imaging.awiv.webservices.soap.v1.UserCredentialsType credentials,
			String transactionId)
	{
		logger.info(
				"setTransactionContext, id='" + transactionId + 
				"', username='" + credentials == null || credentials.getFullname() == null ? "null" : credentials.getFullname() + 
				"'.");
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		if(transactionId != null)
			transactionContext.setTransactionId(transactionId);
		
		if(credentials != null)
		{
			if( credentials.getFullname() != null )
				transactionContext.setFullName(credentials.getFullname());
			if( credentials.getSiteNumber() != null )
				transactionContext.setSiteNumber(credentials.getSiteNumber());
			if( credentials.getSiteName() != null )
				transactionContext.setSiteName(credentials.getSiteName());
			if( credentials.getSsn() != null )
				transactionContext.setSsn(credentials.getSsn());
			if(credentials.getDuz() != null)
				transactionContext.setDuz(credentials.getDuz());
			if(credentials.getSecurityToken() != null)
				transactionContext.setBrokerSecurityToken(credentials.getSecurityToken());
			transactionContext.setPurposeOfUse(PurposeOfUse.routineMedicalCare.getDescription());
		}		
	}
	
	private String getWepAppName()
	{
		return "AWIV WebApp V1";
	}
}
