/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Dec 15, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.translator;

import gov.va.med.PatientArtifactIdentifierImpl;
import gov.va.med.RoutingToken;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URN;
import gov.va.med.URNFactory;
import gov.va.med.WellKnownOID;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.awiv.configuration.AWIVWebAppConfiguration;
import gov.va.med.imaging.awiv.webservices.soap.v2.ElectronicSignatureResultType;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.ImageAccessLogEvent.ImageAccessLogEventType;
import gov.va.med.imaging.exchange.ImagingLogEvent;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.business.ElectronicSignatureResult;
import gov.va.med.imaging.exchange.business.Image;
import gov.va.med.imaging.exchange.business.ImageAccessReason;
import gov.va.med.imaging.exchange.business.Series;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.annotations.ImageAnnotation;
import gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails;
import gov.va.med.imaging.exchange.business.annotations.ImageAnnotationSource;
import gov.va.med.imaging.exchange.business.annotations.ImageAnnotationUser;
import gov.va.med.imaging.exchange.business.documents.Document;
import gov.va.med.imaging.exchange.business.documents.DocumentSet;
import gov.va.med.imaging.exchange.business.documents.DocumentSetResult;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;
import gov.va.med.imaging.exchange.enums.ImageAccessReasonType;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import gov.va.med.imaging.exchange.enums.ObjectStatus;
import gov.va.med.imaging.exchange.enums.SiteConnectivityStatus;
import gov.va.med.imaging.exchange.enums.VistaImageType;
import gov.va.med.imaging.translator.AbstractClinicalTranslator;
import gov.va.med.imaging.webservices.clinical.ClinicalContentTypeConfig;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
/**
 * @author       WERFEJ
 *
 */
public class AWIVTranslatorV2
extends AbstractClinicalTranslator
{
	private final static Logger logger = LogManager.getLogger(AWIVTranslatorV2.class);
	
	private final static String awivWebserviceShortDateFormat = "MM/dd/yyyy";
	private final static String awivWebserviceLongDateFormat = "MM/dd/yyyy HH:mm";
	
	private static Map<ImageAnnotationSource, gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationTypeSource> annotationSourceMap;
	private static Map<ImageAccessReasonType, gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType> imageAccessReasonsMap;
	
	static
	{		
		annotationSourceMap = 
			new HashMap<ImageAnnotationSource, gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationTypeSource>();
		annotationSourceMap.put(ImageAnnotationSource.clinicalDisplay, 
				gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationTypeSource.ClinicalDisplay);
		annotationSourceMap.put(ImageAnnotationSource.vistaRad, 
				gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationTypeSource.VistARad);
		annotationSourceMap.put(ImageAnnotationSource.clinicalCapture, 
				gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationTypeSource.ClinicalCapture);
		
		imageAccessReasonsMap = 
			new HashMap<ImageAccessReasonType, gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType>();
		imageAccessReasonsMap.put(ImageAccessReasonType.changingImageStatus, 
				gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType.CHANGE_IMAGE_STATUS);
		imageAccessReasonsMap.put(ImageAccessReasonType.copyImage, 
				gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType.COPY_IMAGE);
		imageAccessReasonsMap.put(ImageAccessReasonType.deleteImage, 
				gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType.DELETE_IMAGE);
		imageAccessReasonsMap.put(ImageAccessReasonType.printImage, 
				gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType.PRINT_IMAGE);
		
	}	
	
	private static DateFormat getAWIVWebserviceShortDateFormat()
	{
		return new SimpleDateFormat(awivWebserviceShortDateFormat);
	}
	
	private static DateFormat getAWIVWebserviceLongDateFormat()
	{
		return new SimpleDateFormat(awivWebserviceLongDateFormat);
	}
	
	public static gov.va.med.imaging.awiv.webservices.soap.v2.GroupType translate(List<Study> studies)
	throws URNFormatException
	{
		if(studies == null)
			return new gov.va.med.imaging.awiv.webservices.soap.v2.GroupType();
		Study study = studies.get(0);
		gov.va.med.imaging.awiv.webservices.soap.v2.GroupType result = translate(study, false);// createGroupFromStudy(study);
		List<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType> images = 
			new ArrayList<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType>();
		images.addAll(translateImages(study));
		for(int i = 1; i < studies.size(); i++)
		{
			study = studies.get(i);
			images.addAll(translateImages(study));
		}
		result.setImages(new gov.va.med.imaging.awiv.webservices.soap.v2.ImagesType(images.toArray(new gov.va.med.imaging.awiv.webservices.soap.v2.ImageType[images.size()])));
		result.setImageCount(BigInteger.valueOf(images.size()));
		return result;
	}
	
	/*
	@SuppressWarnings("deprecation")
	private static gov.va.med.imaging.awiv.webservices.soap.v2.GroupType createGroupFromStudy(Study study)
	throws URNFormatException
	{
		gov.va.med.imaging.awiv.webservices.soap.v2.GroupType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.GroupType();
		
		result.setDescription(extractIllegalCharacters(study.getDescription()));
		result.setEvent(extractIllegalCharacters(study.getEvent()));
		//result.setImageCount(BigInteger.valueOf(study.getImageCount()));
		result.setImagePackage(extractIllegalCharacters(study.getImagePackage()));
		result.setImageType(study.getImageType());
		result.setNoteTitle(extractIllegalCharacters(study.getNoteTitle()));
		result.setOrigin(extractIllegalCharacters(study.getOrigin()));
		result.setPatientIcn(study.getPatientIcn());
		result.setPatientName(study.getPatientName());
		result.setProcedure(extractIllegalCharacters(study.getProcedure()));
		result.setSiteNumber(study.getSiteNumber());
		result.setSpecialty(extractIllegalCharacters(study.getSpecialty()));
		
		// 2/19/08 - now include the site name so the Display client shows what specific DOD facility the study is from
		if(ExchangeUtil.isSiteDOD(study.getSiteNumber()))
		{
			result.setSiteAbbreviation(study.getSiteAbbr()+ (study.getSiteName() != null ? "-" + study.getSiteName() : ""));			
		}
		else
		{
			result.setSiteAbbreviation(study.getSiteAbbr());
		}				
		result.setStudyPackage(extractIllegalCharacters(study.getImagePackage()));
		result.setStudyClass(extractIllegalCharacters(study.getStudyClass() == null ? "" : study.getStudyClass())); // get this from study
		result.setStudyType(extractIllegalCharacters(study.getImageType()));
		result.setCaptureDate(study.getCaptureDate());
		result.setCapturedBy(study.getCaptureBy());		
		if(study.getProcedureDate() == null)
		{
			logger.warn("Setting null procedure date for study");
			result.setProcedureDate("");
		}
		else
		{
			if((study.getProcedureDateString() == null) || (study.getProcedureDateString().length() <= 0))
			{
				// if the hour and minute are not 0, then likely they contain real values for hour and minute (not 00:00)
				// this leaves open the possibility of invalid data, if the real date was at 00:00 then this would not show that time.
				// we would then omit data, not show invalid data
				if((study.getProcedureDate().getHours() <= 0) && (study.getProcedureDate().getMinutes() <= 0))
				{
					result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(study.getProcedureDate()));
				}
				else
				{
					result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(study.getProcedureDate()));
				}
				
			}
			else if(study.getProcedureDateString().length() > 10)
			{
				result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(study.getProcedureDate()));
			}
			else {
				result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(study.getProcedureDate()));
			}
		}		
		// need to add site number field
		
		StudyURN studyUrn = study.getStudyUrn();// StudyURN.create(study.getSiteNumber(), study.getStudyIen(), study.getPatientIcn());
		result.setStudyUrn(studyUrn.toStringCDTP());		
		return result;
	}*/
	
	private static List<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType> translateImages(Study study)
	throws URNFormatException
	{
		List<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType> images = 
			new ArrayList<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType>();
		for(Series series : study.getSeries())
		{
			for(Image image : series)
			{
				gov.va.med.imaging.awiv.webservices.soap.v2.ImageType it = transformImageToFatImage(image, series);
				if(it != null)
					images.add(it);
			}				 
		}
		return images;
	}
	
	public static gov.va.med.imaging.awiv.webservices.soap.v2.GroupType translate(DocumentSetResult documentSetResult)
	{
		gov.va.med.imaging.awiv.webservices.soap.v2.GroupType result =
			new gov.va.med.imaging.awiv.webservices.soap.v2.GroupType();
		
		int imageCount = 0;
		result.setCaptureDate("");
		result.setCapturedBy("");
		result.setDescription("");
		result.setDocumentDate("");
		result.setEvent("");
		result.setImagePackage("");
		result.setImageType("");
		result.setNoteTitle("");
		result.setOrigin("");
		result.setPatientIcn("");
		result.setPatientName("");
		result.setProcedure("");
		result.setProcedureDate("");
		result.setSensitive(false);
		result.setSiteAbbreviation("DoD");
		result.setSiteNumber(ExchangeUtil.getDodSiteNumber());
		result.setSpecialty("");
		result.setStatus(ObjectStatus.NO_STATUS.getValue() + "");		
		result.setSensitive(false);
		result.setStudyClass("");
		result.setStudyImagesHaveAnnotations(false);
		result.setStudyPackage("");
		result.setStudyType("");
		result.setStudyUrn("");
		result.setViewStatus(ObjectStatus.NO_STATUS.getValue() + "");
		
		if(documentSetResult != null && documentSetResult.getArtifacts() != null)
		{
			List<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType> images = 
				new ArrayList<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType>();			
			List<DocumentSetDocument> allDocuments = new ArrayList<DocumentSetDocument>();
			for(DocumentSet documentSet : documentSetResult.getArtifacts())
			{
				for(Document document : documentSet)
				{
					allDocuments.add(new DocumentSetDocument(documentSet, document));
				}
			}
			Collections.sort(allDocuments, new DocumentSetDocumentComparator(false));
			for(DocumentSetDocument documentSetDocument : allDocuments)
			{
				gov.va.med.imaging.awiv.webservices.soap.v2.ImageType imageType = 
					translate(documentSetDocument.getDocumentSet(), documentSetDocument.getDocument());
				if(imageType != null)
				{
					images.add(imageType);
					imageCount++;
				}
			}
			
			result.setImages(
					new gov.va.med.imaging.awiv.webservices.soap.v2.ImagesType(images.toArray(
							new gov.va.med.imaging.awiv.webservices.soap.v2.ImageType[images.size()])));
		}
		result.setImageCount(BigInteger.valueOf(imageCount));
		
		return result;
	}
	
	private static gov.va.med.imaging.awiv.webservices.soap.v2.ImageType translate(DocumentSet documentSet,
			Document document) 
	{
		if(document == null)
			return null;
		gov.va.med.imaging.awiv.webservices.soap.v2.ImageType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.ImageType();
		
		VistaImageType vistaImageType = getImageType(AWIVWebAppConfiguration.getConfiguration(), document);
		if(vistaImageType == null)
		{
			vistaImageType = VistaImageType.UNKNOWN_IMAGING_TYPE;
			logger.debug("Document with media type '" + document.getMediaType() + "', returning VistaImageType of '" + vistaImageType + "' for Clinical Display.");						
		}		
		String id = document.getGlobalArtifactIdentifier().toString(SERIALIZATION_FORMAT.CDTP);
		result.setImageUrn(id);
		result.setPatientIcn(document.getPatientId());
		result.setPatientName(documentSet.getPatientName());
		Date procedureDate = null;
		if(documentSet.getProcedureDate() != null)
		{
			procedureDate = documentSet.getProcedureDate();
		}
		else
		{
			if(document.getCreationDate() != null)
			{
				procedureDate = document.getCreationDate();
				logger.debug("DocumentSet ProcedureDate is null, using Document CreationDate");
			}
			else
			{
				logger.debug("DocumentSet ProcedureDate and Document CreationDate are both null.");
			}					
		}
		if(procedureDate == null)
		{
			result.setProcedureDate("");
		}
		else
		{
			result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(procedureDate));
		}
		
		String procedure = document.getName();
		if(vistaImageType == VistaImageType.NCAT)
		{
			// NCAT reports don't have a name value
			procedure = "NCAT Report";
		}
		
		//result.setProcedure(procedure);
		result.setProcedure("");
		result.setDescription(procedure);
		result.setImageType(BigInteger.valueOf(vistaImageType.getImageType()));
		result.setStatus(ObjectStatus.NO_STATUS.getValue() + "");
		result.setViewStatus(ObjectStatus.NO_STATUS.getValue() + "");
		result.setSensitive(false);
		result.setSiteAbbr("DoD");
		
		if((WellKnownOID.HAIMS_DOCUMENT.isApplicable(document.getGlobalArtifactIdentifier().getHomeCommunityId()) || 
				(ncatRepositoryId.equals(document.getRepositoryId()))))
		{
			result.setSiteNumber("200");
		}				
		else
		{
			// this should be a VA document, set the site number to the repository (there should not actually 
			// be VA documents here but just in case)
			result.setSiteNumber(document.getRepositoryId());
		}
		
		if(WellKnownOID.HAIMS_DOCUMENT.isApplicable(document.getGlobalArtifactIdentifier().getHomeCommunityId()))
		{
			// if there is no defined abstract image and the image is from the DoD, use the following canned image
			result.setAbsImageURI(cannedDoDAbstract);
		}
		else
		{
			result.setAbsImageURI("");
		}
		result.setFullImageURI("imageURN=" + result.getImageUrn() + "&imageQuality=" + ImageQuality.DIAGNOSTICUNCOMPRESSED.getCanonical() + "&contentType=" + document.getMediaType().toString().toLowerCase());
		
		// Patch 122 fields
		result.setAssociatedNoteResulted("");
		result.setImagePackage("");
		result.setImageAnnotationStatus(BigInteger.valueOf(0));
		result.setImageAnnotationStatusDescription("");
		result.setImageHasAnnotations(false);
		result.setImageExtension(vistaImageType.getDefaultFileExtension());
		
		return result;
	}
	
	@SuppressWarnings("deprecation")
	public static gov.va.med.imaging.awiv.webservices.soap.v2.GroupType translate(Study study, 
			boolean includeImages)
	throws URNFormatException
	{
		
		gov.va.med.imaging.awiv.webservices.soap.v2.GroupType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.GroupType();
		
		result.setDescription(extractIllegalCharacters(study.getDescription()));
		result.setEvent(extractIllegalCharacters(study.getEvent()));
		result.setImageCount(BigInteger.valueOf(study.getImageCount()));
		result.setImagePackage(extractIllegalCharacters(study.getImagePackage()));
		result.setImageType(study.getImageType());
		result.setNoteTitle(extractIllegalCharacters(study.getNoteTitle()));
		result.setOrigin(extractIllegalCharacters(study.getOrigin()));
		result.setPatientIcn(study.getPatientId());
		result.setPatientName(study.getPatientName());
		result.setProcedure(extractIllegalCharacters(study.getProcedure()));
		result.setSiteNumber(study.getSiteNumber());
		result.setSpecialty(extractIllegalCharacters(study.getSpecialty()));
		
		// 2/19/08 - now include the site name so the Display client shows what specific DOD facility the study is from
		if(ExchangeUtil.isSiteDOD(study.getSiteNumber()))
		{
			result.setSiteAbbreviation(study.getSiteAbbr()+ (study.getSiteName() != null ? "-" + study.getSiteName() : ""));			
		}
		else
		{
			result.setSiteAbbreviation(study.getSiteAbbr());
		}				
		result.setStudyPackage(extractIllegalCharacters(study.getImagePackage()));
		result.setStudyClass(extractIllegalCharacters(study.getStudyClass() == null ? "" : study.getStudyClass())); // get this from study
		result.setStudyType(extractIllegalCharacters(study.getImageType()));
		result.setCaptureDate(study.getCaptureDate());
		result.setCapturedBy(study.getCaptureBy());		
		if(study.getProcedureDate() == null)
		{
			logger.warn("Setting null procedure date for study");
			result.setProcedureDate("");
		}
		else
		{
			if((study.getProcedureDateString() == null) || (study.getProcedureDateString().length() <= 0))
			{
				// if the hour and minute are not 0, then likely they contain real values for hour and minute (not 00:00)
				// this leaves open the possibility of invalid data, if the real date was at 00:00 then this would not show that time.
				// we would then omit data, not show invalid data
				if((study.getProcedureDate().getHours() <= 0) && (study.getProcedureDate().getMinutes() <= 0))
				{
					result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(study.getProcedureDate()));
				}
				else
				{
					result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(study.getProcedureDate()));
				}
				
			}
			else if(study.getProcedureDateString().length() > 10)
			{
				result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(study.getProcedureDate()));
			}
			else {
				result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(study.getProcedureDate()));
			}
		}		
		if(includeImages)
		{
			List<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType>  images = 
				new ArrayList<gov.va.med.imaging.awiv.webservices.soap.v2.ImageType>();
			for(Series series : study.getSeries())
			{
				for(Image image : series)
				{
					gov.va.med.imaging.awiv.webservices.soap.v2.ImageType it = transformImageToFatImage(image, series);
					if(it != null)
						images.add(it);
				}
					 
			}
			result.setImages(
					new gov.va.med.imaging.awiv.webservices.soap.v2.ImagesType(
							images.toArray(
									new gov.va.med.imaging.awiv.webservices.soap.v2.ImageType[images.size()])));
		}
		// need to add site number field
		
		StudyURN studyUrn = study.getStudyUrn();// StudyURN.create(study.getSiteNumber(), study.getStudyIen(), study.getPatientIcn());
		result.setStudyUrn(studyUrn.toStringCDTP());
		
		
		if(study.getDocumentDate() != null)
		{
			result.setDocumentDate(getAWIVWebserviceLongDateFormat().format(study.getDocumentDate()));
		}
		else
		{
			result.setDocumentDate("");
		}
		result.setStatus(study.getStudyStatus().getValue() + "");
		result.setSensitive(study.isSensitive());
		result.setViewStatus(study.getStudyViewStatus().getValue() + "");
		result.setStudyImagesHaveAnnotations(study.isStudyImagesHaveAnnotations());
		
		return result;
	}
	
	@SuppressWarnings("deprecation")
	private static gov.va.med.imaging.awiv.webservices.soap.v2.ImageType transformImageToFatImage(Image image, Series series) 
	throws URNFormatException 
	{
		if(image == null)
			return null;
		
		if(image.isDeleted())
		{
			logger.debug("Image '" + image.getImageUrn().toString(SERIALIZATION_FORMAT.CDTP) + "' is deleted, excluding from result.");
			return null;
		}
		
		gov.va.med.imaging.awiv.webservices.soap.v2.ImageType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.ImageType();
		
		result.setDescription(extractIllegalCharacters(image.getDescription()));
		result.setPatientIcn(image.getPatientId());
		result.setPatientName(image.getPatientName());
		result.setDicomImageNumber((image.getImageNumber() != null) && (image.getImageNumber().length() > 0) ? image.getImageNumber() : image.getDicomImageNumberForDisplay());
		//result.setDicomSequenceNumber(image.getDicomSequenceNumberForDisplay());
		result.setDicomSequenceNumber((series != null) && (series.getSeriesNumber() != null) && (series.getSeriesNumber().length() > 0) ? series.getSeriesNumber() : image.getDicomSequenceNumberForDisplay());
		result.setProcedure(extractIllegalCharacters(image.getProcedure()));
		if(image.getProcedureDate() == null)
		{
			logger.warn("Setting null procedure date for image");
			result.setProcedureDate("");
		}
		else 
		{
			// if the hour and minute are not 0, then likely they contain real values for hour and minute (not 00:00)
			// this leaves open the possibility of invalid data, if the real date was at 00:00 then this would not show that time.
			// we would then omit data, not show invalid data
			if((image.getProcedureDate().getHours() <= 0) && (image.getProcedureDate().getMinutes() <= 0))
			{
				result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(image.getProcedureDate()));
			}
			else
			{
				result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(image.getProcedureDate()));
			}
		}
		result.setSiteNumber(image.getSiteNumber());
		result.setSiteAbbr(image.getSiteAbbr());
		result.setImageClass(extractIllegalCharacters(image.getImageClass()));
		result.setAbsLocation(image.getAbsLocation());
		result.setFullLocation(image.getFullLocation());
		result.setImageExtension(getFileExtension(image.getFullFilename()));
		
		result.setImageType(BigInteger.valueOf(image.getImgType()));

		//ImageURN imageUrn = ImageURNFactory.create(image.getSiteNumber(), image.getIen(), parentIen(image), image.getPatientICN(), image.getImageModality(), ImageURN.class);
		// use the VA internal form of the URN for char set safety and inclusion of extra identifiers
		//result.setImageUrn( image.getImageUrn().toStringCDTP() );
		result.setImageUrn(image.getImageUrn().toString(SERIALIZATION_FORMAT.CDTP));
		
		boolean isRadImage = isRadImage(image);
		if((image.getFullFilename() != null) && (image.getFullFilename().startsWith("-1")))
		{
			result.setFullImageURI(image.getFullFilename()); // put in error state
		}
		else
		{
			// if the image is not radiology, then this is a ref image request, if not rad image
			// then ref location is for the diagnostic image.
			int imageQuality = (isRadImage ? ImageQuality.REFERENCE.getCanonical() : ImageQuality.DIAGNOSTICUNCOMPRESSED.getCanonical());			
			result.setFullImageURI("imageURN=" + result.getImageUrn() + "&imageQuality=" + imageQuality + "&contentType=" + getContentType(image, ImageQuality.REFERENCE));
		}
		if((image.getAbsFilename() != null) && (image.getAbsFilename().startsWith("-1")))
		{
			result.setAbsImageURI(image.getAbsFilename());
		}
		else
		{
			result.setAbsImageURI("imageURN=" + result.getImageUrn() + "&imageQuality=20&contentType=" + getContentType(image, ImageQuality.THUMBNAIL));
		}
		if(isRadImage)
		{
			if((image.getBigFilename() != null) && (image.getBigFilename().startsWith("-1")))
			{
				result.setDiagImageURI(image.getBigFilename());
			}
			else
			{
				
				result.setDiagImageURI("imageURN=" + result.getImageUrn() + "&imageQuality=90&contentType=" + getContentType(image, ImageQuality.DIAGNOSTIC));
			}
		}
		else
		{
			result.setDiagImageURI("");
		}
		
		
		if(image.getCaptureDate() != null)
		{
			result.setCaptureDate(getAWIVWebserviceLongDateFormat().format(image.getCaptureDate()));	
		}
		else
		{
			result.setCaptureDate("");
		}
		if(image.getDocumentDate() != null)
		{
			result.setDocumentDate(getAWIVWebserviceLongDateFormat().format(image.getDocumentDate()));
		}
		else
		{
			result.setDocumentDate("");
		}
		result.setStatus(image.getImageStatus().getValue() + "");
		result.setSensitive(image.isSensitive());
		result.setViewStatus(image.getImageViewStatus().getValue() + "");
		
		result.setAssociatedNoteResulted(image.getAssociatedNoteResulted() == null ? "" : image.getAssociatedNoteResulted());
		result.setImagePackage(image.getImagePackage() == null ? "" : image.getImagePackage());
		result.setImageAnnotationStatus(BigInteger.valueOf(image.getImageAnnotationStatus()));
		result.setImageAnnotationStatusDescription(image.getImageAnnotationStatusDescription() == null ? "" : image.getImageAnnotationStatusDescription());
		result.setImageHasAnnotations(image.isImageHasAnnotations());
		
		return result;
	}
	
	private static ClinicalContentTypeConfig getContentTypeConfig(int imageType, ImageQuality imageQuality)
	{
		VistaImageType vistaImageType = getVistaImageType(imageType);
		if(vistaImageType == null)
		{
			return null;			
		}
		return getAWIVConfiguration().getContentTypeConfiguration(vistaImageType, 
				imageQuality);
	}
	
	
	private static AWIVWebAppConfiguration getAWIVConfiguration()
	{
		return AWIVWebAppConfiguration.getConfiguration();
	}
	
	private static VistaImageType getVistaImageType(int imageType)
	{
		return VistaImageType.valueOfImageType(imageType);
	}
	
	private static String getContentType(Image image, ImageQuality imageQuality)
	{
		String contentType = "";
		
		ClinicalContentTypeConfig config = getContentTypeConfig(image.getImgType(), imageQuality);
		if(config != null)
			contentType = config.getContentType();
		
		if(contentType.length() > 0)
		{
			contentType += ",*/*";
		}
		else
		{
			contentType = "*/*";
		}
		return contentType;
	}
	
	/**
	 * Returns the file extension without the '.'
	 * @param filename
	 * @return
	 */
	private static String getFileExtension(String filename)
	{
		if(filename == null)
			return "";
		int loc = filename.lastIndexOf(".");
		if(loc >= 0)
		{
			return filename.substring(loc + 1);
		}
		return "";
	}
	
	public static gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse translate(SiteConnectivityStatus siteStatus)
	{
		gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse response = null;
		if(siteStatus == SiteConnectivityStatus.VIX_READY)
		{
			response = gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse.SERVER_READY;
		}
		else if(siteStatus == SiteConnectivityStatus.DATASOURCE_UNAVAILABLE)
		{
			response = gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse.VISTA_UNAVAILABLE;
		}
		else 
		{
			response = gov.va.med.imaging.awiv.webservices.soap.v2.PingServerTypePingResponse.SERVER_UNAVAILABLE;
		}
		
		return response;
	}
	
	public static ImageAccessLogEvent translate(gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessLogEventType logEventType) 
	throws URNFormatException 
	{
		if(logEventType == null)
			return null;
		
		
		URN urn = URNFactory.create(logEventType.getId(), SERIALIZATION_FORMAT.CDTP);
		if(urn instanceof AbstractImagingURN)
		{
			AbstractImagingURN abstractImagingUrn = (AbstractImagingURN)urn;
			boolean isDodImage = ExchangeUtil.isSiteDOD(abstractImagingUrn.getOriginatingSiteId());	
			
			// JMW 9/7/2012 this code below is new but copied from the section below
			// the logSiteNumber is the user site number and is used if the image is DoD because access
			// to a DoD image cannot be logged to the DoD.  If the user authenticated to site 100 (CLAIMS) then
			// we want to log to the site where the patient lookup was done because site 100 does not have Imaging.
			// the logic below will set the logSiteNumber to the patientLookupSite which will either be the 
			// same as the authenticating site (if not a CLAIMS user) or it will be the site where the patient 
			// was selected from			
			String logSiteNumber = logEventType.getCredentials().getSiteNumber(); // the site number to log the access to
			String patientLookupSiteNumber = logEventType.getCredentials().getPatientLookupSite();
			if(patientLookupSiteNumber != null && patientLookupSiteNumber.length() > 0)
				logSiteNumber = patientLookupSiteNumber;
			
			ImageAccessLogEventType imageAccessLogEventType = translate(logEventType.getEventType());
			ImageAccessLogEvent result = 			
				new ImageAccessLogEvent(abstractImagingUrn.getImagingIdentifier(), "", logEventType.getPatientIcn(), 
						abstractImagingUrn.getOriginatingSiteId(), System.currentTimeMillis(), 
					logEventType.getReason() + "", "", 
					imageAccessLogEventType, isDodImage, logSiteNumber);		
			return result;
		}
		else if(urn instanceof PatientArtifactIdentifierImpl)
		{
			PatientArtifactIdentifierImpl pai = (PatientArtifactIdentifierImpl)urn;
			// JMW 9/7/2012 the code below is old but I'm adding this comment to describe it
			// the logSiteNumber is the user site number and is used if the image is DoD because access
			// to a DoD image cannot be logged to the DoD.  If the user authenticated to site 100 (CLAIMS) then
			// we want to log to the site where the patient lookup was done because site 100 does not have Imaging.
			// the logic below will set the logSiteNumber to the patientLookupSite which will either be the 
			// same as the authenticating site (if not a CLAIMS user) or it will be the site where the patient 
			// was selected from
			String logSiteNumber = logEventType.getCredentials().getSiteNumber(); // the site number to log the access to
			String patientLookupSiteNumber = logEventType.getCredentials().getPatientLookupSite();
			if(patientLookupSiteNumber != null && patientLookupSiteNumber.length() > 0)
				logSiteNumber = patientLookupSiteNumber;
			
			ImageAccessLogEventType imageAccessLogEventType = translate(logEventType.getEventType());
			ImageAccessLogEvent result = 			
				new ImageAccessLogEvent(pai.toString(), "", logEventType.getPatientIcn(), 
						"200", System.currentTimeMillis(), 
						logEventType.getReason() + "", "", 
						imageAccessLogEventType, true, logSiteNumber);		
			return result;
		}
		else
		{
			logger.warn("Image Id '" + logEventType.getId() + "' is not an AbstractImagingURN or PatientArtifactIdentifier and cannot be logged at this time.");
			return null;
		}
		
		
	}	

	public static ImageAccessLogEventType translate(gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessLogEventTypeEventType eventType) {
		ImageAccessLogEventType result;// = new gov.va.med.imaging.exchange.enums.ImageAccessLogEventType();
		if(eventType == gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessLogEventTypeEventType.IMAGE_COPY) {
			result = ImageAccessLogEventType.IMAGE_COPY;
		}
		else if(eventType == gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessLogEventTypeEventType.PATIENT_ID_MISMATCH)
		{
			result = ImageAccessLogEventType.PATIENT_ID_MISMATCH;
		}
		else if(eventType == gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessLogEventTypeEventType.IMAGE_ACCESS)
		{
			result = ImageAccessLogEventType.IMAGE_ACCESS;
		}
		else {
			result = ImageAccessLogEventType.IMAGE_PRINT;
		}
		return result;
	}
	
	/**
	 * Certain characters cannot be given to the Clinical Display client because they will cause exceptions
	 * in the parsing, they must be removed to ensure proper display of metadata. This function removes those
	 * characters and replaces them with a space
	 * @param input Input string to check
	 * @return
	 */
	private static String extractIllegalCharacters(String input)
	{
		if(input == null)
			return "";
		return input.replaceAll("\\^", " ");	
	}
	
	protected static boolean isRadImage(Image image)
	{
		if(image == null)
			return false;
		int imgType = image.getImgType();
		if((imgType == VistaImageType.DICOM.getImageType()) || 
				(imgType == VistaImageType.XRAY.getImageType()))
		{
			return true;
		}
		return false;
	}
	
	public static gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationType[] translateImageAnnotations(List<ImageAnnotation> imageAnnotations)
	{
		if(imageAnnotations == null)
		{
			return new gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationType[0];
		}
		gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationType[] result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationType[imageAnnotations.size()];
		
		for(int i = 0; i < imageAnnotations.size(); i++)
		{
			result[i] = translate(imageAnnotations.get(i));
		}
		
		return result;
	}
	
	private static SimpleDateFormat getAnnotationDateFormat()
	{
		return new SimpleDateFormat(annotationDateFormat);
	}	
	
	public static gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationType translate(ImageAnnotation imageAnnotation)
	{
		gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationType();
		
		result.setAnnotationId(imageAnnotation.getAnnotationUrn().toString(SERIALIZATION_FORMAT.CDTP));
		result.setImageId(imageAnnotation.getImagingUrn().toString(SERIALIZATION_FORMAT.CDTP));
		result.setAnnotationVersion(imageAnnotation.getAnnotationVersion());
		result.setSavedAfterResult(imageAnnotation.isSavedAfterResult());
		result.setSavedDate(imageAnnotation.getAnnotationSavedDate() == null ? "" : getAnnotationDateFormat().format(imageAnnotation.getAnnotationSavedDate()));
		result.setSource(translate(imageAnnotation.getAnnotationSource()));
		result.setUser(translate(imageAnnotation.getAnnotationSavedByUser()));
		result.setAnnotationDeleted(imageAnnotation.isAnnotationDeleted());
		
		return result;
	}
	
	private static gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationTypeSource translate (
			ImageAnnotationSource annotationSource)
	{
		for(Entry<ImageAnnotationSource, gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationTypeSource> entry : AWIVTranslatorV2.annotationSourceMap.entrySet())
		{
			if(entry.getKey() == annotationSource)
				return entry.getValue();			
		}
		return null;
	}
	
	private static gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationUserType translate(
			ImageAnnotationUser user)
	{
		if(user == null)
			return new gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationUserType();
		gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationUserType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationUserType();
		
		result.setDuz(user.getUserId());
		result.setName(user.getName());
		result.setService(user.getService());
		
		return result;
	}
	
	public static gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationDetailsType translate(
			ImageAnnotationDetails imageAnnotationDetails)
	{
		if(imageAnnotationDetails == null)
		{
			return new gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationDetailsType();
		}
		gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationDetailsType result =
			new gov.va.med.imaging.awiv.webservices.soap.v2.AnnotationDetailsType();
		
		result.setAnnotation(translate(imageAnnotationDetails.getImageAnnotation()));
		result.setDetails(imageAnnotationDetails.getAnnotationXml());
		
		return result;
	}
	
	public static ImagingLogEvent translate(gov.va.med.imaging.awiv.webservices.soap.v2.ThinClientAccessLogEventType thinClientDetails,
			String transactionId)
	throws URNFormatException, RoutingTokenFormatException
	{
		if(thinClientDetails == null)
			return null;
		String delimiter = "|";
		StringBuilder additionalData = new StringBuilder();
		additionalData.append(transactionId);
		additionalData.append(delimiter);
		additionalData.append(thinClientDetails.getScreenResolution());
		
		String logSiteNumber = thinClientDetails.getCredentials().getSiteNumber(); // the site number to log the access to
		String patientLookupSiteNumber = thinClientDetails.getCredentials().getPatientLookupSite();
		if(patientLookupSiteNumber != null && patientLookupSiteNumber.length() > 0)
			logSiteNumber = patientLookupSiteNumber;
		
		RoutingToken routingTokenToLogTo = RoutingTokenHelper.createSiteAppropriateRoutingToken(logSiteNumber);
		
		AbstractImagingURN abstractImagingUrn = null;		
		if(thinClientDetails.isIsGroup() && thinClientDetails.getId() != null && thinClientDetails.getId().length() > 0)
		{
			URN urn = URNFactory.create(thinClientDetails.getId(), SERIALIZATION_FORMAT.CDTP);
			if(urn instanceof AbstractImagingURN)
			{
				abstractImagingUrn = (AbstractImagingURN)urn;
				if(ExchangeUtil.isSiteDOD(abstractImagingUrn.getOriginatingSiteId()))
				{
					// this is a DoD image so put the value here
					additionalData.append("|");
					additionalData.append(thinClientDetails.getId());
				}
			}
		}
		else if(!thinClientDetails.isIsGroup())
		{
			additionalData.append("|");
			additionalData.append("DOD_Artifacts");
		}
		
		return new ImagingLogEvent(routingTokenToLogTo, abstractImagingUrn, thinClientDetails.getPatientIcn(), 
				"AWIVTC", "AWIV", -1, additionalData.toString());
	}
	
	public static gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[] translateImageAccessReasons(List<ImageAccessReason> reasons)
	{
		if(reasons == null)
			return new gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[0];
		
		gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[] result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType[reasons.size()];
		for(int i = 0; i < reasons.size(); i++)
		{
			result[i] = translate(reasons.get(i));
		}
		
		return result;
	}
	
	private static gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType translate(ImageAccessReason reason)
	{
		gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonType();
		
		result.setDescription(reason.getDescription());
		result.setGlobalReasonCode(reason.getGlobalReasonCode() + "");
		result.setReasonCode(reason.getReasonCode() + "");
		result.setReasonType(translateReasonTypes(reason.getReasonTypes()));		
		
		return result;
	}
	
	private static gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[] translateReasonTypes(List<ImageAccessReasonType> reasonTypes)
	{
		if(reasonTypes == null)
			return new gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[0];
		
		gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[] result = 
			new gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[reasonTypes.size()];
		for(int i = 0; i < reasonTypes.size(); i++)
		{
			result[i] = translate(reasonTypes.get(i));
		}
		
		return result;
	}
	
	public static List<ImageAccessReasonType> translate(gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType[] reasons)
	{
		if(reasons == null)
			return new ArrayList<ImageAccessReasonType>();
		
		List<ImageAccessReasonType> result = new ArrayList<ImageAccessReasonType>();
		
		for(int i = 0; i < reasons.length; i++)
		{
			result.add(translate(reasons[i]));
		}
		
		return result;
	}
	
	private static gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType translate (
			ImageAccessReasonType reason)
	{
		for(Entry<ImageAccessReasonType, gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType> entry : AWIVTranslatorV2.imageAccessReasonsMap.entrySet())
		{
			if(entry.getKey() == reason)
				return entry.getValue();			
		}
		return null;
	}
	
	private static ImageAccessReasonType translate (
			gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType reason)
	{
		for(Entry<ImageAccessReasonType, gov.va.med.imaging.awiv.webservices.soap.v2.ImageAccessReasonTypeType> entry : AWIVTranslatorV2.imageAccessReasonsMap.entrySet())
		{
			if(entry.getValue() == reason)
				return entry.getKey();			
		}
		return null;
	}
	
	public static gov.va.med.imaging.awiv.webservices.soap.v2.ElectronicSignatureResultType translate(ElectronicSignatureResult electronicSignature)
	{
		return new ElectronicSignatureResultType(electronicSignature.isSuccess(), 
				electronicSignature.getMessage());
	}
	
	static class DocumentSetDocument
	{
		private final DocumentSet documentSet;
		private final Document document;		
		
		/**
		 * @param documentSet
		 * @param document
		 */
		public DocumentSetDocument(DocumentSet documentSet, Document document)
		{
			super();
			this.documentSet = documentSet;
			this.document = document;
		}

		/**
		 * @return the documentSet
		 */
		public DocumentSet getDocumentSet()
		{
			return documentSet;
		}

		/**
		 * @return the document
		 */
		public Document getDocument()
		{
			return document;
		}
	}
	
	static class DocumentSetDocumentComparator 
	implements Comparator<DocumentSetDocument>
	{
		private final boolean ascending;
		
		public DocumentSetDocumentComparator(boolean ascending)
		{
			this.ascending = ascending;
		}
		

		/* (non-Javadoc)
		 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
		 */
		@Override
		public int compare(DocumentSetDocument dsd1, DocumentSetDocument dsd2)
		{
			if(dsd1.document.getCreationDate() == null)
				return -1;
			if(dsd2.document.getCreationDate() == null)
				return 1;
			
			int value = dsd1.document.getCreationDate().compareTo(dsd2.getDocument().getCreationDate());
			if(!ascending)
				value = value * -1;
			
			return value;
		}
		
	}
}
