/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: May 27, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.awiv.translator;

import gov.va.med.ImageURNFactory;
import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.imaging.AbstractImagingURN;
import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.awiv.configuration.AWIVWebAppConfiguration;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.ImageAccessLogEvent;
import gov.va.med.imaging.exchange.ImageAccessLogEvent.ImageAccessLogEventType;
import gov.va.med.imaging.exchange.business.Image;
import gov.va.med.imaging.exchange.business.Series;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.util.ExchangeUtil;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import gov.va.med.imaging.exchange.enums.SiteConnectivityStatus;
import gov.va.med.imaging.exchange.enums.VistaImageType;
import gov.va.med.imaging.webservices.clinical.ClinicalContentTypeConfig;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import sun.security.action.GetLongAction;

/**
 * @author vhaiswwerfej
 *
 */
public class AWIVTranslatorV1 
{
	private final static Logger logger = LogManager.getLogger(AWIVTranslatorV1.class);
	
	private final static String awivWebserviceShortDateFormat = "MM/dd/yyyy";
	private final static String awivWebserviceLongDateFormat = "MM/dd/yyyy HH:mm";
	
	private DateFormat getAWIVWebserviceShortDateFormat()
	{
		return new SimpleDateFormat(awivWebserviceShortDateFormat);
	}
	
	private DateFormat getAWIVWebserviceLongDateFormat()
	{
		return new SimpleDateFormat(awivWebserviceLongDateFormat);
	}
	
	public gov.va.med.imaging.awiv.webservices.soap.v1.GroupType translateStudiesToGroupType(List<Study> studies)
	throws URNFormatException
	{
		if(studies == null)
			return new gov.va.med.imaging.awiv.webservices.soap.v1.GroupType();
		Study study = studies.get(0);
		gov.va.med.imaging.awiv.webservices.soap.v1.GroupType result = createGroupFromStudy(study);
		List<gov.va.med.imaging.awiv.webservices.soap.v1.ImageType> images = 
			new ArrayList<gov.va.med.imaging.awiv.webservices.soap.v1.ImageType>();
		images.addAll(translateImages(study));
		for(int i = 1; i < studies.size(); i++)
		{
			study = studies.get(i);
			images.addAll(translateImages(study));
		}
		result.setImages(new gov.va.med.imaging.awiv.webservices.soap.v1.ImagesType(images.toArray(new gov.va.med.imaging.awiv.webservices.soap.v1.ImageType[images.size()])));
		result.setImageCount(BigInteger.valueOf(images.size()));
		return result;
	}
	
	private gov.va.med.imaging.awiv.webservices.soap.v1.GroupType createGroupFromStudy(Study study)
	throws URNFormatException
	{
		gov.va.med.imaging.awiv.webservices.soap.v1.GroupType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v1.GroupType();
		
		result.setDescription(extractIllegalCharacters(study.getDescription()));
		result.setEvent(extractIllegalCharacters(study.getEvent()));
		//result.setImageCount(BigInteger.valueOf(study.getImageCount()));
		result.setImagePackage(extractIllegalCharacters(study.getImagePackage()));
		result.setImageType(study.getImageType());
		result.setNoteTitle(extractIllegalCharacters(study.getNoteTitle()));
		result.setOrigin(extractIllegalCharacters(study.getOrigin()));
		result.setPatientIcn(study.getPatientId());
		result.setPatientName(study.getPatientName());
		result.setProcedure(extractIllegalCharacters(study.getProcedure()));
		result.setSiteNumber(study.getSiteNumber());
		result.setSpecialty(extractIllegalCharacters(study.getSpecialty()));
		
		// 2/19/08 - now include the site name so the Display client shows what specific DOD facility the study is from
		if(ExchangeUtil.isSiteDOD(study.getSiteNumber()))
		{
			result.setSiteAbbreviation(study.getSiteAbbr()+ (study.getSiteName() != null ? "-" + study.getSiteName() : ""));			
		}
		else
		{
			result.setSiteAbbreviation(study.getSiteAbbr());
		}				
		result.setStudyPackage(extractIllegalCharacters(study.getImagePackage()));
		result.setStudyClass(extractIllegalCharacters(study.getStudyClass() == null ? "" : study.getStudyClass())); // get this from study
		result.setStudyType(extractIllegalCharacters(study.getImageType()));
		result.setCaptureDate(study.getCaptureDate());
		result.setCapturedBy(study.getCaptureBy());		
		if(study.getProcedureDate() == null)
		{
			logger.warn("Setting null procedure date for study");
			result.setProcedureDate("");
		}
		else
		{
			if((study.getProcedureDateString() == null) || (study.getProcedureDateString().length() <= 0))
			{
				// if the hour and minute are not 0, then likely they contain real values for hour and minute (not 00:00)
				// this leaves open the possibility of invalid data, if the real date was at 00:00 then this would not show that time.
				// we would then omit data, not show invalid data
				if((study.getProcedureDate().getHours() <= 0) && (study.getProcedureDate().getMinutes() <= 0))
				{
					result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(study.getProcedureDate()));
				}
				else
				{
					result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(study.getProcedureDate()));
				}
				
			}
			else if(study.getProcedureDateString().length() > 10)
			{
				result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(study.getProcedureDate()));
			}
			else {
				result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(study.getProcedureDate()));
			}
		}		
		/*
		gov.va.med.imaging.awiv.webservices.soap.v1.ImageType [] images = 
			new gov.va.med.imaging.awiv.webservices.soap.v1.ImageType[study.getImageCount()];
		int i = 0;
		for(Series series : study.getSeries())
		{
			for(Image image : series)
			{
				images[i] = transformImageToFatImage(image, series);
				i++;
			}
				 
		}
		result.setImages(new gov.va.med.imaging.awiv.webservices.soap.v1.ImagesType(images));
		*/
		// need to add site number field
		
		StudyURN studyUrn = study.getStudyUrn();// StudyURN.create(study.getSiteNumber(), study.getStudyIen(), study.getPatientIcn());
		result.setStudyUrn(studyUrn.toStringCDTP());		
		return result;
	}
	
	private List<gov.va.med.imaging.awiv.webservices.soap.v1.ImageType> translateImages(Study study)
	throws URNFormatException
	{
		List<gov.va.med.imaging.awiv.webservices.soap.v1.ImageType> images = 
			new ArrayList<gov.va.med.imaging.awiv.webservices.soap.v1.ImageType>();
		for(Series series : study.getSeries())
		{
			for(Image image : series)
			{
				gov.va.med.imaging.awiv.webservices.soap.v1.ImageType it = transformImageToFatImage(image, series);
				if(image != null)
					images.add(it);
			}				 
		}
		return images;
	}
	
	
	public gov.va.med.imaging.awiv.webservices.soap.v1.GroupType translateStudyToGroupType(Study study)
	throws URNFormatException
	{
		
		gov.va.med.imaging.awiv.webservices.soap.v1.GroupType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v1.GroupType();
		
		result.setDescription(extractIllegalCharacters(study.getDescription()));
		result.setEvent(extractIllegalCharacters(study.getEvent()));
		result.setImageCount(BigInteger.valueOf(study.getImageCount()));
		result.setImagePackage(extractIllegalCharacters(study.getImagePackage()));
		result.setImageType(study.getImageType());
		result.setNoteTitle(extractIllegalCharacters(study.getNoteTitle()));
		result.setOrigin(extractIllegalCharacters(study.getOrigin()));
		result.setPatientIcn(study.getPatientId());
		result.setPatientName(study.getPatientName());
		result.setProcedure(extractIllegalCharacters(study.getProcedure()));
		result.setSiteNumber(study.getSiteNumber());
		result.setSpecialty(extractIllegalCharacters(study.getSpecialty()));
		
		// 2/19/08 - now include the site name so the Display client shows what specific DOD facility the study is from
		if(ExchangeUtil.isSiteDOD(study.getSiteNumber()))
		{
			result.setSiteAbbreviation(study.getSiteAbbr()+ (study.getSiteName() != null ? "-" + study.getSiteName() : ""));			
		}
		else
		{
			result.setSiteAbbreviation(study.getSiteAbbr());
		}				
		result.setStudyPackage(extractIllegalCharacters(study.getImagePackage()));
		result.setStudyClass(extractIllegalCharacters(study.getStudyClass() == null ? "" : study.getStudyClass())); // get this from study
		result.setStudyType(extractIllegalCharacters(study.getImageType()));
		result.setCaptureDate(study.getCaptureDate());
		result.setCapturedBy(study.getCaptureBy());		
		if(study.getProcedureDate() == null)
		{
			logger.warn("Setting null procedure date for study");
			result.setProcedureDate("");
		}
		else
		{
			if((study.getProcedureDateString() == null) || (study.getProcedureDateString().length() <= 0))
			{
				// if the hour and minute are not 0, then likely they contain real values for hour and minute (not 00:00)
				// this leaves open the possibility of invalid data, if the real date was at 00:00 then this would not show that time.
				// we would then omit data, not show invalid data
				if((study.getProcedureDate().getHours() <= 0) && (study.getProcedureDate().getMinutes() <= 0))
				{
					result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(study.getProcedureDate()));
				}
				else
				{
					result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(study.getProcedureDate()));
				}
				
			}
			else if(study.getProcedureDateString().length() > 10)
			{
				result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(study.getProcedureDate()));
			}
			else {
				result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(study.getProcedureDate()));
			}
		}		
		gov.va.med.imaging.awiv.webservices.soap.v1.ImageType [] images = 
			new gov.va.med.imaging.awiv.webservices.soap.v1.ImageType[study.getImageCount()];
		int i = 0;
		for(Series series : study.getSeries())
		{
			for(Image image : series)
			{
				images[i] = transformImageToFatImage(image, series);
				i++;
			}
				 
		}
		result.setImages(new gov.va.med.imaging.awiv.webservices.soap.v1.ImagesType(images));
		
		// need to add site number field
		
		StudyURN studyUrn = study.getStudyUrn();// StudyURN.create(study.getSiteNumber(), study.getStudyIen(), study.getPatientIcn());
		result.setStudyUrn(studyUrn.toStringCDTP());
		
		return result;
	}
	
	private gov.va.med.imaging.awiv.webservices.soap.v1.ImageType transformImageToFatImage(Image image, Series series) 
	throws URNFormatException 
	{
		if(image == null)
			return null;
		if(image.isDeleted())
		{
			logger.debug("Image '" + image.getImageUrn().toString(SERIALIZATION_FORMAT.CDTP) + "' is deleted, excluding from result.");
			return null;
		}
		
		gov.va.med.imaging.awiv.webservices.soap.v1.ImageType result = 
			new gov.va.med.imaging.awiv.webservices.soap.v1.ImageType();
		
		result.setDescription(extractIllegalCharacters(image.getDescription()));
		result.setPatientIcn(image.getPatientId());
		result.setPatientName(image.getPatientName());
		result.setDicomImageNumber((image.getImageNumber() != null) && (image.getImageNumber().length() > 0) ? image.getImageNumber() : image.getDicomImageNumberForDisplay());
		//result.setDicomSequenceNumber(image.getDicomSequenceNumberForDisplay());
		result.setDicomSequenceNumber((series != null) && (series.getSeriesNumber() != null) && (series.getSeriesNumber().length() > 0) ? series.getSeriesNumber() : image.getDicomSequenceNumberForDisplay());
		result.setProcedure(extractIllegalCharacters(image.getProcedure()));
		if(image.getProcedureDate() == null)
		{
			logger.warn("Setting null procedure date for image");
			result.setProcedureDate("");
		}
		else 
		{
			// if the hour and minute are not 0, then likely they contain real values for hour and minute (not 00:00)
			// this leaves open the possibility of invalid data, if the real date was at 00:00 then this would not show that time.
			// we would then omit data, not show invalid data
			if((image.getProcedureDate().getHours() <= 0) && (image.getProcedureDate().getMinutes() <= 0))
			{
				result.setProcedureDate(getAWIVWebserviceShortDateFormat().format(image.getProcedureDate()));
			}
			else
			{
				result.setProcedureDate(getAWIVWebserviceLongDateFormat().format(image.getProcedureDate()));
			}
		}
		result.setSiteNumber(image.getSiteNumber());
		result.setSiteAbbr(image.getSiteAbbr());
		result.setImageClass(extractIllegalCharacters(image.getImageClass()));
		result.setAbsLocation(image.getAbsLocation());
		result.setFullLocation(image.getFullLocation());
		result.setImageExtension(getFileExtension(image.getFullFilename()));
		
		result.setImageType(BigInteger.valueOf(image.getImgType()));

		ImageURN imageUrn = ImageURNFactory.create(image.getSiteNumber(), image.getIen(), parentIen(image), image.getPatientId(), image.getImageModality(), ImageURN.class);
		// use the VA internal form of the URN for char set safety and inclusion of extra identifiers
		result.setImageUrn( image.getImageUrn().toStringCDTP() );		
		
		boolean isRadImage = isRadImage(image);
		if((image.getFullFilename() != null) && (image.getFullFilename().startsWith("-1")))
		{
			result.setFullImageURI(image.getFullFilename()); // put in error state
		}
		else
		{
			// if the image is not radiology, then this is a ref image request, if not rad image
			// then ref location is for the diagnostic image.
			int imageQuality = (isRadImage ? ImageQuality.REFERENCE.getCanonical() : ImageQuality.DIAGNOSTICUNCOMPRESSED.getCanonical());			
			result.setFullImageURI("imageURN=" + imageUrn.toString() + "&imageQuality=" + imageQuality + "&contentType=" + getContentType(image, ImageQuality.REFERENCE));
		}
		if((image.getAbsFilename() != null) && (image.getAbsFilename().startsWith("-1")))
		{
			result.setAbsImageURI(image.getAbsFilename());
		}
		else
		{
			result.setAbsImageURI("imageURN=" + imageUrn.toString() + "&imageQuality=20&contentType=" + getContentType(image, ImageQuality.THUMBNAIL));
		}
		if(isRadImage)
		{
			if((image.getBigFilename() != null) && (image.getBigFilename().startsWith("-1")))
			{
				result.setDiagImageURI(image.getBigFilename());
			}
			else
			{
				
				result.setDiagImageURI("imageURN=" + imageUrn.toString() + "&imageQuality=90&contentType=" + getContentType(image, ImageQuality.DIAGNOSTIC));
			}
		}
		else
		{
			result.setDiagImageURI("");
		}
		return result;
	}
	
	private ClinicalContentTypeConfig getContentTypeConfig(int imageType, ImageQuality imageQuality)
	{
		VistaImageType vistaImageType = getVistaImageType(imageType);
		if(vistaImageType == null)
		{
			return null;			
		}
		return getAWIVConfiguration().getContentTypeConfiguration(vistaImageType, 
				imageQuality);
	}
	
	
	private AWIVWebAppConfiguration getAWIVConfiguration()
	{
		return AWIVWebAppConfiguration.getConfiguration();
	}
	
	private VistaImageType getVistaImageType(int imageType)
	{
		return VistaImageType.valueOfImageType(imageType);
	}
	
	private String getContentType(Image image, ImageQuality imageQuality)
	{
		String contentType = "";
		
		ClinicalContentTypeConfig config = getContentTypeConfig(image.getImgType(), imageQuality);
		if(config != null)
			contentType = config.getContentType();
		
		if(contentType.length() > 0)
		{
			contentType += ",*/*";
		}
		else
		{
			contentType = "*/*";
		}
		return contentType;
	}
	
	/**
	 * Returns the file extension without the '.'
	 * @param filename
	 * @return
	 */
	private String getFileExtension(String filename)
	{
		if(filename == null)
			return "";
		int loc = filename.lastIndexOf(".");
		if(loc >= 0)
		{
			return filename.substring(loc + 1);
		}
		return "";
	}
	
	private int getImageQualityFromImageType(int imageType)
	{
		VistaImageType vistaImageType = VistaImageType.valueOfImageType(imageType);
		if(vistaImageType == null)
			return ImageQuality.REFERENCE.getCanonical();
		if((vistaImageType == VistaImageType.DICOM) || (vistaImageType == VistaImageType.XRAY))
		{
			return ImageQuality.REFERENCE.getCanonical();
		}
		else
		{
			return ImageQuality.DIAGNOSTICUNCOMPRESSED.getCanonical();
		}
	}
	
	public gov.va.med.imaging.awiv.webservices.soap.v1.PingServerTypePingResponse transformServerStatusToPingServerResponse(SiteConnectivityStatus siteStatus)
	{
		gov.va.med.imaging.awiv.webservices.soap.v1.PingServerTypePingResponse response = null;
		if(siteStatus == SiteConnectivityStatus.VIX_READY)
		{
			response = gov.va.med.imaging.awiv.webservices.soap.v1.PingServerTypePingResponse.SERVER_READY;
		}
		else if(siteStatus == SiteConnectivityStatus.DATASOURCE_UNAVAILABLE)
		{
			response = gov.va.med.imaging.awiv.webservices.soap.v1.PingServerTypePingResponse.VISTA_UNAVAILABLE;
		}
		else 
		{
			response = gov.va.med.imaging.awiv.webservices.soap.v1.PingServerTypePingResponse.SERVER_UNAVAILABLE;
		}
		
		return response;
	}
	
	public ImageAccessLogEvent transformLogEvent(gov.va.med.imaging.awiv.webservices.soap.v1.ImageAccessLogEventType logEventType) 
	throws URNFormatException 
	{
		if(logEventType == null)
			return null;
		
		AbstractImagingURN urn = null;
		urn = URNFactory.create(logEventType.getId(), SERIALIZATION_FORMAT.CDTP, AbstractImagingURN.class);
		
		boolean isDodImage = urn.isOriginDOD();		
		
		ImageAccessLogEventType imageAccessLogEventType = transformLogEventType(logEventType.getEventType());
		ImageAccessLogEvent result = 			
			new ImageAccessLogEvent(urn.getImagingIdentifier(), "", logEventType.getPatientIcn(), 
					urn.getOriginatingSiteId(), System.currentTimeMillis(), 
				logEventType.getReason(), "", imageAccessLogEventType, isDodImage, logEventType.getCredentials().getSiteNumber());		
		return result;
	}	

	public ImageAccessLogEventType transformLogEventType(gov.va.med.imaging.awiv.webservices.soap.v1.ImageAccessLogEventTypeEventType eventType) {
		ImageAccessLogEventType result;// = new gov.va.med.imaging.exchange.enums.ImageAccessLogEventType();
		if(eventType == gov.va.med.imaging.awiv.webservices.soap.v1.ImageAccessLogEventTypeEventType.IMAGE_COPY) {
			result = ImageAccessLogEventType.IMAGE_COPY;
		}
		else if(eventType == gov.va.med.imaging.awiv.webservices.soap.v1.ImageAccessLogEventTypeEventType.PATIENT_ID_MISMATCH)
		{
			result = ImageAccessLogEventType.PATIENT_ID_MISMATCH;
		}
		else if(eventType == gov.va.med.imaging.awiv.webservices.soap.v1.ImageAccessLogEventTypeEventType.IMAGE_ACCESS)
		{
			result = ImageAccessLogEventType.IMAGE_ACCESS;
		}
		else {
			result = ImageAccessLogEventType.IMAGE_PRINT;
		}
		return result;
	}
	
	/**
	 * Certain characters cannot be given to the Clinical Display client because they will cause exceptions
	 * in the parsing, they must be removed to ensure proper display of metadata. This function removes those
	 * characters and replaces them with a space
	 * @param input Input string to check
	 * @return
	 */
	private String extractIllegalCharacters(String input)
	{
		if(input == null)
			return "";
		return input.replaceAll("\\^", " ");	
	}
	
	private String parentIen(Image image)
	{
		return image.getStudyIen();
	}
	
	protected boolean isRadImage(Image image)
	{
		if(image == null)
			return false;
		int imgType = image.getImgType();
		if((imgType == VistaImageType.DICOM.getImageType()) || 
				(imgType == VistaImageType.XRAY.getImageType()))
		{
			return true;
		}
		return false;
	}

}
