﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.IO;
using System.ServiceProcess;
using log4net;
using Microsoft.Win32;
using System.Diagnostics;
using Vix.Viewer.Install;


namespace gov.va.med.imaging.exchange.VixInstaller.business
{
    public static class ZFViewerFacade
    {
        private static readonly String VIEWER_SERVICE_ACCOUNT_NAME = "VIX Viewer Service";
        private static readonly String RENDER_SERVICE_ACCOUNT_NAME = "VIX Render Service";
        
        //These values should be ok for initial install 
        private static readonly String RENDER_DATABASE_USER_ID = "sa";
        private static readonly String RENDER_DATABASE_PASSWORD = "vitelnet123$%";

        public static VixManifest Manifest { get; set; }
        public static InfoDelegate InfoDelegate { get; set; }
        public static AppEventsDelegate AppEventsDelegate { get; set; }
        private static VIXComponentInstallStatus InstallStatus {  get; set; }
        public static string ViewerPayloadFilespec { get { return Manifest.ActiveZFViewerPrerequisite.PayloadFilespec; } }
        public static string ViewerInstallPath { get { return Manifest.ActiveZFViewerPrerequisite.InstallPath; } }
        public static string ViewerServiceAccountName { get { return VIEWER_SERVICE_ACCOUNT_NAME; } }
        public static string RenderServiceAccountName { get { return RENDER_SERVICE_ACCOUNT_NAME; } }
        public static string ViewerServiceExe { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Viewer.Service\VIX.Viewer.Service.exe");  } }
        public static string RenderServiceExe { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Render.Service\VIX.Render.Service.exe");  } }
        public static string ViewerServiceExeFolderspec { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Viewer.Service"); } }
        public static string RenderServiceExeFolderspec { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Render.Service"); } }
        public static string ViewerServiceCfgFolderspec { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Config"); } }
        //public static string ViewerServiceRelPath { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"_rels"); } }
        //public static string ViewerServicePackagePath { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"package"); } }
        public static string ViewerServiceCfgBackupFolderspec { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Config.Backup"); } }
        public static string ViewerServiceClientPath { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Viewer.Service.Client"); } }
        
        private static ILog Logger()
        {
            return LogManager.GetLogger(typeof(ZFViewerFacade).Name);
        }

        private static String Info(String infoMessage)
        {
            if (InfoDelegate != null)
            {
                InfoDelegate(infoMessage);
            }
            Logger().Info(infoMessage); // any info provided to the presentation layer will be logged.
            return infoMessage;
        }

        private static void DoEvents()
        {
            if (AppEventsDelegate != null)
            {
                AppEventsDelegate();
            }
        }

        public static bool IsZFViewerInstalled(ref String info)
        {
            info = null;
            bool isInstalled = true;
            if (!IsZFViewerInstalled())
            {
                isInstalled = false;
                info = "The VIX Viewer/Render Services are not installed.";
            }
            else
            {
                info = "The VIX Viewer/Render Services are installed.";
            }
            return isInstalled;
        }

        public static bool IsZFViewerInstalled()
        {

            if (InstallStatus == VIXComponentInstallStatus.Installed)
            {
                Info("Image Viewer/Render services are installed.");
                return true;
            }

            bool isInstalled = false;

            if (Directory.Exists(ZFViewerFacade.ViewerServiceExeFolderspec))
            {
                if (File.Exists(ZFViewerFacade.ViewerServiceExe))
                {
                    isInstalled = true;
                    InstallStatus = VIXComponentInstallStatus.Installed;
                }
            }
            return isInstalled;
        }

        public static bool StartZFViewerServices()
        {
            Info("Starting Image Viewer service.");
            // attempt to stop the service
            ServiceControllerStatus viewerStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.VIEWER_SERVICE_ACCOUNT_NAME);
            if (viewerStatus != ServiceControllerStatus.Running)
            {
                ServiceUtilities.StartLocalService(ZFViewerFacade.VIEWER_SERVICE_ACCOUNT_NAME);
                do
                {
                    DoEvents();
                    Thread.Sleep(500);
                    viewerStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.VIEWER_SERVICE_ACCOUNT_NAME);
                }
                while (viewerStatus == System.ServiceProcess.ServiceControllerStatus.StartPending);
                viewerStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.VIEWER_SERVICE_ACCOUNT_NAME);
                Info("The Image Viewer service is " + viewerStatus.ToString("g"));
                if (viewerStatus != ServiceControllerStatus.Running)
                {
                    return false;
                }
            }

            Info("Starting Image Render service.");
            ServiceControllerStatus renderStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.RENDER_SERVICE_ACCOUNT_NAME);
            if (renderStatus != ServiceControllerStatus.Running)
            {
                ServiceUtilities.StartLocalService(ZFViewerFacade.RENDER_SERVICE_ACCOUNT_NAME);
                do
                {
                    DoEvents();
                    Thread.Sleep(500);
                    renderStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.RENDER_SERVICE_ACCOUNT_NAME);
                }
                while (renderStatus == System.ServiceProcess.ServiceControllerStatus.StartPending);
                renderStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.RENDER_SERVICE_ACCOUNT_NAME);
                Info("The Image Render service is " + renderStatus.ToString("g"));
                if (renderStatus != ServiceControllerStatus.Running)
                {
                    return false;
                }
            }

            return true;

            /**
            bool isStarted = false;
            bool isViewerStarted = false;
            bool isRenderStarted = false;

            if (ConfigManager.Instance.RenderStartServiceCommand.CanExecute(null))
            {
                Logger().Info("attempting to start Render Service.");
                ConfigManager.Instance.RenderStartServiceCommand.Execute(null);
                isRenderStarted = true;
            }

            if (ConfigManager.Instance.ViewerStartServiceCommand.CanExecute(null))
            {
                Logger().Info("attempting to start Viewer Service.");
                ConfigManager.Instance.ViewerStartServiceCommand.Execute(null);
                isViewerStarted = true;
            }

            if (isViewerStarted && isRenderStarted)
            {
                isStarted = true;
            }
            return isStarted;
            **/
        }
        
        public static bool StopZFViewerServices()
        {
            Info("Stopping Image Viewer service.");
            // attempt to stop the service
            ServiceControllerStatus viewerStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.VIEWER_SERVICE_ACCOUNT_NAME);

            if (viewerStatus == ServiceControllerStatus.Running)
            {

                ServiceUtilities.StopLocalService(ZFViewerFacade.VIEWER_SERVICE_ACCOUNT_NAME);
                do
                {
                    DoEvents();
                    Thread.Sleep(500);
                    viewerStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.VIEWER_SERVICE_ACCOUNT_NAME);
                }
                while (viewerStatus == System.ServiceProcess.ServiceControllerStatus.StopPending);
                viewerStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.VIEWER_SERVICE_ACCOUNT_NAME);
                Info("The Image Viewer service is " + viewerStatus.ToString("g"));
                if (viewerStatus != ServiceControllerStatus.Stopped)
                {
                    return false;
                }
            }

            Info("Stopping Image Render service.");
            ServiceControllerStatus renderStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.RENDER_SERVICE_ACCOUNT_NAME);

            if (renderStatus == ServiceControllerStatus.Running)
            {
                ServiceUtilities.StopLocalService(ZFViewerFacade.RENDER_SERVICE_ACCOUNT_NAME);
                do
                {
                    DoEvents();
                    Thread.Sleep(500);
                    renderStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.RENDER_SERVICE_ACCOUNT_NAME);
                }
                while (renderStatus == System.ServiceProcess.ServiceControllerStatus.StopPending);
                renderStatus = ServiceUtilities.GetLocalServiceStatus(ZFViewerFacade.RENDER_SERVICE_ACCOUNT_NAME);
                Info("The Image Render service is " + renderStatus.ToString("g"));
                if (renderStatus != ServiceControllerStatus.Stopped)
                {
                    return false;
                }
            }

            return true;
        }

        public static bool InstallZFViewer()
        {
            ZipUtilities.UnZip(ZFViewerFacade.ViewerPayloadFilespec, ZFViewerFacade.ViewerInstallPath);

            return true;
        }

        public static bool UninstallZFViewer()
        {
            bool isBackedUp = BackupZFViewerCfgFiles();

            if (!isBackedUp)
            {
                Info("Failed to backup Image Viewer/Render Configuration files.");
                return false;
            }

            string viewerRoot = ZFViewerFacade.ViewerServiceExeFolderspec;
            if (Directory.Exists(viewerRoot) == false)
            {
                Info("Cannot remove existing Listener installation - directory not found)");
                viewerRoot = null;
            }

            if (viewerRoot != null)
            {
                Directory.Delete(ZFViewerFacade.ViewerServiceExeFolderspec, true);
                Directory.Delete(ZFViewerFacade.RenderServiceExeFolderspec, true);
                Directory.Delete(ZFViewerFacade.ViewerServiceCfgFolderspec, true);

            }
            return true;
        }

        public static bool DeleteViewerPaths()
        {
            Info("Delete " + ZFViewerFacade.ViewerServiceExeFolderspec);
            if (Directory.Exists(ZFViewerFacade.ViewerServiceExeFolderspec))
                Directory.Delete(ZFViewerFacade.ViewerServiceExeFolderspec, true);

            Info("Delete " + ZFViewerFacade.RenderServiceExeFolderspec);
            if (Directory.Exists(ZFViewerFacade.RenderServiceExeFolderspec))
                Directory.Delete(ZFViewerFacade.RenderServiceExeFolderspec, true);

            Info("Delete " + ZFViewerFacade.ViewerServiceCfgFolderspec);
            if (Directory.Exists(ZFViewerFacade.ViewerServiceCfgFolderspec))
                Directory.Delete(ZFViewerFacade.ViewerServiceCfgFolderspec, true);

            //Info("Delete " + ZFViewerFacade.ViewerServiceRelPath);
            //if (Directory.Exists(ZFViewerFacade.ViewerServiceRelPath))
            //    Directory.Delete(ZFViewerFacade.ViewerServiceRelPath, true);

            //Info("Delete " + ZFViewerFacade.ViewerServicePackagePath);
            //if (Directory.Exists(ZFViewerFacade.ViewerServicePackagePath))
            //    Directory.Delete(ZFViewerFacade.ViewerServicePackagePath, true);

            //Info("Delete " + ZFViewerFacade.ViewerServiceInstallerFolderspec);
            //if (Directory.Exists(ZFViewerFacade.ViewerServiceInstallerPath))
            //    Directory.Delete(ZFViewerFacade.ViewerServiceInstallerPath, true);

            Info("Delete " + ZFViewerFacade.ViewerServiceClientPath);
            if (Directory.Exists(ZFViewerFacade.ViewerServiceClientPath))
                Directory.Delete(ZFViewerFacade.ViewerServiceClientPath, true);

            return true;
        }



        public static bool PurgeZFViewerRenderDatabaseAndCache()
        {
            bool isPurged = true;

            if (!PurgeZFViewerRenderDatabase())
        {
                isPurged = false;
        }



            if (!PurgeZFViewerCache())
            {
                isPurged = false;
            }
            return isPurged;
        }


        private static bool PurgeZFViewerCache()
            {
            string renderCache = ConfigManager.Instance.ViewerProperties.StorageProperties.ImageCacheDirectory;
            if (!Directory.Exists(renderCache))
                {
                Info("Cannot remove existing Listener installation - directory not found)");
                renderCache = null;
                }

            if (renderCache != null)
            {
                Directory.Delete(renderCache, true);
                Info("RenderCache is purged.");
            }
            return true;
        }

        public static bool IsDeprecatedZFViewerInstalled()
        {
            bool isInstalled = false;
            if (IsZFViewerInstalled())
            {
                string installedVersion = GetInstalledZFViewerVersion();
                if (installedVersion != Manifest.ActiveZFViewerPrerequisite.Version)
                {
                    isInstalled = true;
                }
            }
            else
            {
                isInstalled = false; // nothing is installed - safety net
            }
            return isInstalled;
        }

        public static string GetDeprecatedZFViewerVersion()
        {
            string version = null;
            ZFViewerPrerequisite prerequisite = GetInstalledDeprecatedZFViewerPrerequsite();
            if (prerequisite != null)
            {
                version = prerequisite.Version;
            }
            else
            {
                version = "0.0.0.0";
            }
            return version;
        }

        public static bool CreateZFViewerWindowsService()
        {
            bool isCreated = false;
            bool isViewerCreated = false;
            bool isRenderCreated = false;

            if (ConfigManager.Instance.ViewerInstallServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.ViewerInstallServiceCommand.Execute(null);
                isViewerCreated = true;
            }

            if (ConfigManager.Instance.RenderInstallServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.RenderInstallServiceCommand.Execute(null);
                isRenderCreated = true;
            }

            if (isViewerCreated && isRenderCreated)
            {
                isCreated = true;
            }
            return isCreated;
        }

        public static bool DestroyZFViewerWindowsServices()
        {
            bool isDeleted = false;
            bool isViewerDeleted = false;
            bool isRenderDeleted = false;

            if (ConfigManager.Instance.ViewerUninstallServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.ViewerUninstallServiceCommand.Execute(null);
                isViewerDeleted = true;
            }

            if (ConfigManager.Instance.RenderUninstallServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.RenderUninstallServiceCommand.Execute(null);
                isRenderDeleted = true;
            }

            if (isViewerDeleted && isRenderDeleted)
            {
                isDeleted = true;
            }
            return isDeleted;
        }

        public static bool BackupZFViewerCfgFiles()
        {
            bool isBackedUp = false;

            if (Directory.Exists(ZFViewerFacade.ViewerServiceCfgFolderspec))
            {
                try
                {
                    DirectoryCopy(ZFViewerFacade.ViewerServiceCfgFolderspec, ZFViewerFacade.ViewerServiceCfgBackupFolderspec);
                    isBackedUp = true;
                }
                catch (Exception X)
                {
                    Logger().Error("Could not make copy of Viewer Config files. Exception is: " + X.Message);
                    isBackedUp = false;
                }
            }

            return isBackedUp;
        }

        public static bool RestoreZFViewerCfgFiles()
        {
            bool isRestored = false;

            if (Directory.Exists(ZFViewerFacade.ViewerServiceCfgBackupFolderspec))
            {
                try
                {
                    DirectoryCopy(ZFViewerFacade.ViewerServiceCfgBackupFolderspec, ZFViewerFacade.ViewerServiceCfgFolderspec);
                    isRestored = true;
                }
                catch (Exception X)
                {
                    Logger().Error("Could not restore Viewer Config files. Exception is: " + X.Message);
                    isRestored = false;
                }
            }
            return isRestored;
        }

        public static bool isZFViewerCfgBackupFilesExist()
        {
            bool isBackupFilesExist = false;

            if (Directory.Exists(ZFViewerFacade.ViewerServiceCfgBackupFolderspec))
            {
                string[] files = Directory.GetFiles(ZFViewerFacade.ViewerServiceCfgBackupFolderspec);
                if (files.Length < 2)
                {
                    isBackupFilesExist = false;
                }
                else
                {
                    isBackupFilesExist = true;
                }
            }
            return isBackupFilesExist;
        }


        #region Private methods

        private static string GetInstalledZFViewerVersion()
        {
            string version = null;
            string buildFilespec = Path.Combine(ZFViewerFacade.ViewerServiceExeFolderspec, @"BuildInfo.txt");
            if (File.Exists(buildFilespec))
            {
                using (StreamReader sr = new StreamReader(buildFilespec))
                {
                    try
                    {
                        string line = sr.ReadLine();
                        if (line != null) // safety net
                        {
                            version = line.Trim().ToLower();
                        }
                    }
                    catch (Exception ex)
                    {
                        Info("Get Image Viewer Version exception: " + ex.Message);
                    }
                    finally
                    {
                        sr.Close();
                    }
                }
            }
            else
            {
                Info("Installed Image Viewer/Render Version " + buildFilespec + " does not exist");
            }
            Info("Installed Image Viewer/Render Version is " + version);
            return version;
        }
        
        private static bool IsPrerequisiteInstalled(ZFViewerPrerequisite prerequisite)
        {
            bool isInstalled = false;
            string installedVersion = GetInstalledZFViewerVersion().ToLower();

            if (installedVersion != null && installedVersion == prerequisite.Version)
            {
                isInstalled = true;
            }

            return isInstalled;
        }

        private static ZFViewerPrerequisite GetInstalledDeprecatedZFViewerPrerequsite()
        {
            Debug.Assert(IsZFViewerInstalled() == true);
            string installedZFViewerVersion = GetInstalledZFViewerVersion();
            ZFViewerPrerequisite zfViewerPrerequisite = null;

            foreach (ZFViewerPrerequisite prerequisite in Manifest.DeprecatedZFViewerPrerequisites)
            {
                if (IsPrerequisiteInstalled(prerequisite))
                {
                    zfViewerPrerequisite = prerequisite;
                    break;
                }
            }
            return zfViewerPrerequisite;
        }

        private static void DirectoryCopy(string sourceDirName, string destDirName)
        {
            // Get the subdirectories for the specified directory.
            DirectoryInfo dir = new DirectoryInfo(sourceDirName);

            if (!dir.Exists)
            {
                throw new DirectoryNotFoundException(
                    "Source directory does not exist or could not be found: "
                    + sourceDirName);
            }

            DirectoryInfo[] dirs = dir.GetDirectories();
            // If the destination directory doesn't exist, create it.
            if (!Directory.Exists(destDirName))
            {
                Directory.CreateDirectory(destDirName);
            }

            // Get the files in the directory and copy them to the new location.
            FileInfo[] files = dir.GetFiles();
            foreach (FileInfo file in files)
            {
                string temppath = Path.Combine(destDirName, file.Name);
                file.CopyTo(temppath, true);
            }
        }

        private static bool PurgeZFViewerRenderDatabase()
        {
            bool isPurged = false;
            string userid = ConfigManager.Instance.ViewerProperties.DatabaseProperties.UserName;
            string pwd = ConfigManager.Instance.ViewerProperties.DatabaseProperties.Password;
            //string dbInstance = ConfigManager.Instance.ViewerProperties.DatabaseProperties.InstanceName;

            isPurged = MSSQLServerFacade.PurgeRenderDatabase(userid, pwd);

            if (!isPurged)
            {
                Info("Failed to purge existing Image Render Database.");
            }
            else
            {
                Info("Purged Render Database.");
            }
            return isPurged;
            }


        #endregion
    }
}
