﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.IO;
using log4net;
using Microsoft.Win32;
using System.Diagnostics;
using Vix.Viewer.Install;


namespace gov.va.med.imaging.exchange.VixInstaller.business
{
    public static class ZFViewerFacade
    {
        private static readonly String VIEWER_SERVICE_ACCOUNT_NAME = "VIX Viewer Service";
        private static readonly String RENDER_SERVICE_ACCOUNT_NAME = "VIX Render Service";

        public static VixManifest Manifest { get; set; }
        public static InfoDelegate InfoDelegate { get; set; }
        public static string ViewerPayloadFilespec { get { return Manifest.ActiveZFViewerPrerequisite.PayloadFilespec; } }
        public static string ViewerInstallPath { get { return Manifest.ActiveZFViewerPrerequisite.InstallPath; } }
        public static string ViewerServiceAccountName { get { return VIEWER_SERVICE_ACCOUNT_NAME; } }
        public static string RenderServiceAccountName { get { return RENDER_SERVICE_ACCOUNT_NAME; } }
        public static string ViewerServiceBinPath { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Viewer.Service\VIX.Viewer.Service.exe");  } }
        public static string RenderServiceBinPath { get { return Path.Combine(ZFViewerFacade.ViewerInstallPath, @"VIX.Render.Service\VIX.Render.Service.exe");  } }
 
        //private ZFViewerPrerequisite prerequisite;

        private static ILog Logger()
        {
            return LogManager.GetLogger(typeof(ZFViewerFacade).Name);
        }

        private static String Info(String infoMessage)
        {
            if (InfoDelegate != null)
            {
                InfoDelegate(infoMessage);
            }
            Logger().Info(infoMessage); // any info provided to the presentation layer will be logged.
            return infoMessage;
        }

        public static bool IsZFViewerInstalled(ref String info)
        {
            info = null;
            bool isInstalled = true;
            if (!IsZFViewerInstalled())
            {
                isInstalled = false;
                info = "The VIX Viewer/Render Services are not installed.";
            }
            else
            {
                info = "The VIX Viewer/Render Services are installed.";
            }
            return isInstalled;
        }


        //WFP-need to rework this.
        public static bool IsZFViewerInstalled()
        {
            bool isInstalled = false;

            if (Directory.Exists(ZFViewerFacade.ViewerInstallPath))
            {
                if (File.Exists(ViewerServiceBinPath))
                {
                    isInstalled = true;
                }
            }
            return isInstalled;
        }


        public static bool StartZFViewerServices()
        {
            bool isStarted = false;
            bool isViewerStarted = false;
            bool isRenderStarted = false;

            if (ConfigManager.Instance.RenderStartServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.RenderStartServiceCommand.Execute(null);
                isRenderStarted = true;
            }

            if (ConfigManager.Instance.ViewerStartServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.ViewerStartServiceCommand.Execute(null);
                isViewerStarted = true;
            }

            if (isViewerStarted && isRenderStarted)
            {
                isStarted = true;
            }
            return isStarted;

        }

                
        public static bool StopZFViewerServices()
        {
            bool isStopped = false;
            bool isViewerStopped = false;
            bool isRenderStopped = false;

            if (ConfigManager.Instance.ViewerStopServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.ViewerStopServiceCommand.Execute(null);
                isViewerStopped = true;
            }
            if (ConfigManager.Instance.RenderStopServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.RenderStopServiceCommand.Execute(null);
                isRenderStopped = true;
            }

            if (isViewerStopped && isRenderStopped)
            {
                isStopped = true;
            }
            return isStopped;
        }

        public static bool CreateZFViewerWindowsServices()
        {
            bool isCreated = false;
            bool isViewerCreated = false;
            bool isRenderCreated = false;

            if (ConfigManager.Instance.ViewerInstallServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.ViewerInstallServiceCommand.Execute(null);
                isViewerCreated = true;
            }

            if (ConfigManager.Instance.RenderInstallServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.RenderInstallServiceCommand.Execute(null);
                isRenderCreated = true;
            }

            if (isViewerCreated && isRenderCreated)
            {
                isCreated = true;
            }
            return isCreated;
        }

        public static bool DeleteZFViewerWindowsServices()
        {
            bool isDeleted = false;
            bool isViewerDeleted = false;
            bool isRenderDeleted = false;

            if (ConfigManager.Instance.ViewerUninstallServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.ViewerUninstallServiceCommand.Execute(null);
                isViewerDeleted = true;
            }

            if (ConfigManager.Instance.RenderUninstallServiceCommand.CanExecute(null))
            {
                ConfigManager.Instance.RenderUninstallServiceCommand.Execute(null);
                isRenderDeleted = true;
            }

            if (isViewerDeleted && isRenderDeleted)
            {
                isDeleted = true;
            }
            return isDeleted;
        }
    }
}
