﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Diagnostics;
using System.Threading;
using Microsoft.Win32;
using log4net;


namespace gov.va.med.imaging.exchange.VixInstaller.business
{
    public static class MSSQLServerFacade
    {

        public static VixManifest Manifest { get; set; }
        public static InfoDelegate InfoDelegate { get; set; }
        public static string SQLServerPayloadFilespec { get { return Manifest.ActiveSQLServerPrerequisite.PayloadFilespec; } }
        //public static string SQLServerInstallPath { get { return Manifest.ActiveSQLServerPrerequisite.InstallPath; } }
        private static string SQLServerPayloadRelativeFolder { get { return Manifest.ActiveSQLServerPrerequisite.PayloadRelativeFolder; } }
        private static string SQLServerPayloadUnzippedFolderSpec { get { return GetUnzippedFolderSpec(Manifest.ActiveSQLServerPrerequisite.PayloadFilespec); } }
        private static string SQLServerInstallConfigFileSpec { get { return Path.Combine(SQLServerPayloadRelativeFolder, @"ConfigurationFileInstall.ini"); } }
        private static string SQLServerUninstallConfigFileSpec { get { return Path.Combine(SQLServerPayloadRelativeFolder, @"ConfigurationFileUninstall.ini"); } }

        private static ILog Logger()
        {
            return LogManager.GetLogger(typeof(MSSQLServerFacade).Name);
        }

        private static String Info(String infoMessage)
        {
            if (InfoDelegate != null)
            {
                InfoDelegate(infoMessage);
            }
            Logger().Info(infoMessage); // any info provided to the presentation layer will be logged.
            return infoMessage;
        }


        public static bool IsMSSQLServerInstalled()
        {
            bool isInstalled = false;
            string key = null;
            RegistryView regView = RegistryView.Registry32;
            if (BusinessFacade.Is64BitOperatingSystem())
            {
                key = @"SOFTWARE\Wow6432Node\Microsoft\Microsoft SQL Server\120";
            }
            else
            {
                key = @"SOFTWARE\Microsoft\Microsoft SQL Server\120";
            }
            using (RegistryKey regKey = RegistryKey.OpenBaseKey(RegistryHive.LocalMachine, regView))
            {
                using (RegistryKey sqlserver = regKey.OpenSubKey(key, true))
                {
                    if (sqlserver != null)
                    {
                        if (sqlserver.SubKeyCount > 0) // Tomcat key hangs around after an uninstall
                        {
                            string[] subkeys = sqlserver.GetSubKeyNames();
                            foreach (string subkey in subkeys)
                            {
                                if (subkey.ToLower().StartsWith("verspecificrootdir"))
                                {
                                    isInstalled = true;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            return isInstalled;
        }


        public static bool InstallMSSQLServer()
        {
            //using Setup.exe /ConfigurationFile=MyConfigurationFile.INI for the installation

            Process externalProcess = new System.Diagnostics.Process();
            try
            {
                string installerFilespec = null;
                if (Manifest.Enable64BitInstallation)
                {
                    if (BusinessFacade.Is64BitOperatingSystem())
                    {
                        installerFilespec = Path.Combine(SQLServerPayloadUnzippedFolderSpec, @"setup.exe");
                    }
                    else
                    {
                        installerFilespec = Path.Combine(SQLServerPayloadUnzippedFolderSpec, @"setup.exe");
                    }
                }
                else
                {
                    installerFilespec = Path.Combine(SQLServerPayloadUnzippedFolderSpec, @"setup.exe");
                }

                externalProcess.StartInfo.FileName = installerFilespec;
                externalProcess.StartInfo.Arguments = @" /ConfigurationFile=" + SQLServerInstallConfigFileSpec;
                //externalProcess.StartInfo.WorkingDirectory = installerDirectory;
                externalProcess.StartInfo.UseShellExecute = false;
                //externalProcess.StartInfo.RedirectStandardError = true;
                //externalProcess.StartInfo.RedirectStandardOutput = true;
                externalProcess.StartInfo.CreateNoWindow = true;
                externalProcess.Start();
                do
                {
                    Thread.Sleep(500);
                    externalProcess.Refresh();
                } while (!externalProcess.HasExited);
            }
            finally
            {
                externalProcess.Close();
                externalProcess = null;
            }
            return IsMSSQLServerInstalled();
        }


        public static bool RemoveMSSQLServer()
        {
            Process externalProcess = new System.Diagnostics.Process();
            try
            {
                string installerFilespec = null;
                if (Manifest.Enable64BitInstallation)
                {
                    if (BusinessFacade.Is64BitOperatingSystem())
                    {
                        installerFilespec = Path.Combine(SQLServerPayloadUnzippedFolderSpec, @"setup.exe");
                    }
                    else
                    {
                        installerFilespec = Path.Combine(SQLServerPayloadUnzippedFolderSpec, @"setup.exe");
                    }
                }
                else
                {
                    installerFilespec = Path.Combine(SQLServerPayloadUnzippedFolderSpec, @"setup.exe");
                }

                externalProcess.StartInfo.FileName = installerFilespec;
                externalProcess.StartInfo.Arguments = @" /ConfigurationFile=" + SQLServerUninstallConfigFileSpec;
                //externalProcess.StartInfo.WorkingDirectory = installerDirectory;
                externalProcess.StartInfo.UseShellExecute = false;
                //externalProcess.StartInfo.RedirectStandardError = true;
                //externalProcess.StartInfo.RedirectStandardOutput = true;
                externalProcess.StartInfo.CreateNoWindow = true;
                externalProcess.Start();
                do
                {
                    Thread.Sleep(500);
                    externalProcess.Refresh();
                } while (!externalProcess.HasExited);
            }
            finally
            {
                externalProcess.Close();
                externalProcess = null;
            }
            return IsMSSQLServerInstalled();
        } 


        private static void UnzipMSSQLServerPackage()
        {
            //unzip MS SQL Server package
            ZipUtilities.UnZip(MSSQLServerFacade.SQLServerPayloadFilespec, MSSQLServerFacade.SQLServerPayloadRelativeFolder);
        }

        private static string GetUnzippedFolderSpec(string fileSpec)
        {
            string folderSpec = null;
            string[] splits = fileSpec.Split('.');
            Debug.Assert(splits.Length > 0);
            folderSpec = splits[0];

            return folderSpec;
        }

    }
}
